/*
 * $Id: Ifetch_queue_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::deallocation"
  void Ifetch_queue::deallocation (void)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE0_SIGNAL( in_ADDRESS_VAL                        ,1);
        DELETE0_SIGNAL(out_ADDRESS_ACK                        ,1);
        DELETE0_SIGNAL( in_ADDRESS_INSTRUCTION_ADDRESS        ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_ADDRESS_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr);
        DELETE0_SIGNAL( in_ADDRESS_BRANCH_STATE               ,_param->_size_branch_state   );
        DELETE0_SIGNAL( in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth          );
        DELETE0_SIGNAL(out_ADDRESS_IFETCH_QUEUE_ID            ,_param->_size_ifetch_queue_ptr);
        DELETE1_SIGNAL( in_ADDRESS_INSTRUCTION_ENABLE         ,1,_param->_nb_instruction);
      
        DELETE1_SIGNAL(out_DECOD_VAL                        ,1,_param->_nb_instruction);
        DELETE1_SIGNAL( in_DECOD_ACK                        ,1,_param->_nb_instruction);
        DELETE1_SIGNAL(out_DECOD_INSTRUCTION                ,_param->_size_instruction,_param->_nb_instruction);
        DELETE0_SIGNAL(out_DECOD_ADDRESS                    ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_DECOD_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr );
        DELETE0_SIGNAL(out_DECOD_BRANCH_STATE               ,_param->_size_branch_state    );
        DELETE0_SIGNAL(out_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth           );
        DELETE0_SIGNAL(out_DECOD_EXCEPTION                  ,_param->_size_exception_ifetch);

        DELETE0_SIGNAL( in_ICACHE_RSP_VAL        ,1);
        DELETE0_SIGNAL(out_ICACHE_RSP_ACK        ,1);
        DELETE0_SIGNAL( in_ICACHE_RSP_PACKET_ID  ,_param->_size_ifetch_queue_ptr);
        DELETE0_SIGNAL( in_ICACHE_RSP_ERROR      ,_param->_size_icache_error);
        DELETE1_SIGNAL( in_ICACHE_RSP_INSTRUCTION,_param->_size_instruction,_param->_nb_instruction);

        DELETE0_SIGNAL( in_EVENT_RESET_VAL,1);
        DELETE0_SIGNAL(out_EVENT_RESET_ACK,1);
      }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        DELETE1(internal_DECOD_VAL,_param->_nb_instruction);
       
        for (uint32_t i=0;i<_param->_size_queue; i++)
          delete _queue[i];
        delete [] _queue;
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _component;

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
