#ifdef SYSTEMC
/*
 * $Id: Meta_Predictor_Glue_genMealy_update.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::genMealy_update"
  void Meta_Predictor_Glue::genMealy_update (void)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);
    log_function(Meta_Predictor_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_update; ++i)
      {
        Thistory_t history     = PORT_READ(in_UPDATE_HISTORY     [i]);
        Tcontrol_t history_val = PORT_READ(in_UPDATE_HISTORY_VAL [i]);
        Tcontrol_t direction   = PORT_READ(in_UPDATE_DIRECTION   [i]);

        switch (_param->_nb_predictor)
          {
          case 1 :
            {
              Thistory_t history_0       =  history;
              Tcontrol_t direction_old_0 = (history_0>>_param->_predictor_history_shift_msb[0])&1;
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY     [0][i],history_0);
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY_VAL [0][i],history_val);
              PORT_WRITE(out_UPDATE_PREDICTOR_DIRECTION   [0][i],direction);
              if (_param->_predictor_update_on_prediction [0])
              PORT_WRITE(out_UPDATE_PREDICTOR_MISS        [0][i],direction xor direction_old_0);

              break;
            }
          case 3 :
            {
              /*
                dir_0 dir_1 dir_2 | good_dir  || next_dir_2
                ------------------+-----------++-----------
                  0     0     0   |     0     || no change 
                  1     0     0   |     0     ||         1 select pred_0 but miss
                  0     1     0   |     0     ||         0 select pred_0 and hit 
                  1     1     0   |     0     || no change
                  0     0     1   |     0     || no change
                  1     0     1   |     0     ||         1 select pred_1 and hit 
                  0     1     1   |     0     ||         0 select pred_1 but miss
                  1     1     1   |     0     || no change
                  0     0     0   |     1     || no change
                  1     0     0   |     1     ||         0 select pred_0 and hit 
                  0     1     0   |     1     ||         1 select pred_0 but miss
                  1     1     0   |     1     || no change
                  0     0     1   |     1     || no change
                  1     0     1   |     1     ||         0 select pred_1 but miss
                  0     1     1   |     1     ||         1 select pred_1 and hit 
                  1     1     1   |     1     || no change
                
                next_dir_2 = (good_dir and dir_1) or (not good_dir and dir_0)
              */

              Thistory_t history_0       = (history  >>_param->_predictor_history_shift    [0])&_param->_predictor_history_mask [0];
              Thistory_t history_1       = (history  >>_param->_predictor_history_shift    [1])&_param->_predictor_history_mask [1];
              Thistory_t history_2       = (history  >>_param->_predictor_history_shift    [2])&_param->_predictor_history_mask [2];
              Tcontrol_t direction_old_0 = (history_0>>_param->_predictor_history_shift_msb[0])&1;
              Tcontrol_t direction_old_1 = (history_1>>_param->_predictor_history_shift_msb[1])&1;
              Tcontrol_t direction_old_2 = (history_2>>_param->_predictor_history_shift_msb[2])&1;
              Tcontrol_t direction_new_2 = direction_old_2;

              // Test if two predictor is different
              if (direction_old_0 xor direction_old_1)
                direction_new_2 = ((    direction and direction_old_1) or 
                                   (not direction and direction_old_0));

              PORT_WRITE(out_UPDATE_PREDICTOR_DIRECTION   [0][i],direction);
              PORT_WRITE(out_UPDATE_PREDICTOR_DIRECTION   [1][i],direction);
              PORT_WRITE(out_UPDATE_PREDICTOR_DIRECTION   [2][i],direction_new_2);

              if (_param->_predictor_update_on_prediction [0])
              PORT_WRITE(out_UPDATE_PREDICTOR_MISS        [0][i],direction       xor direction_old_0);
              if (_param->_predictor_update_on_prediction [1])
              PORT_WRITE(out_UPDATE_PREDICTOR_MISS        [1][i],direction       xor direction_old_1);
              if (_param->_predictor_update_on_prediction [2])
              PORT_WRITE(out_UPDATE_PREDICTOR_MISS        [2][i],direction_new_2 xor direction_old_2);

              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY     [0][i],history_0);
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY     [1][i],history_1);
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY     [2][i],history_2);

              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY_VAL [0][i],history_val);
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY_VAL [1][i],history_val);
              PORT_WRITE(out_UPDATE_PREDICTOR_HISTORY_VAL [2][i],history_val);

              break;
            }
          default :
            { 
              break;
            }
          }
      }

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
