/*
 * $Id: Reexecute_unit_deallocation.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::deallocation"
  void Reexecute_unit::deallocation (void)
  {
    log_begin(Reexecute_unit,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL( in_EXECUTE_LOOP_VAL                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1);
        DELETE2_SIGNAL(out_EXECUTE_LOOP_ACK                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1);
        DELETE2_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID              ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_context_id  );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID            ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_front_end_id);
        DELETE2_SIGNAL( in_EXECUTE_LOOP_PACKET_ID               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_rob_ptr     );
//      DELETE2_SIGNAL( in_EXECUTE_LOOP_OPERATION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_operation   );
//      DELETE2_SIGNAL( in_EXECUTE_LOOP_TYPE                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_type        );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_FLAGS                   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_special_data);
        DELETE2_SIGNAL( in_EXECUTE_LOOP_EXCEPTION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_exception   );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1                         );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_ADDRESS                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_general_data);
        DELETE2_SIGNAL( in_EXECUTE_LOOP_DATA                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_general_data);
        
        DELETE1_SIGNAL(out_COMMIT_VAL                           ,_param->_nb_inst_commit,1);
        DELETE1_SIGNAL( in_COMMIT_ACK                           ,_param->_nb_inst_commit,1);
        DELETE1_SIGNAL(out_COMMIT_WEN                           ,_param->_nb_inst_commit,1);
//      DELETE1_SIGNAL(out_COMMIT_CONTEXT_ID                    ,_param->_nb_inst_commit,_param->_size_context_id  );
//      DELETE1_SIGNAL(out_COMMIT_FRONT_END_ID                  ,_param->_nb_inst_commit,_param->_size_front_end_id);
        DELETE1_SIGNAL(out_COMMIT_PACKET_ID                     ,_param->_nb_inst_commit,_param->_size_rob_ptr     );
//      DELETE1_SIGNAL(out_COMMIT_OPERATION                     ,_param->_nb_inst_commit,_param->_size_operation   );
//      DELETE1_SIGNAL(out_COMMIT_TYPE                          ,_param->_nb_inst_commit,_param->_size_type        );
        DELETE1_SIGNAL(out_COMMIT_FLAGS                         ,_param->_nb_inst_commit,_param->_size_special_data);
        DELETE1_SIGNAL(out_COMMIT_EXCEPTION                     ,_param->_nb_inst_commit,_param->_size_exception   );
        DELETE1_SIGNAL(out_COMMIT_NO_SEQUENCE                   ,_param->_nb_inst_commit,1                         );
        DELETE1_SIGNAL(out_COMMIT_ADDRESS                       ,_param->_nb_inst_commit,_param->_size_general_data);
        DELETE1_SIGNAL( in_COMMIT_NUM_REG_RD                    ,_param->_nb_inst_commit,_param->_size_general_register   );
        
        DELETE1_SIGNAL(out_SPR_VAL                              , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL( in_SPR_ACK                              , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL(out_SPR_WEN                              , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL(out_SPR_CONTEXT_ID                       , _param->_nb_inst_reexecute,_param->_size_context_id  );
        DELETE1_SIGNAL(out_SPR_FRONT_END_ID                     , _param->_nb_inst_reexecute,_param->_size_front_end_id);
        DELETE1_SIGNAL(out_SPR_NUM_GROUP                        , _param->_nb_inst_reexecute,_param->_size_special_address_group   );
        DELETE1_SIGNAL(out_SPR_NUM_REG                          , _param->_nb_inst_reexecute,_param->_size_special_address_register);
        DELETE1_SIGNAL(out_SPR_WDATA                            , _param->_nb_inst_reexecute,_param->_size_spr);
        DELETE1_SIGNAL( in_SPR_RDATA                            , _param->_nb_inst_reexecute,_param->_size_spr);
        DELETE1_SIGNAL( in_SPR_INVALID                          , _param->_nb_inst_reexecute,1);
        
        DELETE1_SIGNAL( in_REEXECUTE_ROB_VAL                    , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL(out_REEXECUTE_ROB_ACK                    , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL( in_REEXECUTE_ROB_CONTEXT_ID             , _param->_nb_inst_reexecute,_param->_size_context_id);
        DELETE1_SIGNAL( in_REEXECUTE_ROB_FRONT_END_ID           , _param->_nb_inst_reexecute,_param->_size_front_end_id);
        DELETE1_SIGNAL( in_REEXECUTE_ROB_PACKET_ID              , _param->_nb_inst_reexecute,_param->_size_rob_ptr  );
        DELETE1_SIGNAL( in_REEXECUTE_ROB_OPERATION              , _param->_nb_inst_reexecute,_param->_size_operation);
        DELETE1_SIGNAL( in_REEXECUTE_ROB_TYPE                   , _param->_nb_inst_reexecute,_param->_size_type);
        DELETE1_SIGNAL( in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  , _param->_nb_inst_reexecute,_param->_size_store_queue_ptr);
        
        DELETE1_SIGNAL(out_REEXECUTE_VAL                        , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL( in_REEXECUTE_ACK                        , _param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL(out_REEXECUTE_CONTEXT_ID                 , _param->_nb_inst_reexecute,_param->_size_context_id         );
        DELETE1_SIGNAL(out_REEXECUTE_FRONT_END_ID               , _param->_nb_inst_reexecute,_param->_size_front_end_id       );
        DELETE1_SIGNAL(out_REEXECUTE_PACKET_ID                  , _param->_nb_inst_reexecute,_param->_size_rob_ptr            );
        DELETE1_SIGNAL(out_REEXECUTE_OPERATION                  , _param->_nb_inst_reexecute,_param->_size_operation          );
        DELETE1_SIGNAL(out_REEXECUTE_TYPE                       , _param->_nb_inst_reexecute,_param->_size_type               );
        DELETE1_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE      , _param->_nb_inst_reexecute,_param->_size_store_queue_ptr    );
        DELETE1_SIGNAL(out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       , _param->_nb_inst_reexecute,_param->_size_load_queue_ptr     );
        DELETE1_SIGNAL(out_REEXECUTE_HAS_IMMEDIAT               , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_IMMEDIAT                   , _param->_nb_inst_reexecute,_param->_size_general_data       );
        DELETE1_SIGNAL(out_REEXECUTE_READ_RA                    , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_NUM_REG_RA                 , _param->_nb_inst_reexecute,_param->_size_general_register   );
        DELETE1_SIGNAL(out_REEXECUTE_READ_RB                    , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_NUM_REG_RB                 , _param->_nb_inst_reexecute,_param->_size_general_register   );
        DELETE1_SIGNAL(out_REEXECUTE_READ_RC                    , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_NUM_REG_RC                 , _param->_nb_inst_reexecute,_param->_size_special_register   );
        DELETE1_SIGNAL(out_REEXECUTE_WRITE_RD                   , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_NUM_REG_RD                 , _param->_nb_inst_reexecute,_param->_size_general_register   );
        DELETE1_SIGNAL(out_REEXECUTE_WRITE_RE                   , _param->_nb_inst_reexecute,1                                );
        DELETE1_SIGNAL(out_REEXECUTE_NUM_REG_RE                 , _param->_nb_inst_reexecute,_param->_size_special_register   );

        // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        for (uint32_t i=0; i<_param->_nb_bank; i++)
	  while (not _reexecute_queue [i].empty())
            {
              delete _reexecute_queue [i].front();
              _reexecute_queue [i].pop_front();
            }
        DELETE1(_reexecute_queue                ,_param->_nb_bank);
        
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        DELETE1(internal_QUEUE_PUSH             ,_param->_nb_bank);
        DELETE1(internal_QUEUE_NUM_EXECUTE_LOOP ,_param->_nb_bank);
        DELETE1(internal_QUEUE_NUM_INST_EXECUTE ,_param->_nb_bank);
        DELETE1(internal_QUEUE_NUM_INST_COMMIT  ,_param->_nb_bank);
        DELETE1(internal_QUEUE_INFO             ,_param->_nb_bank);
        DELETE1(internal_SPR_VAL                ,_param->_nb_inst_reexecute);
        DELETE1(internal_REEXECUTE_ROB_ACK      ,_param->_nb_inst_reexecute);
        DELETE1(internal_REEXECUTE_VAL          ,_param->_nb_inst_reexecute);
#ifdef STATISTICS
        DELETE1(internal_COMMIT_VAL             ,_param->_nb_inst_commit);
#endif
      }
        
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    
    delete _priority_execute_loop;
    delete _priority_queue_in    ;

    delete _component;
    
    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
