#ifdef SYSTEMC
/*
 * $Id: Reexecute_unit_genMoore.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::genMoore"
  void Reexecute_unit::genMoore (void)
  {
    log_begin(Reexecute_unit,FUNCTION);
    log_function(Reexecute_unit,FUNCTION,_name.c_str());

    // ===================================================================
    // =====[ SPR ]=======================================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
      {
	Tcontrol_t val = (not _reexecute_queue [i].empty() and
			  (_reexecute_queue [i].front()->state == STATE_SPR_ACCESS));

	if (val)
	  {
	    entry_t * entry = _reexecute_queue [i].front();

	    PORT_WRITE(out_SPR_WEN          [i],entry->spr_wen);
	    if (_param->_have_port_context_id)
	    PORT_WRITE(out_SPR_CONTEXT_ID   [i],entry->context_id);
	    if (_param->_have_port_front_end_id)
	    PORT_WRITE(out_SPR_FRONT_END_ID [i],entry->front_end_id);
	    PORT_WRITE(out_SPR_NUM_GROUP    [i],(entry->address >> _param->_shift_spr_num_group) & _param->_mask_spr_num_group);
	    PORT_WRITE(out_SPR_NUM_REG      [i],(entry->address                                ) & _param->_mask_spr_num_reg  );
	    PORT_WRITE(out_SPR_WDATA        [i],entry->data);
	  }

	internal_SPR_VAL [i] = val;
	PORT_WRITE(out_SPR_VAL [i], internal_SPR_VAL [i]);
      }

    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
