/*
 * $Id: Instance_test_use.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::test_use"
  void Instance::test_use (void)
  {
    log_begin(Configuration,FUNCTION);

    std::vector<std::string> list_not_use;

    for (list_links_t::iterator it1 = _list_links->begin();
         it1 != _list_links->end();
         ++it1)
      for (list_link_t::iterator it2 = it1->second.begin();
           it2 != it1->second.end();
           ++it2)
        {
          Link_affectation * link = it2->second;
          if (link->_use == false)
            {
              std::string str = link->_name;

              list_not_use.push_back(toString(_("Link \"%s[%s]\""),str.c_str(),link->_src.c_str()));
            }
        }

    test_use("",
             _list_parameters,
             _list_components,
             list_not_use);

    if (list_not_use.size() != 0)
      {
        std::string str = "";
        for (uint32_t i=0; i<list_not_use.size(); ++i)
          {
            str += list_not_use[i]+_("\n");
          }
        
        throw ERRORMORPHEO(FUNCTION,toString(_("A lot of parameters is not used :\n%s"),str.c_str()));
      }

    log_end(Configuration,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Instance::test_use"
  void Instance::test_use (std::string name,
                           list_parameters_t * list_parameters,
                           list_components_t * list_components,
                           std::vector<std::string> & list_not_use)
  {
    log_begin(Configuration,FUNCTION);

    for (list_parameters_t::iterator it = list_parameters->begin();
         it != list_parameters->end();
         ++it)
      {
        Parameter_affectation * param = it->second;
        if (param->_use == false)
          {
            std::string str = ((name == "")?"":(name+".")) + param->_name;

            list_not_use.push_back(toString(_("Parameter \"%s\""),str.c_str()));
          }
      }

    for (list_components_t::iterator it1 = list_components->begin();
         it1 != list_components->end();
         ++it1)
      for (list_instances_t::iterator it2 = it1->second.begin();
           it2 != it1->second.end();
           ++it2)
        {
          Instance_component * instance = it2->second;

          test_use(((name == "")?"":(name+"."))+instance->_name+"["+instance->_id+"]",
                   instance->_list_parameters,
                   instance->_list_components,
                   list_not_use);
        }

    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
