#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_execute.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_execute"
  void Core_Glue::genMealy_execute (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t EXECUTE_OOO_ENGINE_VAL   [_param->_nb_ooo_engine][_param->_max_ooo_engine_nb_execute_loop][_param->_max_nb_inst_execute];
    Tcontrol_t EXECUTE_EXECUTE_LOOP_ACK [_param->_nb_execute_loop][_param->_max_nb_write_unit];

    // init
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_ooo_engine_nb_execute_loop[i]; ++j)
        for (uint32_t k=0; k<_param->_nb_inst_execute[i][j];++k)
          EXECUTE_OOO_ENGINE_VAL [i][j][k] = 0;
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
        EXECUTE_EXECUTE_LOOP_ACK [i][j] = 0;
    

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
        {
          // Take the execute_loop.num_front_end and translate in core.num_ooo_engine
          Tcontext_t ooo_engine_id    = (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID [i][j]):0;
          Tcontext_t num_ooo_engine   = _param->_translate_execute_loop_num_ooo_engine [i][ooo_engine_id];
          Tcontext_t num_execute_loop = _param->_translate_num_execute_loop_to_ooo_engine_execute_loop_id [i][ooo_engine_id];

          EXECUTE_OOO_ENGINE_VAL   [num_ooo_engine][num_execute_loop][j] = PORT_READ(in_EXECUTE_EXECUTE_LOOP_VAL [i][j]);
          EXECUTE_EXECUTE_LOOP_ACK [i][j] = PORT_READ(in_EXECUTE_OOO_ENGINE_ACK [num_ooo_engine][num_execute_loop][j]);
 
          if (_param->_have_port_front_end_id)
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_FRONT_END_ID [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID [i][j]));
          if (_param->_have_port_context_id)
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_CONTEXT_ID   [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID   [i][j]));
          if (_param->_have_port_rob_ptr)
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_PACKET_ID    [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_PACKET_ID    [i][j]));
//        PORT_WRITE(out_EXECUTE_OOO_ENGINE_TYPE         [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_TYPE         [i][j]));
//        PORT_WRITE(out_EXECUTE_OOO_ENGINE_OPERATION    [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_OPERATION    [i][j]));
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_FLAGS        [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_FLAGS        [i][j]));
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_EXCEPTION    [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_EXCEPTION    [i][j]));
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_NO_SEQUENCE  [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE  [i][j]));
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_ADDRESS      [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_ADDRESS      [i][j]));
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_DATA         [num_ooo_engine][num_execute_loop][j], PORT_READ(in_EXECUTE_EXECUTE_LOOP_DATA         [i][j]));
        }

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_ooo_engine_nb_execute_loop[i]; ++j)
        for (uint32_t k=0; k<_param->_nb_inst_execute[i][j];++k)
          PORT_WRITE(out_EXECUTE_OOO_ENGINE_VAL [i][j][k], EXECUTE_OOO_ENGINE_VAL [i][j][k]);
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
        PORT_WRITE(out_EXECUTE_EXECUTE_LOOP_ACK [i][j], EXECUTE_EXECUTE_LOOP_ACK [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
