/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {


#undef  FUNCTION
#define FUNCTION "Direction_Glue::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");

    XML xml ("direction_glue");

    xml.balise_open("direction_glue");
    xml.singleton_begin("predictor_scheme"); xml.attribut("value",toString(_predictor_scheme)); xml.singleton_end();
    xml.singleton_begin("nb_inst_predict "); xml.attribut("value",toString(_nb_inst_predict )); xml.singleton_end();
    xml.singleton_begin("nb_inst_update  "); xml.attribut("value",toString(_nb_inst_update  )); xml.singleton_end();
//  xml.singleton_begin("size_address    "); xml.attribut("value",toString(_size_address    )); xml.singleton_end();
    xml.singleton_begin("size_history    "); xml.attribut("value",toString(_size_history    )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Direction_Glue::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Parameters & x)
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Direction_Glue,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
