#ifdef SYSTEMC
/*
 * $Id: Meta_Predictor_Glue_genMealy_update_valack.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::genMealy_update_valack"
  void Meta_Predictor_Glue::genMealy_update_valack (void)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);
    log_function(Meta_Predictor_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_update; ++i)
      {
        Tcontrol_t val = PORT_READ(in_UPDATE_VAL [i]);
        Tcontrol_t ack = true;

        for (uint32_t j=0; j<_param->_nb_predictor; ++j)
          {
            PORT_WRITE(out_UPDATE_PREDICTOR_VAL [j][i],val);

            ack &= PORT_READ(in_UPDATE_PREDICTOR_ACK [j][i]);
          }

        PORT_WRITE(out_UPDATE_ACK [i],ack);
      }

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
