/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Commit_unit,FUNCTION);

    std::string str = "";
    
    str += toString(MSG_INFORMATION)+"  * nb_front_end            : "+toString<uint32_t         >(_nb_front_end           )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    str += toString(MSG_INFORMATION)+"  * nb_context                ["+toString(i)+"] : "+toString<uint32_t         >(_nb_context [i])+"\n";//[nb_front_end]
    str += toString(MSG_INFORMATION)+"  * nb_rename_unit          : "+toString<uint32_t         >(_nb_rename_unit         )+"\n";
    str += toString(MSG_INFORMATION)+"  * size_queue              : "+toString<uint32_t         >(_size_queue             )+"\n";
    str += toString(MSG_INFORMATION)+"  * nb_bank                 : "+toString<uint32_t         >(_nb_bank                )+"\n";
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str += toString(MSG_INFORMATION)+"  * nb_inst_insert            ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_insert[i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str += toString(MSG_INFORMATION)+"  * nb_inst_retire            ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_retire[i])+"\n";//[nb_rename_unit]
    str += toString(MSG_INFORMATION)+"  * nb_inst_commit          : "+toString<uint32_t         >(_nb_inst_commit         )+"\n";
    str += toString(MSG_INFORMATION)+"  * nb_inst_reexecute       : "+toString<uint32_t         >(_nb_inst_reexecute      )+"\n";
    str += toString(MSG_INFORMATION)+"  * nb_inst_branch_complete : "+toString<uint32_t         >(_nb_inst_branch_complete)+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    for (uint32_t j=0; j<_nb_context[i]; ++j)
    str += toString(MSG_INFORMATION)+"  * nb_branch_speculated      ["+toString(i)+"]["+toString(j)+"] : "+toString<uint32_t         >(_nb_branch_speculated[i][j])+"\n";//[nb_front_end][nb_context]
    str += toString(MSG_INFORMATION)+"  * size_general_data       : "+toString<uint32_t         >(_size_general_data      )+"\n";
    str += toString(MSG_INFORMATION)+"  * size_store_queue_ptr    : "+toString<uint32_t         >(_size_store_queue_ptr   )+"\n";
    str += toString(MSG_INFORMATION)+"  * size_load_queue_ptr     : "+toString<uint32_t         >(_size_load_queue_ptr    )+"\n";
    str += toString(MSG_INFORMATION)+"  * size_general_register   : "+toString<uint32_t         >(_size_general_register  )+"\n";
    str += toString(MSG_INFORMATION)+"  * size_special_register   : "+toString<uint32_t         >(_size_special_register  )+"\n";
    str += toString(MSG_INFORMATION)+"  * priority                : "+toString<Tpriority_t      >(_priority               )+"\n";
    str += toString(MSG_INFORMATION)+"  * load_balancing          : "+toString<Tload_balancing_t>(_load_balancing         )+"\n";
    str += toString(MSG_INFORMATION)+"  * nb_rename_unit_select   : "+toString<uint32_t         >(_nb_rename_unit_select  )+"\n";
    str += toString(MSG_INFORMATION)+"  * nb_bank_access_commit   : "+toString<uint32_t         >(_nb_bank_access_commit  )+"\n";
    str += toString(MSG_INFORMATION)+"  * retire_ooo              : "+toString<retire_ooo_t     >(_retire_ooo             )+"\n";

    /*
    XML xml ("commit_unit");

    xml.balise_open("commit_unit");
    xml.singleton_begin("nb_front_end           "); xml.attribut("value",toString(_nb_front_end           )); xml.singleton_end();
    xml.singleton_begin("nb_rename_unit         "); xml.attribut("value",toString(_nb_rename_unit         )); xml.singleton_end();
    xml.singleton_begin("size_queue             "); xml.attribut("value",toString(_size_queue             )); xml.singleton_end();
    xml.singleton_begin("nb_bank                "); xml.attribut("value",toString(_nb_bank                )); xml.singleton_end();
    xml.singleton_begin("nb_inst_reexecute      "); xml.attribut("value",toString(_nb_inst_reexecute      )); xml.singleton_end();
    xml.singleton_begin("nb_inst_branch_complete"); xml.attribut("value",toString(_nb_inst_branch_complete)); xml.singleton_end();
    xml.singleton_begin("nb_inst_commit         "); xml.attribut("value",toString(_nb_inst_commit         )); xml.singleton_end();
    xml.singleton_begin("size_general_data      "); xml.attribut("value",toString(_size_general_data      )); xml.singleton_end();
    xml.singleton_begin("size_store_queue_ptr   "); xml.attribut("value",toString(_size_store_queue_ptr   )); xml.singleton_end();
    xml.singleton_begin("size_load_queue_ptr    "); xml.attribut("value",toString(_size_load_queue_ptr    )); xml.singleton_end();
    xml.singleton_begin("size_general_register  "); xml.attribut("value",toString(_size_general_register  )); xml.singleton_end();
    xml.singleton_begin("size_special_register  "); xml.attribut("value",toString(_size_special_register  )); xml.singleton_end();
    xml.singleton_begin("priority               "); xml.attribut("value",toString(_priority               )); xml.singleton_end();
    xml.singleton_begin("load_balancing         "); xml.attribut("value",toString(_load_balancing         )); xml.singleton_end();
    xml.singleton_begin("nb_rename_unit_select  "); xml.attribut("value",toString(_nb_rename_unit_select  )); xml.singleton_end();

    for (uint32_t i=0;i<_nb_front_end; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","front_end");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        xml.singleton_begin("nb_context             "); xml.attribut("value",toString(_nb_context             [i])); xml.singleton_end();

        for (uint32_t j=0;j<_nb_context [i]; j++)
          {
            xml. balise_open_begin("component");
            xml.  attribut("type","context");
            xml.  attribut("id"  ,toString(j));
            xml. balise_open_end();
            xml.singleton_begin("nb_branch_speculated   "); xml.attribut("value",toString(_nb_branch_speculated   [i][j])); xml.singleton_end();
            xml. balise_close();
          }

        xml. balise_close();
      }

    for (uint32_t i=0;i<_nb_rename_unit; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","rename_unit");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        xml.singleton_begin("nb_inst_insert         "); xml.attribut("value",toString(_nb_inst_insert         [i])); xml.singleton_end();
        xml.singleton_begin("nb_inst_retire         "); xml.attribut("value",toString(_nb_inst_retire         [i])); xml.singleton_end();
        xml. balise_close();
      }

    xml.balise_close();
    */
    log_end(Commit_unit,FUNCTION);
    

//     return xml.get_body(depth);
    return str;
  };

#undef  FUNCTION
#define FUNCTION "Commit_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
                            morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters & x)
  {
    log_begin(Commit_unit,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Commit_unit,FUNCTION);

    return output_stream;
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
