/*
 * $Id: Issue_queue.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::Issue_queue"
  Issue_queue::Issue_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Issue_queue,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Issue_queue == true
    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Function pointer
        switch (_param->_queue_scheme)
          {
          case ISSUE_QUEUE_SCHEME_IN_ORDER        :
            {
              function_transition         = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue::function_in_order_transition        ;
              function_genMoore           = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue::function_in_order_genMoore          ;
              function_genMealy_issue_in  = NULL;
              function_genMealy_issue_out = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue::function_in_order_genMealy_issue_out;
              
              break;
            }
          case ISSUE_QUEUE_SCHEME_OUT_OF_ORDER    :
            {
              function_transition         = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue::function_out_of_order_transition        ;
              function_genMoore           = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue::function_out_of_order_genMoore          ;
              function_genMealy_issue_in  = NULL;
              function_genMealy_issue_out = NULL;
              
              break;
            }
          default :
            {
              break;
            }
          }

        if (function_transition != NULL)
          {
            log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());
            
            SC_METHOD (transition);
            dont_initialize ();
            sensitive << (*(in_CLOCK)).pos();
            
# ifdef SYSTEMCASS_SPECIFIC
            // List dependency information
# endif    
          }

        if (function_genMoore != NULL)
          {
            log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());
            
            SC_METHOD (genMoore);
            dont_initialize ();
            sensitive << (*(in_CLOCK)).neg(); // need internal register
            
# ifdef SYSTEMCASS_SPECIFIC
            // List dependency information
# endif    
          }

        if (function_genMealy_issue_in != NULL)
          {
            log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - genMealy_issue_in"),_name.c_str());
            
            SC_METHOD (genMealy_issue_in);
            dont_initialize ();
            sensitive << (*(in_CLOCK)).neg(); // need internal register
            
# ifdef SYSTEMCASS_SPECIFIC
            // List dependency information
# endif    
          }

        if (function_genMealy_issue_out != NULL)
          {
            log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - genMealy_issue_out"),_name.c_str());
            
            SC_METHOD (genMealy_issue_out);
            dont_initialize ();
            sensitive << (*(in_CLOCK)).neg(); // need internal register

            if (_param->_queue_scheme == ISSUE_QUEUE_SCHEME_IN_ORDER)
              {
                for (uint32_t i=0; i<_param->_nb_inst_issue; ++i)
                  sensitive << (*(in_ISSUE_OUT_ACK [i]));
              }
            
# ifdef SYSTEMCASS_SPECIFIC
            // List dependency information
# endif    
          }

#endif
      }
    log_end(Issue_queue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Issue_queue::~Issue_queue"
  Issue_queue::~Issue_queue (void)
  {
    log_begin(Issue_queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());

    deallocation ();

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
