/*
 * $Id: Free_List_unit_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::deallocation"
  void Free_List_unit::deallocation (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_POP_VAL         ,_param->_nb_pop,1);
        DELETE1_SIGNAL(out_POP_ACK         ,_param->_nb_pop,1);
        DELETE1_SIGNAL( in_POP_GPR_VAL     ,_param->_nb_pop,1                             );
        DELETE1_SIGNAL(out_POP_GPR_NUM_REG ,_param->_nb_pop,_param->_size_general_register);
        DELETE1_SIGNAL( in_POP_SPR_VAL     ,_param->_nb_pop,1                             );
        DELETE1_SIGNAL(out_POP_SPR_NUM_REG ,_param->_nb_pop,_param->_size_special_register);

        DELETE1_SIGNAL( in_PUSH_GPR_VAL    ,_param->_nb_push,1);
        DELETE1_SIGNAL(out_PUSH_GPR_ACK    ,_param->_nb_push,1);
        DELETE1_SIGNAL( in_PUSH_GPR_NUM_REG,_param->_nb_push,_param->_size_general_register);

        DELETE1_SIGNAL( in_PUSH_SPR_VAL    ,_param->_nb_push,1);
        DELETE1_SIGNAL(out_PUSH_SPR_ACK    ,_param->_nb_push,1);
        DELETE1_SIGNAL( in_PUSH_SPR_NUM_REG,_param->_nb_push,_param->_size_special_register);

        DELETE1(_gpr_list             ,_param->_nb_bank);
        DELETE1(_spr_list             ,_param->_nb_bank);

        DELETE1(internal_POP_ACK      ,_param->_nb_pop);
        DELETE1(internal_POP_GPR_BANK ,_param->_nb_pop);
        DELETE1(internal_POP_SPR_BANK ,_param->_nb_pop);

        DELETE1(internal_PUSH_GPR_ACK ,_param->_nb_push);
        DELETE1(internal_PUSH_SPR_ACK ,_param->_nb_push);
        DELETE1(internal_PUSH_GPR_BANK,_param->_nb_push);
        DELETE1(internal_PUSH_SPR_BANK,_param->_nb_push);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _priority_gpr;
    delete _priority_spr;
    
    delete _component;
    
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
