#ifdef VHDL
/*
 * $Id: RegisterFile_Multi_Banked_vhdl_declaration.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_declaration","Begin");

    for (uint32_t i=0; i<_param->_nb_bank; i++)
      {
	for (uint32_t j=0; j<_param->_nb_port_read; j ++)
	  {
	    if (_param->_crossbar == FULL_CROSSBAR)
	      {
		for (uint32_t k=0; k<_param->_nb_port_read_by_bank; k++)
		  {
		    vhdl->set_signal ("internal_READ_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL" ,1);
		    vhdl->set_signal ("internal_SELECT_READ_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL" ,1);
		  }
	      }
	    else
	      vhdl->set_signal ("internal_SELECT_READ_"+toString(i)+"_"+toString(j)+"_VAL" ,1);
	    vhdl->set_signal ("internal_READ_"+toString(i)+"_"+toString(j)+"_VAL" ,1);
	    vhdl->set_signal ("internal_READ_"+toString(i)+"_"+toString(j)+"_ACK" ,1);
	  }
	for (uint32_t j=0; j<_param->_nb_port_read_by_bank; j ++)
	  {
	    vhdl->set_signal ("internal_BANK_READ_"+toString(i)+"_"+toString(j)+"_VAL" ,1);
	    vhdl->set_signal ("internal_BANK_READ_"+toString(i)+"_"+toString(j)+"_ACK"    ,1);
	    if (_param->_have_bank_port_address == true)
	    vhdl->set_signal ("internal_BANK_READ_"+toString(i)+"_"+toString(j)+"_ADDRESS",_param->_size_address_by_bank);
	    vhdl->set_signal ("internal_BANK_READ_"+toString(i)+"_"+toString(j)+"_DATA"   ,_param->_size_word);
	  }

	for (uint32_t j=0; j<_param->_nb_port_write; j ++)
	  {
	    if (_param->_crossbar == FULL_CROSSBAR)
	      {
		for (uint32_t k=0; k<_param->_nb_port_write_by_bank; k++)
		  {
		    vhdl->set_signal ("internal_WRITE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL" ,1);
		    vhdl->set_signal ("internal_SELECT_WRITE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL"    ,1);
		  }
	      }
	    else
	      vhdl->set_signal ("internal_SELECT_WRITE_"+toString(i)+"_"+toString(j)+"_VAL"    ,1);
	    vhdl->set_signal ("internal_WRITE_"+toString(i)+"_"+toString(j)+"_VAL" ,1);
	    vhdl->set_signal ("internal_WRITE_"+toString(i)+"_"+toString(j)+"_ACK" ,1);
	  }
	for (uint32_t j=0; j<_param->_nb_port_write_by_bank; j ++)
	  {
	    vhdl->set_signal ("internal_BANK_WRITE_"+toString(i)+"_"+toString(j)+"_VAL"    ,1);
	    vhdl->set_signal ("internal_BANK_WRITE_"+toString(i)+"_"+toString(j)+"_ACK"    ,1);
	    if (_param->_have_bank_port_address == true)
	    vhdl->set_signal ("internal_BANK_WRITE_"+toString(i)+"_"+toString(j)+"_ADDRESS",_param->_size_address_by_bank);
	    vhdl->set_signal ("internal_BANK_WRITE_"+toString(i)+"_"+toString(j)+"_DATA"   ,_param->_size_word);
	  }
      }

    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_declaration","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
