#ifdef VHDL

/*
 * $Id: Vhdl_get_library_default.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_library_default"
  std::string Vhdl::get_library_default (uint32_t depth)
  {
    log_begin(Behavioural,FUNCTION);
    
    std::string text;
    std::string str;
    
    std::stringstream it;

    it << get_library(depth);

    while (getline(it,str))
      {
        if (str.find( "ieee") != std::string::npos)
          text += str+"\n";
      }

    log_end(Behavioural,FUNCTION);

    return text;
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
