#ifdef SYSTEMC
/*
 * $Id: Simulation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Simulation.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo              {
namespace behavioural          {

  static bool          simulation_initialized;
  double              _simulation_nb_cycle;
  double              _simulation_nb_instruction;
  std::vector<double> _simulation_nb_instruction_commited;
  Model               _model;

  void simulation_init (double nb_cycle,
                        double nb_instruction)
  {
    if (not simulation_initialized)
      {
        _simulation_nb_cycle                = nb_cycle;
        _simulation_nb_instruction          = nb_instruction;
//      _simulation_nb_instruction_commited = new std::vector<double>;

        simulation_initialized = true;
      }
    else
      {
        msg_printf(WARNING,_("Multi instance of Morpheo : stop condition, take the highest."));

        if (_simulation_nb_cycle < nb_cycle)
          _simulation_nb_cycle = nb_cycle;

        if (_simulation_nb_instruction < nb_instruction)
          _simulation_nb_instruction = nb_instruction;
      }
  }
    
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
