#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_Execute_loop_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_Execute_loop_h

/*
 * $Id: Execute_loop.h 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Identification.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Execute_loop_Glue.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/include/Write_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Register_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"


namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {


  class Execute_loop 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "execute_loop_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_VAL                  ;//[nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_LOOP_IN_ACK                  ;//[nb_read_unit]
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_LOOP_IN_CONTEXT_ID           ;//[nb_read_unit]
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_LOOP_IN_FRONT_END_ID         ;//[nb_read_unit]
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ;//[nb_read_unit]
  public    : SC_IN (Tpacket_t         )   **  in_EXECUTE_LOOP_IN_PACKET_ID            ;//[nb_read_unit]
  public    : SC_IN (Toperation_t      )   **  in_EXECUTE_LOOP_IN_OPERATION            ;//[nb_read_unit]
  public    : SC_IN (Ttype_t           )   **  in_EXECUTE_LOOP_IN_TYPE                 ;//[nb_read_unit]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE;//[nb_read_unit]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ;//[nb_read_unit]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ;//[nb_read_unit]
  public    : SC_IN (Tgeneral_data_t   )   **  in_EXECUTE_LOOP_IN_IMMEDIAT             ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_READ_RA              ;//[nb_read_unit]
  public    : SC_IN (Tgeneral_address_t)   **  in_EXECUTE_LOOP_IN_NUM_REG_RA           ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_READ_RB              ;//[nb_read_unit]
  public    : SC_IN (Tgeneral_address_t)   **  in_EXECUTE_LOOP_IN_NUM_REG_RB           ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_READ_RC              ;//[nb_read_unit]
  public    : SC_IN (Tspecial_address_t)   **  in_EXECUTE_LOOP_IN_NUM_REG_RC           ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_WRITE_RD             ;//[nb_read_unit]
  public    : SC_IN (Tgeneral_address_t)   **  in_EXECUTE_LOOP_IN_NUM_REG_RD           ;//[nb_read_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_IN_WRITE_RE             ;//[nb_read_unit]
  public    : SC_IN (Tspecial_address_t)   **  in_EXECUTE_LOOP_IN_NUM_REG_RE           ;//[nb_read_unit]

    // ~~~~~[ Interface "execute_loop_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_LOOP_OUT_VAL                 ;//[nb_write_unit]
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_LOOP_OUT_ACK                 ;//[nb_write_unit]
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_LOOP_OUT_CONTEXT_ID          ;//[nb_write_unit]
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_LOOP_OUT_FRONT_END_ID        ;//[nb_write_unit]
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ;//[nb_write_unit]
  public    : SC_OUT(Tpacket_t         )   ** out_EXECUTE_LOOP_OUT_PACKET_ID           ;//[nb_write_unit]
//public    : SC_OUT(Toperation_t      )   ** out_EXECUTE_LOOP_OUT_OPERATION           ;//[nb_write_unit]
//public    : SC_OUT(Ttype_t           )   ** out_EXECUTE_LOOP_OUT_TYPE                ;//[nb_write_unit]
  public    : SC_OUT(Tspecial_data_t   )   ** out_EXECUTE_LOOP_OUT_FLAGS               ;//[nb_write_unit]
  public    : SC_OUT(Texception_t      )   ** out_EXECUTE_LOOP_OUT_EXCEPTION           ;//[nb_write_unit]
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ;//[nb_write_unit]
  public    : SC_OUT(Taddress_t        )   ** out_EXECUTE_LOOP_OUT_ADDRESS             ;//[nb_write_unit]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_EXECUTE_LOOP_OUT_DATA                ;//[nb_write_unit]

    // ~~~~~[ Interface "dcache_req"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )  *** out_DCACHE_REQ_VAL                       ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_IN (Tcontrol_t        )  ***  in_DCACHE_REQ_ACK                       ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tcontext_t        )  *** out_DCACHE_REQ_CONTEXT_ID                ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tpacket_t         )  *** out_DCACHE_REQ_PACKET_ID                 ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tdcache_address_t )  *** out_DCACHE_REQ_ADDRESS                   ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tdcache_type_t    )  *** out_DCACHE_REQ_TYPE                      ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tdcache_data_t    )  *** out_DCACHE_REQ_WDATA                     ;//[nb_load_store_queue][nb_cache_port]

    // ~~~~~[ Interface "dcache_rsp"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_DCACHE_RSP_VAL                       ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_OUT(Tcontrol_t        )  *** out_DCACHE_RSP_ACK                       ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_IN (Tcontext_t        )  ***  in_DCACHE_RSP_CONTEXT_ID                ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_IN (Tpacket_t         )  ***  in_DCACHE_RSP_PACKET_ID                 ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_IN (Tdcache_data_t    )  ***  in_DCACHE_RSP_RDATA                     ;//[nb_load_store_queue][nb_cache_port]
  public    : SC_IN (Tdcache_error_t   )  ***  in_DCACHE_RSP_ERROR                     ;//[nb_load_store_queue][nb_cache_port] 
    
    // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_VAL                       ;//[nb_ooo_engine][nb_inst_insert_rob]
  public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_ROB_ACK                       ;//[nb_ooo_engine][nb_inst_insert_rob]
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RD_USE                    ;//[nb_ooo_engine][nb_inst_insert_rob]
  public    : SC_IN (Tgeneral_address_t)  ***  in_INSERT_ROB_RD_NUM_REG                ;//[nb_ooo_engine][nb_inst_insert_rob]
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RE_USE                    ;//[nb_ooo_engine][nb_inst_insert_rob]
  public    : SC_IN (Tspecial_address_t)  ***  in_INSERT_ROB_RE_NUM_REG                ;//[nb_ooo_engine][nb_inst_insert_rob]

//     // ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_VAL                       ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_ACK                       ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_OLD_USE                ;//[nb_ooo_engine][nb_inst_retire_rob] 
//   public    : SC_IN (Tgeneral_address_t)  ***  in_RETIRE_ROB_RD_OLD_NUM_REG            ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_NEW_USE                ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tgeneral_address_t)  ***  in_RETIRE_ROB_RD_NEW_NUM_REG            ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_OLD_USE                ;//[nb_ooo_engine][nb_inst_retire_rob] 
//   public    : SC_IN (Tspecial_address_t)  ***  in_RETIRE_ROB_RE_OLD_NUM_REG            ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_NEW_USE                ;//[nb_ooo_engine][nb_inst_retire_rob]
//   public    : SC_IN (Tspecial_address_t)  ***  in_RETIRE_ROB_RE_NEW_NUM_REG            ;//[nb_ooo_engine][nb_inst_retire_rob]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::                                 Execute_loop_Glue             * _component_glue                        ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::                        Read_unit                    ** _component_read_unit                   ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Functionnal_unit             ** _component_functionnal_unit            ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit:: Load_store_unit              ** _component_load_store_unit             ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::                      Write_unit                   ** _component_write_unit                  ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::              Read_unit_to_Execution_unit   * _component_read_unit_to_execution_unit ;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::             Execution_unit_to_Write_unit  * _component_execution_unit_to_write_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::                                     Register_unit                 * _component_register_unit               ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Execute_loop);
#endif
  public  :          Execute_loop              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Execute_loop             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

};//end namespace execute_loop
};//end namespace multi_execute_loop
};//end namespace core

};//end namespace behavioural
};//end namespace morpheo              

#endif
