#ifdef SYSTEMC
/*
 * $Id: Rename_unit_Glue_genMealy_retire_event_valack.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Rename_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::genMealy_retire_event_valack"
  void Rename_unit_Glue::genMealy_retire_event_valack (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);
    log_function(Rename_unit_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      for (uint32_t j=0; j<_param->_nb_context[i]; j++)
        {
          Tcontrol_t VAL                          = PORT_READ(in_RETIRE_EVENT_VAL                          [i][j]);
          Tcontrol_t LOAD_STORE_QUEUE_POINTER_ACK = PORT_READ(in_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_ACK [i][j]);
          Tcontrol_t REGISTER_TRANSLATION_ACK     = PORT_READ(in_RETIRE_EVENT_REGISTER_TRANSLATION_ACK     [i][j]);
          
          Tcontrol_t ACK                          = (//VAL                            and
                                                       LOAD_STORE_QUEUE_POINTER_ACK   and
                                                       REGISTER_TRANSLATION_ACK     
                                                     );
          Tcontrol_t LOAD_STORE_QUEUE_POINTER_VAL = (
                                                       VAL                            and
                                                     //LOAD_STORE_QUEUE_POINTER_ACK   and
                                                       REGISTER_TRANSLATION_ACK     
                                                     );
          Tcontrol_t REGISTER_TRANSLATION_VAL     = (
                                                       VAL                            and
                                                       LOAD_STORE_QUEUE_POINTER_ACK //and
                                                     //REGISTER_TRANSLATION_ACK     
                                                     );
          
          PORT_WRITE(out_RETIRE_EVENT_ACK                          [i][j], ACK                         );
          PORT_WRITE(out_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_VAL [i][j], LOAD_STORE_QUEUE_POINTER_VAL);
          PORT_WRITE(out_RETIRE_EVENT_REGISTER_TRANSLATION_VAL     [i][j], REGISTER_TRANSLATION_VAL    );
          
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"  * retire_event [%d][%d]",i,j);
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * val (commit_unit)            (r) : %d",VAL                         );
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * ack (commit_unit)            (w) : %d",ACK                         );
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * register_translation_val     (w) : %d",REGISTER_TRANSLATION_VAL    );
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * register_translation_ack     (r) : %d",REGISTER_TRANSLATION_ACK    );
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * load_store_queue_pointer_val (w) : %d",LOAD_STORE_QUEUE_POINTER_VAL);
          log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * load_store_queue_pointer_ack (r) : %d",LOAD_STORE_QUEUE_POINTER_ACK);
        }
    
    log_end(Rename_unit_Glue,FUNCTION);
  };
  
}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
