#ifdef SYSTEMC
/*
 * $Id: Front_end_Glue_genMealy_depth.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Front_end_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {

#undef  FUNCTION
#define FUNCTION "Front_end_Glue::genMealy_depth"
  void Front_end_Glue::genMealy_depth (void)
  {
    log_begin(Front_end_Glue,FUNCTION);

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_context; ++i)
      {
        if (_param->_have_port_depth)
          {
        Tdepth_t min = PORT_READ(in_DEPTH_PREDICTION_UNIT_MIN [i]);
        PORT_WRITE(out_DEPTH_CONTEXT_STATE_MIN [i],min);
        PORT_WRITE(out_DEPTH_MIN               [i],min);
        PORT_WRITE(out_DEPTH_MAX               [i], PORT_READ(in_DEPTH_PREDICTION_UNIT_MAX [i]));
          }
        PORT_WRITE(out_DEPTH_FULL              [i], PORT_READ(in_DEPTH_PREDICTION_UNIT_FULL [i]));
      }

    for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
      for (uint32_t j=0; j<_param->_decod_unit_nb_context[i]; ++j)
        {
          uint32_t num_context = _param->_translate_context_id_from_decod_unit[i][j];
          
          PORT_WRITE(out_CONTEXT_DECOD_UNIT_DEPTH_VAL [i][j], PORT_READ(in_DEPTH_PREDICTION_UNIT_VAL     [num_context]));
          if (_param->_have_port_depth)
            {
          PORT_WRITE(out_CONTEXT_DECOD_UNIT_DEPTH     [i][j], PORT_READ(in_DEPTH_PREDICTION_UNIT_CURRENT [num_context]));
          PORT_WRITE(out_DEPTH_DECOD_UNIT_MIN         [i][j], PORT_READ(in_DEPTH_PREDICTION_UNIT_MIN     [num_context]));
          PORT_WRITE(out_DEPTH_DECOD_UNIT_MAX         [i][j], PORT_READ(in_DEPTH_PREDICTION_UNIT_MAX     [num_context]));
            }
          PORT_WRITE(out_DEPTH_DECOD_UNIT_FULL        [i][j], PORT_READ(in_DEPTH_PREDICTION_UNIT_FULL    [num_context]));
        }
      }

    log_end(Front_end_Glue,FUNCTION);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
