#include "func_math.h"
#include "func_io.h"

//-----[ Multiplication ]--------------------------------------------------

// Multiplication rapide
unsigned int mul_soft(unsigned int op1,
		      unsigned int op2)
{
  unsigned int size    = 32;
  unsigned int num_bit,carry;
  unsigned int op2_aux = op2;
  unsigned int res     = 0;
  
  for(num_bit=0;num_bit<size; num_bit++)
    {
      if (op2_aux == 0)
	break;

      carry   = op2_aux & 1;
      op2_aux = op2_aux >> 1;
      
      if (carry!=0)
	res += (op1 << num_bit);
    }
  return res;
}

unsigned int mul_hard(unsigned int op1,
		      unsigned int op2)
{
  return op1*op2;
}

//-----[ Division ]--------------------------------------------------------

unsigned int div_soft( unsigned int op1,
		       unsigned int op2)
{
  unsigned res;
  
  if (op2 == 0)
    return 0;
  
  for (res = 0; op1 >= op2; res ++)
    op1 -= op2;
  
  return res;
}

unsigned int div_hard( unsigned int op1,
		       unsigned int op2)
{
//return (op1/op2);
  return div_soft(op1,op2);
}

//-----[ Modulo ]----------------------------------------------------------

unsigned int modulo( unsigned int x,
		     unsigned int base)
{
  if (base==0)
    return 0;
  
  while(x >= base)
    x -= base;
  
  return x;
}

//-------------------------------------------------------------------------
//-----[ Test ]------------------------------------------------------------
//-------------------------------------------------------------------------

void test_mul_soft (void)
{
  if (mul_soft(0x00000000,0x00000000) != 0x00000000) quit( 1);
  if (mul_soft(0x12345678,0x00000001) != 0x12345678) quit( 2);
  if (mul_soft(0x00000025,0x000064ab) != 0x000e8cb7) quit( 3);
  if (mul_soft(0x0000083b,0x000007bd) != 0x003fb08f) quit( 4); // (0x00000000003fb08f)
  if (mul_soft(0x0000083b,0xfffff843) != 0xffc04f71) quit( 5); // (0xffffffffffc04f71)
  if (mul_soft(0xfffff7c5,0x000007bd) != 0xffc04f71) quit( 6); // (0xffffffffffc04f71)
  if (mul_soft(0xfffff7c5,0xfffff843) != 0x003fb08f) quit( 7); // (0x00000000003fb08f)
  if (mul_soft(0x017e9157,0x00d5ce37) != 0x18883bb1) quit( 8); // (0x00013f8318883bb1)
  if (mul_soft(0x017e9157,0xff2a31c9) != 0xe777c44f) quit( 9); // (0xfffec07ce777c44f)
  if (mul_soft(0xfe816ea9,0x00d5ce37) != 0xe777c44f) quit(10); // (0xfffec07ce777c44f)
  if (mul_soft(0xfe816ea9,0xff2a31c9) != 0x18883bb1) quit(11); // (0x00013f8318883bb1)
}

void test_div_soft (void)
{
/*   if (div_soft(0x00000000,0x00000001) != 0x00000000) quit( 1); */
/*   if (div_soft(0x21071981,0x00000001) != 0x21071981) quit( 2); */
/*   if (div_soft(0xdeadbeef,0x00000001) != 0xdeadbeef) quit( 3); */
  if (div_soft(4         ,2         ) != 2         ) quit( 3);
  if (div_soft(680       ,40        ) != 17        ) quit( 4);
  if (div_soft(15431115  ,9835      ) != 1569      ) quit( 5);
}

void test_modulo   (void)
{
  if (modulo(16834,563) != 507) quit(1);
}

