#ifdef SYSTEMC
/*
 * $Id: Reservation_station_allocation.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {



#undef  FUNCTION
#define FUNCTION "Reservation_station::allocation"
  void Reservation_station::allocation (void)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Reservation_station"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

     // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC0_INTERFACE_BEGIN("insert",IN,EAST,_("Input of reservation_station"));
       
       ALLOC0_VALACK_IN ( in_INSERT_VAL                  ,VAL);
       ALLOC0_VALACK_OUT(out_INSERT_ACK                  ,ACK);
       ALLOC0_SIGNAL_IN ( in_INSERT_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id      );
       ALLOC0_SIGNAL_IN ( in_INSERT_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id    );
       ALLOC0_SIGNAL_IN ( in_INSERT_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC0_SIGNAL_IN ( in_INSERT_ROB_ID               ,"rob_id"               ,Tpacket_t         ,_param->_size_rob_ptr         );
       ALLOC0_SIGNAL_IN ( in_INSERT_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation       );
       ALLOC0_SIGNAL_IN ( in_INSERT_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type            );
       ALLOC0_SIGNAL_IN ( in_INSERT_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr );
       ALLOC0_SIGNAL_IN ( in_INSERT_STORE_QUEUE_PTR_READ ,"store_queue_ptr_read" ,Tlsq_ptr_t        ,_param->_size_store_queue_ptr );
       ALLOC0_SIGNAL_IN ( in_INSERT_STORE_QUEUE_EMPTY    ,"store_queue_empty"    ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr  );
       ALLOC0_SIGNAL_IN ( in_INSERT_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data    );
//     ALLOC0_SIGNAL_IN ( in_INSERT_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_NUM_REG_RA           ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RA_VAL          ,"data_ra_val"          ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RA              ,"data_ra"              ,Tgeneral_data_t   ,_param->_size_general_data    );
//     ALLOC0_SIGNAL_IN ( in_INSERT_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_NUM_REG_RB           ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RB_VAL          ,"data_rb_val"          ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RB              ,"data_rb"              ,Tgeneral_data_t   ,_param->_size_general_data    );
//     ALLOC0_SIGNAL_IN ( in_INSERT_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_NUM_REG_RC           ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register);
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RC_VAL          ,"data_rc_val"          ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_DATA_RC              ,"data_rc"              ,Tspecial_data_t   ,_param->_size_special_data    );
       ALLOC0_SIGNAL_IN ( in_INSERT_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC0_SIGNAL_IN ( in_INSERT_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                             );
       ALLOC0_SIGNAL_IN ( in_INSERT_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);

       ALLOC0_INTERFACE_END();
     }
     
     // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("retire",OUT,WEST,_("Output of reservation_station"),_param->_nb_inst_retire);
       
       ALLOC1_VALACK_OUT(out_RETIRE_VAL                  ,VAL);
       ALLOC1_VALACK_IN ( in_RETIRE_ACK                  ,ACK);
       ALLOC1_SIGNAL_OUT(out_RETIRE_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id);
       ALLOC1_SIGNAL_OUT(out_RETIRE_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id);
       ALLOC1_SIGNAL_OUT(out_RETIRE_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_OUT(out_RETIRE_ROB_ID               ,"rob_id"               ,Tpacket_t         ,_param->_size_rob_ptr);
       ALLOC1_SIGNAL_OUT(out_RETIRE_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation);
       ALLOC1_SIGNAL_OUT(out_RETIRE_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type);
       ALLOC1_SIGNAL_OUT(out_RETIRE_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr);
       ALLOC1_SIGNAL_OUT(out_RETIRE_STORE_QUEUE_PTR_READ ,"store_queue_ptr_read" ,Tlsq_ptr_t        ,_param->_size_store_queue_ptr);
       ALLOC1_SIGNAL_OUT(out_RETIRE_STORE_QUEUE_EMPTY    ,"store_queue_empty"    ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_RETIRE_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr );
       ALLOC1_SIGNAL_OUT(out_RETIRE_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_RETIRE_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_RETIRE_DATA_RA              ,"data_ra"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_RETIRE_DATA_RB              ,"data_rb"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_RETIRE_DATA_RC              ,"data_rc"              ,Tspecial_data_t   ,_param->_size_special_data);
       ALLOC1_SIGNAL_OUT(out_RETIRE_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_RETIRE_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_OUT(out_RETIRE_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_RETIRE_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);

       ALLOC1_INTERFACE_END(_param->_nb_inst_retire);
     }
     
     // ~~~~~[ Interface : "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("gpr_write",IN,SOUTH,_("Interface with write queue to bypass the write in the RegisterFile."),_param->_nb_gpr_write);
       
       ALLOC1_VALACK_IN ( in_GPR_WRITE_VAL          ,VAL);
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

       ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
     }

    // ~~~~~[ Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("spr_write",IN,SOUTH,_("Interface with write queue to bypass the write in the RegisterFile."),_param->_nb_spr_write);
       
       ALLOC1_VALACK_IN ( in_SPR_WRITE_VAL          ,VAL);
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

       ALLOC1_INTERFACE_END(_param->_nb_spr_write);
     }

     // ~~~~~[ Interface : "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("bypass_write",IN,NORTH,_("Interface with write queue to bypass the write in the RegisterFile."),_param->_nb_bypass_write);

       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_VAL      ,"gpr_val"      ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_NUM_REG  ,"gpr_num_reg"  ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_DATA     ,"gpr_data"     ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_VAL      ,"spr_val"      ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_NUM_REG  ,"spr_num_reg"  ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_DATA     ,"spr_data"     ,Tspecial_data_t   ,_param->_size_special_data);
       
       ALLOC1_INTERFACE_END(_param->_nb_bypass_write);
     }
     
     // ~~~~~[ Interface : "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("bypass_memory",IN,NORTH,_("Interface with load/store unit to bypass the write in the RegisterFile."),_param->_nb_bypass_memory);

       ALLOC1_VALACK_IN ( in_BYPASS_MEMORY_VAL          ,VAL);
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
       
       ALLOC1_INTERFACE_END(_param->_nb_bypass_memory);
     }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    // ~~~~~[ internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   
        ALLOC1(internal_RETIRE_VAL ,Tcontrol_t,_param->_nb_inst_retire);
        ALLOC1(internal_RETIRE_SLOT,uint32_t  ,_param->_nb_inst_retire);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
    _queue_valid   = new bool [_param->_size_queue];
#else
    _queue_control = new morpheo::behavioural::generic::queue_control::Queue_Control::Queue_Control(_param->_size_queue);
#endif
    _queue         = new Treservation_station_entry_t [_param->_size_queue];

    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
