/*
 * $Id: Branch_Target_Buffer_Register_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Branch_Target_Buffer_Register.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::deallocation"
  void Branch_Target_Buffer_Register::deallocation (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL         ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_ACK         ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_CONTEXT_ID  ,_param->_nb_inst_predict,_param->_size_context_id);
        DELETE1_SIGNAL( in_PREDICT_ADDRESS     ,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE2_SIGNAL(out_PREDICT_HIT         , _param->_nb_inst_predict, _param->_associativity,1);
        DELETE2_SIGNAL(out_PREDICT_ADDRESS_SRC , _param->_nb_inst_predict, _param->_associativity,_param->_size_instruction_address);
        DELETE2_SIGNAL(out_PREDICT_ADDRESS_DEST, _param->_nb_inst_predict, _param->_associativity,_param->_size_instruction_address);
        DELETE2_SIGNAL(out_PREDICT_CONDITION   , _param->_nb_inst_predict, _param->_associativity,_param->_size_branch_state);
        DELETE2_SIGNAL(out_PREDICT_LAST_TAKE   , _param->_nb_inst_predict, _param->_associativity,1);
        DELETE2_SIGNAL(out_PREDICT_IS_ACCURATE , _param->_nb_inst_predict, _param->_associativity,1);
  
        DELETE1_SIGNAL( in_DECOD_VAL            , _param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_ACK            , _param->_nb_inst_decod,1);
        if (_param->_have_port_victim)
  	{
        DELETE1_SIGNAL(out_DECOD_HIT            , _param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_HIT_INDEX      , _param->_nb_inst_decod,_param->_size_victim);
        DELETE1_SIGNAL( in_DECOD_VICTIM         , _param->_nb_inst_decod,_param->_size_victim);
  	}
        DELETE1_SIGNAL( in_DECOD_CONTEXT_ID     , _param->_nb_inst_decod,_param->_size_context_id);
        DELETE1_SIGNAL( in_DECOD_ADDRESS_SRC    , _param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_DECOD_ADDRESS_DEST   , _param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_DECOD_CONDITION      , _param->_nb_inst_decod,_param->_size_branch_state);
        DELETE1_SIGNAL( in_DECOD_LAST_TAKE      , _param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_MISS_PREDICTION, _param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_IS_ACCURATE    , _param->_nb_inst_decod,1);
  
        DELETE1_SIGNAL( in_UPDATE_VAL            , _param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK            , _param->_nb_inst_update,1);
        if (_param->_have_port_victim)
  	{
        DELETE1_SIGNAL(out_UPDATE_HIT            , _param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_HIT_INDEX      , _param->_nb_inst_update,_param->_size_victim);
        DELETE1_SIGNAL( in_UPDATE_VICTIM         , _param->_nb_inst_update,_param->_size_victim);
  	}
        DELETE1_SIGNAL( in_UPDATE_CONTEXT_ID     , _param->_nb_inst_update,_param->_size_context_id);
        DELETE1_SIGNAL( in_UPDATE_ADDRESS_SRC    , _param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_UPDATE_ADDRESS_DEST   , _param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_UPDATE_CONDITION      , _param->_nb_inst_update,_param->_size_branch_state);
        DELETE1_SIGNAL( in_UPDATE_LAST_TAKE      , _param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_MISS_PREDICTION, _param->_nb_inst_update,1);
  
        DELETE2(reg_BTB                  ,_param->_size_bank,_param->_associativity);

        DELETE1(internal_DECOD_ACK       ,_param->_nb_inst_decod );
        DELETE1(internal_DECOD_HIT       ,_param->_nb_inst_decod );
        DELETE1(internal_DECOD_NUM_BANK  ,_param->_nb_inst_decod );
        DELETE1(internal_DECOD_NUM_ENTRY ,_param->_nb_inst_decod );
        DELETE1(internal_UPDATE_ACK      ,_param->_nb_inst_update);
        DELETE1(internal_UPDATE_HIT      ,_param->_nb_inst_update);
        DELETE1(internal_UPDATE_NUM_BANK ,_param->_nb_inst_update);
        DELETE1(internal_UPDATE_NUM_ENTRY,_param->_nb_inst_update);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
