/*
 * $Id: Return_Address_Stack.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::Return_Address_Stack"
  Return_Address_Stack::Return_Address_Stack 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

// #if DEBUG_Return_Address_Stac == true
//     log_printf(INFO,Return_Address_Stac,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Return_Address_Stack,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Return_Address_Stack,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Return_Address_Stack,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    internal_PREDICT_ACK [i] = 1;
	    PORT_WRITE(out_PREDICT_ACK [i], internal_PREDICT_ACK [i]);
	  }
    	for (uint32_t i=0; i<_param->_nb_inst_decod  ; i++)
	  {
	    internal_DECOD_ACK   [i] = 1;
	    PORT_WRITE(out_DECOD_ACK   [i], internal_DECOD_ACK   [i]);
	  }
    	for (uint32_t i=0; i<_param->_nb_inst_update ; i++)
	  {
	    internal_UPDATE_ACK  [i] = 1;
	    PORT_WRITE(out_UPDATE_ACK  [i], internal_UPDATE_ACK  [i]);
	  }

	log_printf(INFO,Return_Address_Stack,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Return_Address_Stack,FUNCTION,"Method - genMealy_decod");

	SC_METHOD (genMealy_decod);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal registers
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    if (_param->_have_port_context_id)
	    sensitive << (*( in_DECOD_CONTEXT_ID [i])); 
	    sensitive << (*( in_DECOD_PUSH       [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    if (_param->_have_port_context_id)
	    (*(out_DECOD_HIT         [i])) (*( in_DECOD_CONTEXT_ID [i]));
	    (*(out_DECOD_HIT         [i])) (*( in_DECOD_PUSH       [i]));

	    if (_param->_have_port_context_id)
	    (*(out_DECOD_ADDRESS_POP [i])) (*( in_DECOD_CONTEXT_ID [i]));
	    (*(out_DECOD_ADDRESS_POP [i])) (*( in_DECOD_PUSH       [i]));

	    if (_param->_have_port_context_id)
	    (*(out_DECOD_INDEX       [i])) (*( in_DECOD_CONTEXT_ID [i]));
	    (*(out_DECOD_INDEX       [i])) (*( in_DECOD_PUSH       [i]));
	  }
# endif

	log_printf(INFO,Return_Address_Stack,FUNCTION,"Method - genMealy_predict");

	SC_METHOD (genMealy_predict);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal registers
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    if (_param->_have_port_context_id)
	    sensitive << (*( in_PREDICT_CONTEXT_ID [i])); 
	    sensitive << (*( in_PREDICT_PUSH       [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    if (_param->_have_port_context_id)
	    (*(out_PREDICT_HIT         [i])) (*( in_PREDICT_CONTEXT_ID [i]));
	    (*(out_PREDICT_HIT         [i])) (*( in_PREDICT_PUSH       [i]));

	    if (_param->_have_port_context_id)
	    (*(out_PREDICT_ADDRESS_POP [i])) (*( in_PREDICT_CONTEXT_ID [i]));
	    (*(out_PREDICT_ADDRESS_POP [i])) (*( in_PREDICT_PUSH       [i]));

	    if (_param->_have_port_context_id)
	    (*(out_PREDICT_INDEX       [i])) (*( in_PREDICT_CONTEXT_ID [i]));
	    (*(out_PREDICT_INDEX       [i])) (*( in_PREDICT_PUSH       [i]));
	  }
# endif
#endif
      }
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::~Return_Address_Stack"
  Return_Address_Stack::~Return_Address_Stack (void)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Return_Address_Stack,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
