#ifndef morpheo_behavioural_generic_multiplier_Parameters_h
#define morpheo_behavioural_generic_multiplier_Parameters_h

/*
 * $Id: Parameters.h 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include "Behavioural/Generic/Multiplier/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace multiplier {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t             _size_data;
  public : bool                 _sign     ;
  public : uint32_t             _latency  ;
  public : uint32_t             _delay    ;

  public : Tdata_t              _mask     ;
//   public : Tdata_t              _shift_sign;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t             size_data,
                        bool                 sign     ,
                        uint32_t             latency  ,
                        uint32_t             delay    ,
                        bool is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::generic::multiplier::Parameters & x);
  };

}; // end namespace multiplier
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
