#include "../include/RamLock.h"
#include <iostream>

using namespace std;
using namespace environment;
using namespace environment::ramlock;


#define TEST(x,y)				\
  {						\
    cout << "Line " << __LINE__ << " : ";	\
    if (x==y)					\
      {						\
	cout << "Test OK";			\
      }						\
    else					\
      {						\
	cout << "Test KO";			\
	exit (EXIT_FAILURE);			\
      }						\
    cout << endl;				\
  } while (0)
    


#ifdef SYSTEMC
int sc_main (int argc, char * argv[])
#else
int    main (int argc, char * argv[])
#endif
{
  cout << "<main> Begin" << endl;

  cout << "  * Create a Ramlock with a size of 70" << endl;

  Parameters * param      = new Parameters (70);
  RamLock    * my_ramlock = new RamLock("my_ramlock",param);

  my_ramlock->reset();

  cout << *my_ramlock << endl;

  TEST (my_ramlock->read (10) , UNLOCK);  cout << *my_ramlock << endl;
  TEST (my_ramlock->read (10) ,   LOCK);  cout << *my_ramlock << endl;
  TEST (my_ramlock->write(10) ,   LOCK);  cout << *my_ramlock << endl;
  TEST (my_ramlock->write(10) , UNLOCK);  cout << *my_ramlock << endl;

  delete param      ;
  delete my_ramlock ;
  
  cout << "<main> End" << endl;

  return EXIT_SUCCESS;
}
