/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Issue_queue,FUNCTION);

    XML xml ("issue_queue");

    xml.balise_open("issue_queue");
    xml.singleton_begin("nb_context           "); xml.attribut("value",toString(_nb_context           )); xml.singleton_end();
    xml.singleton_begin("nb_front_end         "); xml.attribut("value",toString(_nb_front_end         )); xml.singleton_end();
    xml.singleton_begin("nb_rename_unit       "); xml.attribut("value",toString(_nb_rename_unit       )); xml.singleton_end();
    xml.singleton_begin("size_queue           "); xml.attribut("value",toString(_size_queue           )); xml.singleton_end();
    xml.singleton_begin("nb_bank              "); xml.attribut("value",toString(_nb_bank              )); xml.singleton_end();
//  xml.singleton_begin("size_packet          "); xml.attribut("value",toString(_size_packet          )); xml.singleton_end();
    xml.singleton_begin("size_general_data    "); xml.attribut("value",toString(_size_general_data    )); xml.singleton_end();
    xml.singleton_begin("size_special_data    "); xml.attribut("value",toString(_size_special_data    )); xml.singleton_end();
    xml.singleton_begin("size_general_register"); xml.attribut("value",toString(_size_general_register)); xml.singleton_end();
    xml.singleton_begin("size_special_register"); xml.attribut("value",toString(_size_special_register)); xml.singleton_end();
    xml.singleton_begin("size_store_queue_ptr "); xml.attribut("value",toString(_size_store_queue_ptr )); xml.singleton_end();
    xml.singleton_begin("size_load_queue_ptr  "); xml.attribut("value",toString(_size_load_queue_ptr  )); xml.singleton_end();
    xml.singleton_begin("nb_inst_issue        "); xml.attribut("value",toString(_nb_inst_issue        )); xml.singleton_end();
    xml.singleton_begin("nb_inst_reexecute    "); xml.attribut("value",toString(_nb_inst_reexecute    )); xml.singleton_end();
    xml.singleton_begin("nb_rename_unit_select"); xml.attribut("value",toString(_nb_rename_unit_select)); xml.singleton_end();
    xml.singleton_begin("priority             "); xml.attribut("value",toString(_priority             )); xml.singleton_end();
    xml.singleton_begin("load_balancing       "); xml.attribut("value",toString(_load_balancing       )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_rename_unit; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","rename_unit");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
	xml.singleton_begin("nb_inst_rename       "); xml.attribut("value",toString(_nb_inst_rename       [i])); xml.singleton_end();
        xml. balise_close();
      }
    xml.balise_close();

    log_end(Issue_queue,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Issue_queue::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters & x)
  {
    log_begin(Issue_queue,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Issue_queue,FUNCTION);

    return output_stream;
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
