#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_insert.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_insert"
  void Core_Glue::genMealy_insert (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_execute_loop_nb_ooo_engine[i]; ++j)
        {
          Tcontext_t num_ooo_engine   = _param->_translate_execute_loop_num_ooo_engine [i][j];

          for (uint32_t k=0; k<_param->_execute_loop_nb_inst_insert[i][j]; ++k)
            {
              log_printf(TRACE,Core_Glue,FUNCTION,"  * INSERT_OOO_ENGINE [%d][%d] <-> INSERT_EXECUTE_LOOP [%d][%d][%d]",num_ooo_engine,k,i,j,k);
          
              Tcontrol_t ooo_engine_val   = PORT_READ(in_INSERT_OOO_ENGINE_VAL   [num_ooo_engine][k]);
              Tcontrol_t execute_loop_ack = PORT_READ(in_INSERT_EXECUTE_LOOP_ACK [i][j][k]);
              
              Tcontrol_t execute_loop_val = ooo_engine_val  ;
              Tcontrol_t ooo_engine_ack   = execute_loop_ack;

              log_printf(TRACE,Core_Glue,FUNCTION,"    * ooo_engine_val   (r) : %d",ooo_engine_val  );
              log_printf(TRACE,Core_Glue,FUNCTION,"    * ooo_engine_ack   (w) : %d",ooo_engine_ack  );
              log_printf(TRACE,Core_Glue,FUNCTION,"    * execute_loop_val (w) : %d",execute_loop_val);
              log_printf(TRACE,Core_Glue,FUNCTION,"    * execute_loop_ack (r) : %d",execute_loop_ack);
    
              PORT_WRITE(out_INSERT_OOO_ENGINE_ACK          [num_ooo_engine][k],ooo_engine_ack  );
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_VAL        [i][j][k],execute_loop_val);
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RD_USE     [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RD_USE     [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RD_NUM_REG [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RD_NUM_REG [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RE_USE     [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RE_USE     [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RE_NUM_REG [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RE_NUM_REG [num_ooo_engine][k]));
            }
        }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
          for (uint32_t j=0; j<_param->_execute_loop_nb_ooo_engine[i]; ++j)
            {
              Tcontext_t num_ooo_engine   = _param->_translate_execute_loop_num_ooo_engine [i][j];
              
              for (uint32_t k=0; k<_param->_execute_loop_nb_inst_insert[i][j]; ++k)
                {
                  PORT_WRITE(out_INSERT_OOO_ENGINE_ACK  [num_ooo_engine][k],0);
                 PORT_WRITE(out_INSERT_EXECUTE_LOOP_VAL [i][j][k],0);
                }
            }
      }

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
