/*
 * $Id: Rename_select_allocation.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Rename_select.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {



#undef  FUNCTION
#define FUNCTION "Rename_select::allocation"
  void Rename_select::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Rename_select"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("rename_in", IN, EAST, _("output of decod's stage"), _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      
      _ALLOC2_VALACK_IN ( in_RENAME_IN_VAL           ,VAL, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_VALACK_OUT(out_RENAME_IN_ACK           ,ACK, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_FRONT_END_ID  ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id          , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_CONTEXT_ID    ,"context_id"   ,Tcontext_t        ,_param->_size_context_id            , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_DEPTH         ,"depth"        ,Tdepth_t          ,_param->_size_depth                 , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_TYPE          ,"type"         ,Ttype_t           ,_param->_size_type                  , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_OPERATION     ,"operation"    ,Toperation_t      ,_param->_size_operation             , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NO_EXECUTE    ,"no_execute"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
//    _ALLOC2_SIGNAL_IN ( in_RENAME_IN_HAVE_EVENT    ,"have_event"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_LAST_EVENT    ,"last_event"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_IS_DELAY_SLOT ,"is_delay_slot",Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
#ifdef DEBUG
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_ADDRESS       ,"address"      ,Taddress_t        ,_param->_size_instruction_address   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
#endif
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_ADDRESS_NEXT  ,"address_next" ,Taddress_t        ,_param->_size_instruction_address   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_HAS_IMMEDIAT  ,"has_immediat" ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_IMMEDIAT      ,"immediat"     ,Tgeneral_data_t   ,_param->_size_general_data          , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RA       ,"read_ra"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RA    ,"num_reg_ra"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RB       ,"read_rb"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RB    ,"num_reg_rb"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RC       ,"read_rc"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RC    ,"num_reg_rc"   ,Tspecial_address_t,_param->_size_special_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_WRITE_RD      ,"write_rd"     ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RD    ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_WRITE_RE      ,"write_re"     ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RE    ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_EXCEPTION_USE ,"exception_use",Texception_t      ,_param->_size_exception_use         , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_EXCEPTION     ,"exception"    ,Texception_t      ,_param->_size_exception             , _param->_nb_front_end, _param->_nb_inst_decod[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_inst_decod[it1]);
    }

    // ~~~~~[ Interface : "rename_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("rename_out", IN, EAST, _("output of decod's stage"), _param->_nb_inst_rename);
      
      ALLOC1_VALACK_OUT(out_RENAME_OUT_VAL           ,VAL);
      ALLOC1_VALACK_IN ( in_RENAME_OUT_ACK           ,ACK);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_FRONT_END_ID  ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_CONTEXT_ID    ,"context_id"   ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_DEPTH         ,"depth"        ,Tdepth_t          ,_param->_size_depth                 );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_TYPE          ,"type"         ,Ttype_t           ,_param->_size_type                  );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_OPERATION     ,"operation"    ,Toperation_t      ,_param->_size_operation             );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NO_EXECUTE    ,"no_execute"   ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_LAST_EVENT    ,"last_event"   ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_IS_DELAY_SLOT ,"is_delay_slot",Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_ADDRESS       ,"address"      ,Taddress_t        ,_param->_size_instruction_address   );
#endif
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_ADDRESS_NEXT  ,"address_next" ,Taddress_t        ,_param->_size_instruction_address   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_HAS_IMMEDIAT  ,"has_immediat" ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_IMMEDIAT      ,"immediat"     ,Tgeneral_data_t   ,_param->_size_general_data          );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RA       ,"read_ra"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RA    ,"num_reg_ra"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RB       ,"read_rb"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RB    ,"num_reg_rb"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RC       ,"read_rc"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RC    ,"num_reg_rc"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_WRITE_RD      ,"write_rd"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RD    ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_WRITE_RE      ,"write_re"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RE    ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_EXCEPTION_USE ,"exception_use",Texception_t      ,_param->_size_exception_use         );
      ALLOC1_SIGNAL_OUT(out_RENAME_OUT_EXCEPTION     ,"exception"    ,Texception_t      ,_param->_size_exception             );

      ALLOC1_INTERFACE_END(_param->_nb_inst_rename);
    }

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire_event", IN,NORTH, _("Retire event"), _param->_nb_front_end, _param->_nb_context[it1]);

//       _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_FLUSH         ,"flush"                ,Tcontrol_t        ,1                        , _param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_STOP          ,"stop"                 ,Tcontrol_t        ,1                        , _param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority = new generic::priority::Priority (_name+"_priority"      ,
						 _param->_priority      ,
						 _param->_load_balancing,
						 _param->_nb_front_end  ,
						 _param->_nb_inst_decod ,
						 _param->_nb_front_end_select);

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION)) 
      _component->generate_file();
#endif

    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
