#ifdef VHDL
/*
 * $Id: Queue_vhdl_declaration.cpp 103 2009-01-16 16:55:32Z moulu $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::vhdl_declaration"
  void Queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

    vhdl->set_type    ("Tqueue","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_data));
    
    vhdl->set_signal  ("reg_DATA             ", "Tqueue");

    vhdl->set_signal  ("signal_READ          ", 1);
    vhdl->set_signal  ("signal_WRITE         ", 1);
    vhdl->set_signal  ("signal_EMPTY         ", 1);
    vhdl->set_signal  ("signal_FULL          ", 1);

    if (_param->_size_queue > 1)
      {
    vhdl->set_signal  ("reg_PTR_READ         ", log2(_param->_size_queue));
    vhdl->set_signal  ("signal_NEXT_PTR_READ ", log2(_param->_size_queue));
    vhdl->set_signal  ("signal_PTR_READ      ", log2(_param->_size_queue));
    vhdl->set_signal  ("signal_PTR_WRITE     ", log2(_param->_size_queue));
      }

    if (_param->_nb_port_slot>0)
    for (uint32_t i=0; i<_param->_nb_port_slot; ++i)
    vhdl->set_signal  ("signal_SLOT_"+toString(i)+"_VAL", 1);

    if (_param->_nb_port_slot>1)
      {
    vhdl->set_signal  ("reg_NB_ELT           ", log2(_param->_size_queue+1));
    vhdl->set_signal  ("signal_NEXT_NB_ELT   ", log2(_param->_size_queue+1));
    for (uint32_t i=0; i<_param->_nb_port_slot; ++i)
    vhdl->set_signal  ("signal_SLOT_"+toString(i), log2(_param->_size_queue));
      }
    else
      {
    if (_param->_size_queue > 1)
      {
    vhdl->set_signal  ("reg_PTR_WRITE        ", log2(_param->_size_queue));
    vhdl->set_signal  ("signal_NEXT_PTR_WRITE", log2(_param->_size_queue));
      }
    vhdl->set_signal  ("reg_FULL             ", 1);
    vhdl->set_signal  ("reg_EMPTY            ", 1);
    vhdl->set_signal  ("signal_NEXT_FULL     ", 1);
    vhdl->set_signal  ("signal_NEXT_EMPTY    ", 1);
    vhdl->set_signal  ("signal_PTR_EQUAL     ", 1);
      }

    if (_param->_size_queue > 1)
      {
	vhdl->set_constant("const_PTR_INIT       ", log2(_param->_size_queue), 0);
	if (is_log2(_param->_size_queue) == false)
	  vhdl->set_constant("const_PTR_MAX        ", log2(_param->_size_queue), _param->_size_queue-1);
      }
    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
