#ifndef morpheo_behavioural_core_multi_front_end_front_end_context_state_Context_State_h
#define morpheo_behavioural_core_multi_front_end_front_end_context_state_Context_State_h

/*
 * $Id: Context_State.h 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


  class Context_State 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  private   : counter_t                     ** _stat_nb_cycle_state_ok                     ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_excep               ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_miss_branch         ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_miss_load           ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_miss_load_and_branch; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_msync               ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_psync               ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_csync               ; //[nb_context]
  private   : counter_t                     ** _stat_nb_cycle_state_ko_spr                 ; //[nb_context]
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_EVENT_VAL                   ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_EVENT_ACK                   ;//[nb_context]
//public    : SC_IN (Tcontext_t         )  **  in_BRANCH_EVENT_CONTEXT_ID            ;//[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_BRANCH_EVENT_DEPTH                 ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_EVENT_MISS_PREDICTION       ;//[nb_context]// always
  public    : SC_IN (Taddress_t         )  **  in_BRANCH_EVENT_ADDRESS_SRC           ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_EVENT_ADDRESS_DEST_VAL      ;//[nb_context]// take or not
  public    : SC_IN (Taddress_t         )  **  in_BRANCH_EVENT_ADDRESS_DEST          ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_EVENT_CAN_CONTINUE          ;//[nb_context]

    // ~~~~~[ Interface : "decod_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_EVENT_VAL                    ;//[nb_decod_unit]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_EVENT_ACK                    ;//[nb_decod_unit]
  public    : SC_IN (Tcontext_t         )  **  in_DECOD_EVENT_CONTEXT_ID             ;//[nb_decod_unit]
  public    : SC_IN (Tdepth_t           )  **  in_DECOD_EVENT_DEPTH                  ;//[nb_decod_unit]
  public    : SC_IN (Tevent_type_t      )  **  in_DECOD_EVENT_TYPE                   ;//[nb_decod_unit]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_EVENT_IS_DELAY_SLOT          ;//[nb_decod_unit]
  public    : SC_IN (Taddress_t         )  **  in_DECOD_EVENT_ADDRESS                ;//[nb_decod_unit]
  public    : SC_IN (Taddress_t         )  **  in_DECOD_EVENT_ADDRESS_EPCR           ;//[nb_decod_unit]

    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )   *  in_COMMIT_EVENT_VAL                   ;
  public    : SC_OUT(Tcontrol_t         )   * out_COMMIT_EVENT_ACK                   ;
  public    : SC_IN (Tcontext_t         )   *  in_COMMIT_EVENT_CONTEXT_ID            ;
  public    : SC_IN (Tdepth_t           )   *  in_COMMIT_EVENT_DEPTH                 ;
  public    : SC_IN (Tevent_type_t      )   *  in_COMMIT_EVENT_TYPE                  ;
  public    : SC_IN (Tcontrol_t         )   *  in_COMMIT_EVENT_IS_DELAY_SLOT         ;
  public    : SC_IN (Taddress_t         )   *  in_COMMIT_EVENT_ADDRESS               ;
  public    : SC_IN (Tcontrol_t         )   *  in_COMMIT_EVENT_ADDRESS_EPCR_VAL      ;
  public    : SC_IN (Taddress_t         )   *  in_COMMIT_EVENT_ADDRESS_EPCR          ;
  public    : SC_IN (Tcontrol_t         )   *  in_COMMIT_EVENT_ADDRESS_EEAR_VAL      ;
  public    : SC_IN (Tgeneral_data_t    )   *  in_COMMIT_EVENT_ADDRESS_EEAR          ;

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_VAL                ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_ACK                ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t         )  **  in_BRANCH_COMPLETE_CONTEXT_ID         ;//[nb_inst_branch_complete]
  public    : SC_IN (Tdepth_t           )  **  in_BRANCH_COMPLETE_DEPTH              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_MISS_PREDICTION    ;//[nb_inst_branch_complete]
//public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_TAKE               ;//[nb_inst_branch_complete]
//public    : SC_IN (Taddress_t         )  **  in_BRANCH_COMPLETE_ADDRESS_SRC        ;//[nb_inst_branch_complete]
//public    : SC_IN (Taddress_t         )  **  in_BRANCH_COMPLETE_ADDRESS_DEST       ;//[nb_inst_branch_complete]

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcounter_t         )  **  in_NB_INST_DECOD_ALL                  ;//[nb_context]
  public    : SC_IN (Tcounter_t         )  **  in_NB_INST_COMMIT_ALL                 ;//[nb_context]
  public    : SC_IN (Tcounter_t         )  **  in_NB_INST_COMMIT_MEM                 ;//[nb_context]

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_EVENT_VAL                          ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_EVENT_ACK                          ;//[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_EVENT_ADDRESS                      ;//[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_EVENT_ADDRESS_NEXT                 ;//[nb_context] 
  public    : SC_OUT(Tcontrol_t         )  ** out_EVENT_ADDRESS_NEXT_VAL             ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_EVENT_IS_DS_TAKE                   ;//[nb_context]
  public    : SC_OUT(Tevent_type_t      )  ** out_EVENT_TYPE                         ;//[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_EVENT_DEPTH                        ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_EVENT_FLUSH_ONLY                   ;//[nb_context]

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_EVENT_VAL                      ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_EVENT_ACK                      ;//[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_SPR_EVENT_EPCR                     ;//[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_SPR_EVENT_EEAR                     ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_EVENT_EEAR_WEN                 ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_EVENT_SR_DSX                   ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_EVENT_SR_TO_ESR                ;//[nb_context]

    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_CONTEXT_DECOD_ENABLE               ;//[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_CONTEXT_EVENT                      ;//[nb_context]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tdepth_t           )  **  in_DEPTH_MIN                          ;//[nb_context]

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_SR_IEE                         ;//[nb_context] - Interrupt Exception Enabled
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_SR_EPH                         ;//[nb_context] - Exception Prefix High

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_INTERRUPT_ENABLE                   ;//[nb_context] - Interrupt Exception
                                                                                     
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : context_state_t               * reg_STATE                              ;//[nb_context]
  private   : Taddress_t                    * reg_EVENT_ADDRESS                      ;//[nb_context]
  private   : Taddress_t                    * reg_EVENT_ADDRESS_EPCR                 ;//[nb_context] 
  private   : Tcontrol_t                    * reg_EVENT_ADDRESS_EPCR_VAL             ;//[nb_context]
  private   : Taddress_t                    * reg_EVENT_ADDRESS_EEAR                 ;//[nb_context] 
  private   : Tcontrol_t                    * reg_EVENT_ADDRESS_EEAR_VAL             ;//[nb_context]
  private   : Tcontrol_t                    * reg_EVENT_IS_DELAY_SLOT                ;//[nb_context]
  private   : Tcontrol_t                    * reg_EVENT_IS_DS_TAKE                   ;//[nb_context]
  private   : Tdepth_t                      * reg_EVENT_DEPTH                        ;//[nb_context]
  private   : Tcontrol_t                    * reg_EVENT_FLUSH_ONLY                   ;//[nb_context]
  private   : Tcontrol_t                    * reg_INTERRUPT_ENABLE                   ;//[nb_context]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_BRANCH_EVENT_ACK              ;//[nb_context]
  private   : Tcontrol_t                    * internal_DECOD_EVENT_ACK               ;//[nb_decod_unit]
  private   : Tcontrol_t                      internal_COMMIT_EVENT_ACK              ;
  private   : Tcontrol_t                    * internal_BRANCH_COMPLETE_ACK           ;//[nb_inst_branch_complete]
  private   : Tcontrol_t                    * internal_EVENT_VAL                     ;//[nb_context]
  private   : Tcontrol_t                    * internal_SPR_EVENT_VAL                 ;//[nb_context]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Context_State);
#endif
  public  :          Context_State              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Context_State             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_decod_event      (void);
  public  : void        genMealy_context_event    (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
