/*
 * $Id: Ifetch_queue_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {



#undef  FUNCTION
#define FUNCTION "Ifetch_queue::allocation"
  void Ifetch_queue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Ifetch_queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "address" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("address", IN, NORTH, "Transaction with PC management.");

      ALLOC0_VALACK_IN ( in_ADDRESS_VAL                        ,VAL);
      ALLOC0_VALACK_OUT(out_ADDRESS_ACK                        ,ACK);
      ALLOC0_SIGNAL_IN ( in_ADDRESS_INSTRUCTION_ADDRESS        ,"instruction_address"        ,Tgeneral_address_t ,_param->_size_instruction_address        );
      ALLOC0_SIGNAL_IN ( in_ADDRESS_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_inst_ifetch_ptr);
      ALLOC0_SIGNAL_IN ( in_ADDRESS_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state   );
      ALLOC0_SIGNAL_IN ( in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth          );
      ALLOC0_SIGNAL_OUT(out_ADDRESS_IFETCH_QUEUE_ID            ,"ifetch_queue_id"            ,Tifetch_queue_ptr_t,_param->_size_ifetch_queue_ptr);

      ALLOC0_INTERFACE_END();
    }
    {
      ALLOC1_INTERFACE_BEGIN("address", IN, NORTH, _("Transaction with PC management."),_param->_nb_instruction);

      ALLOC1_SIGNAL_IN( in_ADDRESS_INSTRUCTION_ENABLE         ,"instruction_enable"         ,Tcontrol_t         ,1);

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("decod",OUT, EAST, _("Send instruction bundle to the decod's stage."),_param->_nb_instruction);
      
      ALLOC1_VALACK_OUT(out_DECOD_VAL        ,VAL);
      ALLOC1_VALACK_IN ( in_DECOD_ACK        ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_INSTRUCTION,"instruction",Tinstruction_t,_param->_size_instruction);

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }
    {
      ALLOC0_INTERFACE_BEGIN("decod",OUT, EAST, _("Send instruction bundle to the decod's stage."));
      
      ALLOC0_SIGNAL_OUT(out_DECOD_ADDRESS                    ,"address"                    ,Tgeneral_address_t,_param->_size_instruction_address         );
      ALLOC0_SIGNAL_OUT(out_DECOD_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t,_param->_size_inst_ifetch_ptr );
      ALLOC0_SIGNAL_OUT(out_DECOD_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t   ,_param->_size_branch_state    );
      ALLOC0_SIGNAL_OUT(out_DECOD_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t ,_param->_size_depth           );
      ALLOC0_SIGNAL_OUT(out_DECOD_EXCEPTION                  ,"exception"                  ,Texception_t      ,_param->_size_exception_ifetch);

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("icache_rsp", IN, WEST, _("Respons from Instruction Cache."));
      
      ALLOC0_VALACK_IN ( in_ICACHE_RSP_VAL      ,VAL);
      ALLOC0_VALACK_OUT(out_ICACHE_RSP_ACK      ,ACK);
      ALLOC0_SIGNAL_IN ( in_ICACHE_RSP_PACKET_ID,"packet_id",Tpacket_t      ,_param->_size_ifetch_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_ICACHE_RSP_ERROR    ,"error"    ,Ticache_error_t,_param->_size_icache_error);

      ALLOC0_INTERFACE_END();
    }
    {
      ALLOC1_INTERFACE_BEGIN("icache_rsp", IN, WEST, _("Respons from Instruction Cache."),_param->_nb_instruction);
      
      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_INSTRUCTION,"instruction",Ticache_instruction_t,_param->_size_instruction);

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }

    // ~~~~~[ Interface "event_reset" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("event_reset", IN, NORTH, _("An event occure and reset queue."));

      ALLOC0_VALACK_IN ( in_EVENT_RESET_VAL,VAL);
      ALLOC0_VALACK_OUT(out_EVENT_RESET_ACK,ACK);

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Internal ] ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        ALLOC1(internal_DECOD_VAL,Tcontrol_t,_param->_nb_instruction);
        
        _queue = new ifetch_queue_entry_t * [_param->_size_queue];
        for (uint32_t i=0;i<_param->_size_queue; i++)
          _queue [i] = new ifetch_queue_entry_t (_param->_nb_instruction);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
