#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_register_address_translation_unit_Register_Address_Translation_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_register_address_translation_unit_Register_Address_Translation_unit_h

/*
 * $Id: Register_Address_Translation_unit.h 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


  class Register_Address_Translation_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_VAL               ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_ACK               ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_RENAME_FRONT_END_ID      ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_RENAME_CONTEXT_ID        ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_NUM_REG_RA_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_NUM_REG_RB_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_NUM_REG_RC_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_NUM_REG_RD_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_NUM_REG_RE_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_NUM_REG_RA_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_NUM_REG_RB_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_NUM_REG_RC_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_NUM_REG_RD_PHY_OLD;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_NUM_REG_RE_PHY_OLD;//[nb_inst_insert]

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_VAL               ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_ACK               ;//[nb_inst_insert]
//public    : SC_IN (Tcontext_t        )   **  in_INSERT_FRONT_END_ID      ;//[nb_inst_insert] = in_rename_front_end_id
//public    : SC_IN (Tcontext_t        )   **  in_INSERT_CONTEXT_ID        ;//[nb_inst_insert] = in_rename_context_id
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_WRITE_RD          ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_WRITE_RE          ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_NUM_REG_RD_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_NUM_REG_RE_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_NUM_REG_RD_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_NUM_REG_RE_PHY    ;//[nb_inst_insert]

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_VAL               ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_ACK               ;//[nb_inst_retire]
  public    : SC_IN (Tcontext_t        )   **  in_RETIRE_FRONT_END_ID      ;//[nb_inst_retire]
  public    : SC_IN (Tcontext_t        )   **  in_RETIRE_CONTEXT_ID        ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_WRITE_RD          ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_WRITE_RE          ;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RD_LOG    ;//[nb_inst_retire]
  public    : SC_IN (Tspecial_address_t)   **  in_RETIRE_NUM_REG_RE_LOG    ;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RD_PHY_NEW;//[nb_inst_retire]
  public    : SC_IN (Tspecial_address_t)   **  in_RETIRE_NUM_REG_RE_PHY_NEW;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RESTORE_RD_PHY_OLD;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RESTORE_RE_PHY_OLD;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RESTORE           ;//[nb_inst_retire]

    // ~~~~~[ Interface "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_EVENT_VAL            ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_EVENT_ACK            ;//[nb_front_end][nb_context]
  public    : SC_IN (Tevent_state_t    )  ***  in_RETIRE_EVENT_STATE          ;//[nb_front_end][nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : Tgeneral_address_t          *** rat_gpr_not_speculative;      //[nb_front_end][nb_context][nb_general_register_logic]
  private   : Tgeneral_address_t          *** rat_gpr_speculative;          //[nb_front_end][nb_context][nb_general_register_logic]
  private   : bool                        *** rat_gpr_speculative_valid;    //[nb_front_end][nb_context][nb_general_register_logic]
  private   : bool                        *** rat_gpr_update_table;         //[nb_front_end][nb_context][nb_general_register_logic]

  private   : Tspecial_address_t          *** rat_spr_not_speculative;      //[nb_front_end][nb_context][nb_special_register_logic]
  private   : Tspecial_address_t          *** rat_spr_speculative;          //[nb_front_end][nb_context][nb_special_register_logic]
  private   : bool                        *** rat_spr_speculative_valid;    //[nb_front_end][nb_context][nb_special_register_logic]
  private   : bool                        *** rat_spr_update_table;         //[nb_front_end][nb_context][nb_special_register_logic]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_RENAME_ACK;          //[nb_inst_insert]
  private   : Tcontrol_t                    * internal_INSERT_ACK;          //[nb_inst_insert]
  private   : Tcontrol_t                    * internal_RETIRE_ACK;          //[nb_inst_retire]
  private   : Tcontrol_t                   ** internal_RETIRE_EVENT_ACK    ;//[nb_front_end][nb_context]

  private   : bool                        *** internal_rat_gpr_update_table;//[nb_front_end][nb_context][nb_general_register_logic]
  private   : bool                        *** internal_rat_spr_update_table;//[nb_front_end][nb_context][nb_special_register_logic]

  private   : Tcontrol_t                    * internal_RETIRE_RESTORE           ;//[nb_inst_retire]
  private   : Tcontrol_t                    * internal_RETIRE_RESTORE_RD_PHY_OLD;//[nb_inst_retire]
  private   : Tcontrol_t                    * internal_RETIRE_RESTORE_RE_PHY_OLD;//[nb_inst_retire]

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Register_Address_Translation_unit);
#endif
  public  :          Register_Address_Translation_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Register_Address_Translation_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_rename           (void);
  public  : void        genMealy_retire           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
