/*
 * $Id: Parameters_msg_error.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Parameters.h"
#include <sstream>
#include <set>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {


#undef  FUNCTION
#define FUNCTION "Execute_loop::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Execute_loop,FUNCTION,"Begin");

    Parameters_test test ("Execute_loop");

    for (uint32_t i=0; i<_nb_functionnal_unit; i++)
      if (_nb_inst_functionnal_unit [i] != 1)
	test.error(toString(_("Functionnal_unit [%d] must treat once instruction.\n"),i));

    std::set<uint32_t> link_load_store_unit_and_write_unit [_nb_load_store_unit];
    for (uint32_t i=0; i<_nb_load_store_unit; ++i)
      link_load_store_unit_and_write_unit[i].clear();

    for (uint32_t i=0; i<_nb_execute_unit; i++)
      if (_is_load_store_unit [i])
        {
          uint32_t lsq = _translate_num_execute_unit[i];

          for (uint32_t j=0; j<_nb_execute_unit_port[i]; j++)
            for (uint32_t k=0; k<_nb_write_unit; k++)
              if (_execution_unit_to_write_unit_table_routing [i][j][k])
                {
                  if (link_load_store_unit_and_write_unit[lsq].find(k) != link_load_store_unit_and_write_unit[lsq].end())
                    {
                      if (link_load_store_unit_and_write_unit[lsq].size() != 0)
                        test.error(toString(_("Can't connect Load Store Unit [%d] (port %d) with Write unit [%d], because it's already connected with Write unit [%d]"),lsq,j,k,*(link_load_store_unit_and_write_unit[lsq].begin())));

                      link_load_store_unit_and_write_unit[lsq].insert(link_load_store_unit_and_write_unit[lsq].end(),k);
                    }
                }
        }
    log_printf(FUNC,Execute_loop,FUNCTION,"End");

    return test;
  };

}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
