/*
 * $Id: RegisterFile_Monolithic_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::allocation (void)
  {
    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name                   
					     ,"RegisterFile_Monolithic"
#ifdef POSITION
					     ,REGISTER                 
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN
							 ,SOUTH
							 ,_("Generalist interface")
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    { 
      ALLOC1_INTERFACE_BEGIN("read",IN,WEST,_("Interface Read"),_param->_nb_port_read);

      ALLOC1_VALACK_IN ( in_READ_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_READ_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_READ_ADDRESS,"address",Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_READ_DATA   ,"data"   ,Tdata_t   ,_param->_size_word);

      ALLOC1_INTERFACE_END(_param->_nb_port_read);
    }

    // ~~~~~[ Interface : "write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("write",IN,EAST,_("Interface Write"),_param->_nb_port_write);

      ALLOC1_VALACK_IN ( in_WRITE_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_WRITE_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_WRITE_ADDRESS,"address",Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_WRITE_DATA   ,"data"   ,Tdata_t   ,_param->_size_word);

      ALLOC1_INTERFACE_END(_param->_nb_port_write);
    }

    // ~~~~~[ Interface : "read_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    { 
      ALLOC1_INTERFACE_BEGIN("read_write",IN,WEST,_("Interface Read_Write"),_param->_nb_port_read_write);

      ALLOC1_VALACK_IN ( in_READ_WRITE_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_READ_WRITE_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_READ_WRITE_RW     ,"rw"     ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_READ_WRITE_ADDRESS,"address",Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_READ_WRITE_WDATA  ,"wdata"  ,Tdata_t   ,_param->_size_word);
      ALLOC1_SIGNAL_OUT(out_READ_WRITE_RDATA  ,"rdata"  ,Tdata_t   ,_param->_size_word);

      ALLOC1_INTERFACE_END(_param->_nb_port_read_write);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      ALLOC1(reg_DATA,Tdata_t,_param->_nb_word);
    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
