#ifndef morpheo_behavioural_generic_registerfile_RegisterFile_h
#define morpheo_behavioural_generic_registerfile_RegisterFile_h

/*
 * $Id: RegisterFile.h 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

#include "Behavioural/Generic/RegisterFile/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {


  class RegisterFile 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ----- Interface Read
  public    : SC_IN       (Tcontrol_t)     **  in_READ_VAL     ;
  public    : SC_OUT      (Tcontrol_t)     ** out_READ_ACK     ;
  public    : SC_IN       (Taddress_t)     **  in_READ_ADDRESS ;
  public    : SC_OUT      (Tdata_t)        ** out_READ_DATA    ;

    // ----- Interface Write
  public    : SC_IN       (Tcontrol_t)     **  in_WRITE_VAL    ;
  public    : SC_OUT      (Tcontrol_t)     ** out_WRITE_ACK    ;
  public    : SC_IN       (Taddress_t)     **  in_WRITE_ADDRESS;
  public    : SC_IN       (Tdata_t)        **  in_WRITE_DATA   ;

#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::RegisterFile_Monolithic  ::RegisterFile_Monolithic   * component_RegisterFile_Monolithic  ;
  protected : morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::RegisterFile_Multi_Banked * component_RegisterFile_Multi_Banked;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (RegisterFile);
#endif
  public  :          RegisterFile              (
#ifdef SYSTEMC
						sc_module_name                              name,
#else					       
						std::string                                      name,
#endif					       
#ifdef STATISTICS
						morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
						Parameters                                  * param ,
						Tusage_t usage);
    
  public  :          ~RegisterFile             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (
#ifdef STATISTICS
						morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						void
#endif
						);
  private : void     deallocation              (void);
#endif					       
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
