#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_Parameters_h

/*
 * $Id: Parameters.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"


namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_inst_predict           ;
  public : uint32_t   _nb_inst_update            ;
  public : uint32_t   _size_address              ;
  public : bool       _have_bht               [3];
  public : uint32_t   _bht_size_shifter       [3];
  public : uint32_t   _bht_nb_shifter         [3];
  public : bool       _have_pht               [3];
  public : uint32_t   _pht_size_counter       [3];
  public : uint32_t   _pht_nb_counter         [3];
  public : uint32_t   _pht_size_address_share [3];
                     
  public : bool       _have_meta_predictor       ;
  public : uint32_t   _nb_predictor              ;

  public : bool     * _predictor_update_on_prediction;//[nb_predictor]
  public : uint32_t * _predictor_size_history        ;//[nb_predictor]
  public : uint32_t   _size_history                  ;
                        
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::Parameters ** _param_two_level_branch_predictor;//[nb_predictor]
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue       ::Parameters  * _param_glue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t nb_inst_predict           ,
			uint32_t nb_inst_update            ,
			uint32_t size_address              ,
                        bool     have_bht               [3],
			uint32_t bht_size_shifter       [3],
			uint32_t bht_nb_shifter         [3],
			bool     have_pht               [3],
			uint32_t pht_size_counter       [3],
			uint32_t pht_nb_counter         [3],
			uint32_t pht_size_address_share [3],
                        bool     is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output,
                                              morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::Parameters & x);
  };

}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
