/*
 * $Id: top_allocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Queue/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"

void top::allocation (void)
{
  if (setlocale (LC_ALL, "") == NULL)
    msgWarning(_("setlocale ko.\n"));

  try 
    {
      _param->test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msgError(_("<%s> : %s"),name.c_str(),error.what());
      return;
    }
  catch (...)
    {
      msgError(_("<%s> : This test must generate a error"),name.c_str());
      exit (EXIT_FAILURE);
    }

  _usage = USE_ALL;
//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

#ifdef STATISTICS
  if (usage_is_set(_usage,USE_STATISTICS))
  _param_stat = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  component = new Queue 
    (name.c_str(),
#ifdef STATISTICS
     _param_stat,
#endif
     _param,
     _usage
     );
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  msgInformation(_("<%s> : Create signal.\n"),name.c_str());

  in_CLOCK  = new sc_clock ("clock", TIME_PERIOD, TIME_UNIT, 0.5); //name,period,time_unit,duty_cycle

  ALLOC0_SC_SIGNAL( in_NRESET     ," in_NRESET"     ,Tcontrol_t);

  ALLOC0_SC_SIGNAL( in_INSERT_VAL , "in_INSERT_VAL" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_INSERT_ACK ,"out_INSERT_ACK" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_INSERT_DATA, "in_INSERT_DATA",Tdata_t   );
  ALLOC0_SC_SIGNAL(out_RETIRE_VAL ,"out_RETIRE_VAL" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_RETIRE_ACK , "in_RETIRE_ACK" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_RETIRE_DATA,"out_RETIRE_DATA",Tdata_t   );
  ALLOC1_SC_SIGNAL(out_SLOT_VAL   ,"out_SLOT_VAL"   ,Tcontrol_t,_param->_nb_port_slot);
  ALLOC1_SC_SIGNAL(out_SLOT_DATA  ,"out_SLOT_DATA"  ,Tdata_t   ,_param->_nb_port_slot);
  ALLOC0_SC_SIGNAL(out_PTR_WRITE  ,"out_PTR_WRITE"  ,Tptr_t    );
  ALLOC0_SC_SIGNAL(out_PTR_READ   ,"out_PTR_READ"   ,Tptr_t    );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msgInformation(_("<%s> : Instanciation of _Queue.\n"),name.c_str());

  INSTANCE0_SC_SIGNAL(component, in_CLOCK);
  INSTANCE0_SC_SIGNAL(component, in_NRESET);

  INSTANCE0_SC_SIGNAL(component, in_INSERT_VAL );
  INSTANCE0_SC_SIGNAL(component,out_INSERT_ACK );
  INSTANCE0_SC_SIGNAL(component, in_INSERT_DATA);
  INSTANCE0_SC_SIGNAL(component,out_RETIRE_VAL );
  INSTANCE0_SC_SIGNAL(component, in_RETIRE_ACK );
  INSTANCE0_SC_SIGNAL(component,out_RETIRE_DATA);
  INSTANCE1_SC_SIGNAL(component,out_SLOT_VAL   ,_param->_nb_port_slot);
  INSTANCE1_SC_SIGNAL(component,out_SLOT_DATA  ,_param->_nb_port_slot);
  if (_param->_have_port_ptr_write)
  INSTANCE0_SC_SIGNAL(component,out_PTR_WRITE  );
  if (_param->_have_port_ptr_read )
  INSTANCE0_SC_SIGNAL(component,out_PTR_READ   );
    }
#endif
}
