/*
 * $Id: main.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/SelfTest/include/test.h"

#define NB_PARAMS 4

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                                               (uint32_t)\n"));
  err (_(" * nb_context                       [nb_front_end]            (uint32_t)\n"));
  err (_(" * nb_load_store_queue                                        (uint32_t)\n"));
  err (_(" * size_store_queue                 [nb_load_store_queue]     (uint32_t)\n"));
  err (_(" * size_load_queue                  [nb_load_store_queue]     (uint32_t)\n"));
  err (_(" * nb_inst_memory                   [nb_load_store_queue]     (uint32_t)\n"));
  err (_(" * link_load_store_unit_with_thread [nb_front_end][nb_context](uint32_t)\n"));
  err (_(" * nb_inst_insert                                             (uint32_t)\n"));
  err (_(" * nb_inst_retire                                             (uint32_t)\n"));
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t    _nb_front_end                     = atoi(argv[x++]);

  if (argc < static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);

  uint32_t  * _nb_context                       = new uint32_t [_nb_front_end];
  uint32_t    nb_thread = 0;
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _nb_context [i] = atoi(argv[x++]);
      nb_thread += _nb_context [i];
    }

  uint32_t    _nb_load_store_queue              = fromString<uint32_t>(argv[x++]);
  
  if (argc != static_cast<int>(2+NB_PARAMS+_nb_front_end+3*_nb_load_store_queue+nb_thread))
    usage (argc, argv);

  uint32_t  * _size_store_queue                 = new uint32_t [_nb_load_store_queue];
  uint32_t  * _size_load_queue                  = new uint32_t [_nb_load_store_queue];
  uint32_t  * _nb_inst_memory                   = new uint32_t [_nb_load_store_queue];
  
  for (uint32_t i=0; i<_nb_load_store_queue; i++)
    _size_store_queue [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_load_store_queue; i++)
    _size_load_queue  [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_load_store_queue; i++)
    _nb_inst_memory   [i] = atoi(argv[x++]);
  
  uint32_t ** _link_load_store_unit_with_thread = new uint32_t * [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _link_load_store_unit_with_thread [i] = new uint32_t [_nb_context[i]];
      for (uint32_t j=0; j<_nb_context[i]; j++)
	_link_load_store_unit_with_thread [i][j] = atoi(argv[x++]);
    }

  uint32_t _nb_inst_insert = atoi(argv[x++]);
  uint32_t _nb_inst_retire = atoi(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters
	(_nb_front_end                    ,
	 _nb_context                      ,
	 _nb_load_store_queue             ,
	 _size_store_queue                ,
	 _size_load_queue                 ,
	 _nb_inst_memory                  ,
	 _link_load_store_unit_with_thread,
	 _nb_inst_insert                  ,
	 _nb_inst_retire                  ,
         true //is_toplevel
         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
