/*
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/*
** cdefBF54x_base.h
**
** Copyright (C) 2008 Analog Devices, Inc.
**
************************************************************************************
**
** This include file contains a list of macro "defines" to enable the programmer
** to use symbolic names for the registers common to the ADSP-BF54x peripherals.
**
***************************************************************/

#ifndef _CDEF_BF54X_H
#define _CDEF_BF54X_H

#include <defBF54x_base.h>

/* ************************************************************** */
/*   SYSTEM & MMR ADDRESS DEFINITIONS COMMON TO ALL ADSP-BF54x    */
/* ************************************************************** */

/* PLL Registers */

#define                          pPLL_CTL ((volatile unsigned short *)PLL_CTL)
#define                          pPLL_DIV ((volatile unsigned short *)PLL_DIV)
#define                           pVR_CTL ((volatile unsigned short *)VR_CTL)
#define                         pPLL_STAT ((volatile unsigned short *)PLL_STAT)
#define                      pPLL_LOCKCNT ((volatile unsigned short *)PLL_LOCKCNT)

/* Debug/MP/Emulation Registers (0xFFC00014 - 0xFFC00014) */

#define                           pCHIPID ((volatile unsigned long *)CHIPID)

/* System Reset and Interrupt Controller (0xFFC00100 - 0xFFC00104) */

#define                            pSWRST ((volatile unsigned short *)SWRST)
#define                            pSYSCR ((volatile unsigned short *)SYSCR)

/* SIC Registers */

#define                       pSIC_IMASK0 ((volatile unsigned long *)SIC_IMASK0)
#define                       pSIC_IMASK1 ((volatile unsigned long *)SIC_IMASK1)
#define                       pSIC_IMASK2 ((volatile unsigned long *)SIC_IMASK2)
#define                         pSIC_ISR0 ((volatile unsigned long *)SIC_ISR0)
#define                         pSIC_ISR1 ((volatile unsigned long *)SIC_ISR1)
#define                         pSIC_ISR2 ((volatile unsigned long *)SIC_ISR2)
#define                         pSIC_IWR0 ((volatile unsigned long *)SIC_IWR0)
#define                         pSIC_IWR1 ((volatile unsigned long *)SIC_IWR1)
#define                         pSIC_IWR2 ((volatile unsigned long *)SIC_IWR2)
#define                         pSIC_IAR0 ((volatile unsigned long *)SIC_IAR0)
#define                         pSIC_IAR1 ((volatile unsigned long *)SIC_IAR1)
#define                         pSIC_IAR2 ((volatile unsigned long *)SIC_IAR2)
#define                         pSIC_IAR3 ((volatile unsigned long *)SIC_IAR3)
#define                         pSIC_IAR4 ((volatile unsigned long *)SIC_IAR4)
#define                         pSIC_IAR5 ((volatile unsigned long *)SIC_IAR5)
#define                         pSIC_IAR6 ((volatile unsigned long *)SIC_IAR6)
#define                         pSIC_IAR7 ((volatile unsigned long *)SIC_IAR7)
#define                         pSIC_IAR8 ((volatile unsigned long *)SIC_IAR8)
#define                         pSIC_IAR9 ((volatile unsigned long *)SIC_IAR9)
#define                        pSIC_IAR10 ((volatile unsigned long *)SIC_IAR10)
#define                        pSIC_IAR11 ((volatile unsigned long *)SIC_IAR11)

/* Watchdog Timer Registers */

#define                         pWDOG_CTL ((volatile unsigned short *)WDOG_CTL)
#define                         pWDOG_CNT ((volatile unsigned long *)WDOG_CNT)
#define                        pWDOG_STAT ((volatile unsigned long *)WDOG_STAT)

/* RTC Registers */

#define                         pRTC_STAT ((volatile unsigned long *)RTC_STAT)
#define                         pRTC_ICTL ((volatile unsigned short *)RTC_ICTL)
#define                        pRTC_ISTAT ((volatile unsigned short *)RTC_ISTAT)
#define                        pRTC_SWCNT ((volatile unsigned short *)RTC_SWCNT)
#define                        pRTC_ALARM ((volatile unsigned long *)RTC_ALARM)
#define                         pRTC_PREN ((volatile unsigned short *)RTC_PREN)

/* UART0 Registers */

#define                        pUART0_DLL ((volatile unsigned short *)UART0_DLL)
#define                        pUART0_DLH ((volatile unsigned short *)UART0_DLH)
#define                       pUART0_GCTL ((volatile unsigned short *)UART0_GCTL)
#define                        pUART0_LCR ((volatile unsigned short *)UART0_LCR)
#define                        pUART0_MCR ((volatile unsigned short *)UART0_MCR)
#define                        pUART0_LSR ((volatile unsigned short *)UART0_LSR)
#define                        pUART0_MSR ((volatile unsigned short *)UART0_MSR)
#define                        pUART0_SCR ((volatile unsigned short *)UART0_SCR)
#define                    pUART0_IER_SET ((volatile unsigned short *)UART0_IER_SET)
#define                  pUART0_IER_CLEAR ((volatile unsigned short *)UART0_IER_CLEAR)
#define                        pUART0_THR ((volatile unsigned short *)UART0_THR)
#define                        pUART0_RBR ((volatile unsigned short *)UART0_RBR)

/* SPI0 Registers */

#define                         pSPI0_CTL ((volatile unsigned short *)SPI0_CTL)
#define                         pSPI0_FLG ((volatile unsigned short *)SPI0_FLG)
#define                        pSPI0_STAT ((volatile unsigned short *)SPI0_STAT)
#define                        pSPI0_TDBR ((volatile unsigned short *)SPI0_TDBR)
#define                        pSPI0_RDBR ((volatile unsigned short *)SPI0_RDBR)
#define                        pSPI0_BAUD ((volatile unsigned short *)SPI0_BAUD)
#define                      pSPI0_SHADOW ((volatile unsigned short *)SPI0_SHADOW)

/* Timer Group of 3 registers are not defined in the shared file because they are not available on the ADSP-BF542 processor */

/* Two Wire Interface Registers (TWI0) */

#define                      pTWI0_CLKDIV ((volatile unsigned short *)TWI0_CLKDIV)
#define                     pTWI0_CONTROL ((volatile unsigned short *)TWI0_CONTROL)
#define                   pTWI0_SLAVE_CTL ((volatile unsigned short *)TWI0_SLAVE_CTL)
#define                  pTWI0_SLAVE_STAT ((volatile unsigned short *)TWI0_SLAVE_STAT)
#define                  pTWI0_SLAVE_ADDR ((volatile unsigned short *)TWI0_SLAVE_ADDR)
#define                  pTWI0_MASTER_CTL ((volatile unsigned short *)TWI0_MASTER_CTL)
#define                 pTWI0_MASTER_STAT ((volatile unsigned short *)TWI0_MASTER_STAT)
#define                 pTWI0_MASTER_ADDR ((volatile unsigned short *)TWI0_MASTER_ADDR)
#define                    pTWI0_INT_STAT ((volatile unsigned short *)TWI0_INT_STAT)
#define                    pTWI0_INT_MASK ((volatile unsigned short *)TWI0_INT_MASK)
#define                    pTWI0_FIFO_CTL ((volatile unsigned short *)TWI0_FIFO_CTL)
#define                   pTWI0_FIFO_STAT ((volatile unsigned short *)TWI0_FIFO_STAT)
#define                   pTWI0_XMT_DATA8 ((volatile unsigned short *)TWI0_XMT_DATA8)
#define                  pTWI0_XMT_DATA16 ((volatile unsigned short *)TWI0_XMT_DATA16)
#define                   pTWI0_RCV_DATA8 ((volatile unsigned short *)TWI0_RCV_DATA8)
#define                  pTWI0_RCV_DATA16 ((volatile unsigned short *)TWI0_RCV_DATA16)

/* SPORT0 is not defined in the shared file because it is not available on the ADSP-BF542 and ADSP-BF544 processors */

/* SPORT1 Registers */

#define                      pSPORT1_TCR1 ((volatile unsigned short *)SPORT1_TCR1)
#define                      pSPORT1_TCR2 ((volatile unsigned short *)SPORT1_TCR2)
#define                   pSPORT1_TCLKDIV ((volatile unsigned short *)SPORT1_TCLKDIV)
#define                    pSPORT1_TFSDIV ((volatile unsigned short *)SPORT1_TFSDIV)
#define                        pSPORT1_TX ((volatile unsigned long *)SPORT1_TX)
#define                        pSPORT1_RX ((volatile unsigned long *)SPORT1_RX)
#define                      pSPORT1_RCR1 ((volatile unsigned short *)SPORT1_RCR1)
#define                      pSPORT1_RCR2 ((volatile unsigned short *)SPORT1_RCR2)
#define                   pSPORT1_RCLKDIV ((volatile unsigned short *)SPORT1_RCLKDIV)
#define                    pSPORT1_RFSDIV ((volatile unsigned short *)SPORT1_RFSDIV)
#define                      pSPORT1_STAT ((volatile unsigned short *)SPORT1_STAT)
#define                      pSPORT1_CHNL ((volatile unsigned short *)SPORT1_CHNL)
#define                     pSPORT1_MCMC1 ((volatile unsigned short *)SPORT1_MCMC1)
#define                     pSPORT1_MCMC2 ((volatile unsigned short *)SPORT1_MCMC2)
#define                     pSPORT1_MTCS0 ((volatile unsigned long *)SPORT1_MTCS0)
#define                     pSPORT1_MTCS1 ((volatile unsigned long *)SPORT1_MTCS1)
#define                     pSPORT1_MTCS2 ((volatile unsigned long *)SPORT1_MTCS2)
#define                     pSPORT1_MTCS3 ((volatile unsigned long *)SPORT1_MTCS3)
#define                     pSPORT1_MRCS0 ((volatile unsigned long *)SPORT1_MRCS0)
#define                     pSPORT1_MRCS1 ((volatile unsigned long *)SPORT1_MRCS1)
#define                     pSPORT1_MRCS2 ((volatile unsigned long *)SPORT1_MRCS2)
#define                     pSPORT1_MRCS3 ((volatile unsigned long *)SPORT1_MRCS3)

/* Asynchronous Memory Control Registers */

#define                      pEBIU_AMGCTL ((volatile unsigned short *)EBIU_AMGCTL)
#define                     pEBIU_AMBCTL0 ((volatile unsigned long *)EBIU_AMBCTL0)
#define                     pEBIU_AMBCTL1 ((volatile unsigned long *)EBIU_AMBCTL1)
#define                      pEBIU_MBSCTL ((volatile unsigned long *)EBIU_MBSCTL)
#define                     pEBIU_ARBSTAT ((volatile unsigned long *)EBIU_ARBSTAT)
#define                        pEBIU_MODE ((volatile unsigned long *)EBIU_MODE)
#define                        pEBIU_FCTL ((volatile unsigned long *)EBIU_FCTL)

/* DDR Memory Control Registers */

#define                     pEBIU_DDRCTL0 ((volatile unsigned long *)EBIU_DDRCTL0)
#define                     pEBIU_DDRCTL1 ((volatile unsigned long *)EBIU_DDRCTL1)
#define                     pEBIU_DDRCTL2 ((volatile unsigned long *)EBIU_DDRCTL2)
#define                     pEBIU_DDRCTL3 ((volatile unsigned long *)EBIU_DDRCTL3)
#define                      pEBIU_DDRQUE ((volatile unsigned long *)EBIU_DDRQUE)
#define                      pEBIU_ERRADD ((void *volatile *)EBIU_ERRADD)
#define                      pEBIU_ERRMST ((volatile unsigned short *)EBIU_ERRMST)
#define                      pEBIU_RSTCTL ((volatile unsigned short *)EBIU_RSTCTL)

/* DDR BankRead and Write Count Registers */

#define                     pEBIU_DDRBRC0 ((volatile unsigned long *)EBIU_DDRBRC0)
#define                     pEBIU_DDRBRC1 ((volatile unsigned long *)EBIU_DDRBRC1)
#define                     pEBIU_DDRBRC2 ((volatile unsigned long *)EBIU_DDRBRC2)
#define                     pEBIU_DDRBRC3 ((volatile unsigned long *)EBIU_DDRBRC3)
#define                     pEBIU_DDRBRC4 ((volatile unsigned long *)EBIU_DDRBRC4)
#define                     pEBIU_DDRBRC5 ((volatile unsigned long *)EBIU_DDRBRC5)
#define                     pEBIU_DDRBRC6 ((volatile unsigned long *)EBIU_DDRBRC6)
#define                     pEBIU_DDRBRC7 ((volatile unsigned long *)EBIU_DDRBRC7)
#define                     pEBIU_DDRBWC0 ((volatile unsigned long *)EBIU_DDRBWC0)
#define                     pEBIU_DDRBWC1 ((volatile unsigned long *)EBIU_DDRBWC1)
#define                     pEBIU_DDRBWC2 ((volatile unsigned long *)EBIU_DDRBWC2)
#define                     pEBIU_DDRBWC3 ((volatile unsigned long *)EBIU_DDRBWC3)
#define                     pEBIU_DDRBWC4 ((volatile unsigned long *)EBIU_DDRBWC4)
#define                     pEBIU_DDRBWC5 ((volatile unsigned long *)EBIU_DDRBWC5)
#define                     pEBIU_DDRBWC6 ((volatile unsigned long *)EBIU_DDRBWC6)
#define                     pEBIU_DDRBWC7 ((volatile unsigned long *)EBIU_DDRBWC7)
#define                     pEBIU_DDRACCT ((volatile unsigned long *)EBIU_DDRACCT)
#define                     pEBIU_DDRTACT ((volatile unsigned long *)EBIU_DDRTACT)
#define                     pEBIU_DDRARCT ((volatile unsigned long *)EBIU_DDRARCT)
#define                      pEBIU_DDRGC0 ((volatile unsigned long *)EBIU_DDRGC0)
#define                      pEBIU_DDRGC1 ((volatile unsigned long *)EBIU_DDRGC1)
#define                      pEBIU_DDRGC2 ((volatile unsigned long *)EBIU_DDRGC2)
#define                      pEBIU_DDRGC3 ((volatile unsigned long *)EBIU_DDRGC3)
#define                     pEBIU_DDRMCEN ((volatile unsigned long *)EBIU_DDRMCEN)
#define                     pEBIU_DDRMCCL ((volatile unsigned long *)EBIU_DDRMCCL)

/* DMAC0 Registers */

#define                      pDMAC0_TCPER ((volatile unsigned short *)DMAC0_TCPER)
#define                      pDMAC0_TCCNT ((volatile unsigned short *)DMAC0_TCCNT)

/* DMA Channel 0 Registers */

#define               pDMA0_NEXT_DESC_PTR ((void *volatile *)DMA0_NEXT_DESC_PTR)
#define                  pDMA0_START_ADDR ((void *volatile *)DMA0_START_ADDR)
#define                      pDMA0_CONFIG ((volatile unsigned short *)DMA0_CONFIG)
#define                     pDMA0_X_COUNT ((volatile unsigned short *)DMA0_X_COUNT)
#define                    pDMA0_X_MODIFY ((volatile signed short *)DMA0_X_MODIFY)
#define                     pDMA0_Y_COUNT ((volatile unsigned short *)DMA0_Y_COUNT)
#define                    pDMA0_Y_MODIFY ((volatile signed short *)DMA0_Y_MODIFY)
#define               pDMA0_CURR_DESC_PTR ((void *volatile *)DMA0_CURR_DESC_PTR)
#define                   pDMA0_CURR_ADDR ((void *volatile *)DMA0_CURR_ADDR)
#define                  pDMA0_IRQ_STATUS ((volatile unsigned short *)DMA0_IRQ_STATUS)
#define              pDMA0_PERIPHERAL_MAP ((volatile unsigned short *)DMA0_PERIPHERAL_MAP)
#define                pDMA0_CURR_X_COUNT ((volatile unsigned short *)DMA0_CURR_X_COUNT)
#define                pDMA0_CURR_Y_COUNT ((volatile unsigned short *)DMA0_CURR_Y_COUNT)

/* DMA Channel 1 Registers */

#define               pDMA1_NEXT_DESC_PTR ((void *volatile *)DMA1_NEXT_DESC_PTR)
#define                  pDMA1_START_ADDR ((void *volatile *)DMA1_START_ADDR)
#define                      pDMA1_CONFIG ((volatile unsigned short *)DMA1_CONFIG)
#define                     pDMA1_X_COUNT ((volatile unsigned short *)DMA1_X_COUNT)
#define                    pDMA1_X_MODIFY ((volatile signed short *)DMA1_X_MODIFY)
#define                     pDMA1_Y_COUNT ((volatile unsigned short *)DMA1_Y_COUNT)
#define                    pDMA1_Y_MODIFY ((volatile signed short *)DMA1_Y_MODIFY)
#define               pDMA1_CURR_DESC_PTR ((void *volatile *)DMA1_CURR_DESC_PTR)
#define                   pDMA1_CURR_ADDR ((void *volatile *)DMA1_CURR_ADDR)
#define                  pDMA1_IRQ_STATUS ((volatile unsigned short *)DMA1_IRQ_STATUS)
#define              pDMA1_PERIPHERAL_MAP ((volatile unsigned short *)DMA1_PERIPHERAL_MAP)
#define                pDMA1_CURR_X_COUNT ((volatile unsigned short *)DMA1_CURR_X_COUNT)
#define                pDMA1_CURR_Y_COUNT ((volatile unsigned short *)DMA1_CURR_Y_COUNT)

/* DMA Channel 2 Registers */

#define               pDMA2_NEXT_DESC_PTR ((void *volatile *)DMA2_NEXT_DESC_PTR)
#define                  pDMA2_START_ADDR ((void *volatile *)DMA2_START_ADDR)
#define                      pDMA2_CONFIG ((volatile unsigned short *)DMA2_CONFIG)
#define                     pDMA2_X_COUNT ((volatile unsigned short *)DMA2_X_COUNT)
#define                    pDMA2_X_MODIFY ((volatile signed short *)DMA2_X_MODIFY)
#define                     pDMA2_Y_COUNT ((volatile unsigned short *)DMA2_Y_COUNT)
#define                    pDMA2_Y_MODIFY ((volatile signed short *)DMA2_Y_MODIFY)
#define               pDMA2_CURR_DESC_PTR ((void *volatile *)DMA2_CURR_DESC_PTR)
#define                   pDMA2_CURR_ADDR ((void *volatile *)DMA2_CURR_ADDR)
#define                  pDMA2_IRQ_STATUS ((volatile unsigned short *)DMA2_IRQ_STATUS)
#define              pDMA2_PERIPHERAL_MAP ((volatile unsigned short *)DMA2_PERIPHERAL_MAP)
#define                pDMA2_CURR_X_COUNT ((volatile unsigned short *)DMA2_CURR_X_COUNT)
#define                pDMA2_CURR_Y_COUNT ((volatile unsigned short *)DMA2_CURR_Y_COUNT)

/* DMA Channel 3 Registers */

#define               pDMA3_NEXT_DESC_PTR ((void *volatile *)DMA3_NEXT_DESC_PTR)
#define                  pDMA3_START_ADDR ((void *volatile *)DMA3_START_ADDR)
#define                      pDMA3_CONFIG ((volatile unsigned short *)DMA3_CONFIG)
#define                     pDMA3_X_COUNT ((volatile unsigned short *)DMA3_X_COUNT)
#define                    pDMA3_X_MODIFY ((volatile signed short *)DMA3_X_MODIFY)
#define                     pDMA3_Y_COUNT ((volatile unsigned short *)DMA3_Y_COUNT)
#define                    pDMA3_Y_MODIFY ((volatile signed short *)DMA3_Y_MODIFY)
#define               pDMA3_CURR_DESC_PTR ((void *volatile *)DMA3_CURR_DESC_PTR)
#define                   pDMA3_CURR_ADDR ((void *volatile *)DMA3_CURR_ADDR)
#define                  pDMA3_IRQ_STATUS ((volatile unsigned short *)DMA3_IRQ_STATUS)
#define              pDMA3_PERIPHERAL_MAP ((volatile unsigned short *)DMA3_PERIPHERAL_MAP)
#define                pDMA3_CURR_X_COUNT ((volatile unsigned short *)DMA3_CURR_X_COUNT)
#define                pDMA3_CURR_Y_COUNT ((volatile unsigned short *)DMA3_CURR_Y_COUNT)

/* DMA Channel 4 Registers */

#define               pDMA4_NEXT_DESC_PTR ((void *volatile *)DMA4_NEXT_DESC_PTR)
#define                  pDMA4_START_ADDR ((void *volatile *)DMA4_START_ADDR)
#define                      pDMA4_CONFIG ((volatile unsigned short *)DMA4_CONFIG)
#define                     pDMA4_X_COUNT ((volatile unsigned short *)DMA4_X_COUNT)
#define                    pDMA4_X_MODIFY ((volatile signed short *)DMA4_X_MODIFY)
#define                     pDMA4_Y_COUNT ((volatile unsigned short *)DMA4_Y_COUNT)
#define                    pDMA4_Y_MODIFY ((volatile signed short *)DMA4_Y_MODIFY)
#define               pDMA4_CURR_DESC_PTR ((void *volatile *)DMA4_CURR_DESC_PTR)
#define                   pDMA4_CURR_ADDR ((void *volatile *)DMA4_CURR_ADDR)
#define                  pDMA4_IRQ_STATUS ((volatile unsigned short *)DMA4_IRQ_STATUS)
#define              pDMA4_PERIPHERAL_MAP ((volatile unsigned short *)DMA4_PERIPHERAL_MAP)
#define                pDMA4_CURR_X_COUNT ((volatile unsigned short *)DMA4_CURR_X_COUNT)
#define                pDMA4_CURR_Y_COUNT ((volatile unsigned short *)DMA4_CURR_Y_COUNT)

/* DMA Channel 5 Registers */

#define               pDMA5_NEXT_DESC_PTR ((void *volatile *)DMA5_NEXT_DESC_PTR)
#define                  pDMA5_START_ADDR ((void *volatile *)DMA5_START_ADDR)
#define                      pDMA5_CONFIG ((volatile unsigned short *)DMA5_CONFIG)
#define                     pDMA5_X_COUNT ((volatile unsigned short *)DMA5_X_COUNT)
#define                    pDMA5_X_MODIFY ((volatile signed short *)DMA5_X_MODIFY)
#define                     pDMA5_Y_COUNT ((volatile unsigned short *)DMA5_Y_COUNT)
#define                    pDMA5_Y_MODIFY ((volatile signed short *)DMA5_Y_MODIFY)
#define               pDMA5_CURR_DESC_PTR ((void *volatile *)DMA5_CURR_DESC_PTR)
#define                   pDMA5_CURR_ADDR ((void *volatile *)DMA5_CURR_ADDR)
#define                  pDMA5_IRQ_STATUS ((volatile unsigned short *)DMA5_IRQ_STATUS)
#define              pDMA5_PERIPHERAL_MAP ((volatile unsigned short *)DMA5_PERIPHERAL_MAP)
#define                pDMA5_CURR_X_COUNT ((volatile unsigned short *)DMA5_CURR_X_COUNT)
#define                pDMA5_CURR_Y_COUNT ((volatile unsigned short *)DMA5_CURR_Y_COUNT)

/* DMA Channel 6 Registers */

#define               pDMA6_NEXT_DESC_PTR ((void *volatile *)DMA6_NEXT_DESC_PTR)
#define                  pDMA6_START_ADDR ((void *volatile *)DMA6_START_ADDR)
#define                      pDMA6_CONFIG ((volatile unsigned short *)DMA6_CONFIG)
#define                     pDMA6_X_COUNT ((volatile unsigned short *)DMA6_X_COUNT)
#define                    pDMA6_X_MODIFY ((volatile signed short *)DMA6_X_MODIFY)
#define                     pDMA6_Y_COUNT ((volatile unsigned short *)DMA6_Y_COUNT)
#define                    pDMA6_Y_MODIFY ((volatile signed short *)DMA6_Y_MODIFY)
#define               pDMA6_CURR_DESC_PTR ((void *volatile *)DMA6_CURR_DESC_PTR)
#define                   pDMA6_CURR_ADDR ((void *volatile *)DMA6_CURR_ADDR)
#define                  pDMA6_IRQ_STATUS ((volatile unsigned short *)DMA6_IRQ_STATUS)
#define              pDMA6_PERIPHERAL_MAP ((volatile unsigned short *)DMA6_PERIPHERAL_MAP)
#define                pDMA6_CURR_X_COUNT ((volatile unsigned short *)DMA6_CURR_X_COUNT)
#define                pDMA6_CURR_Y_COUNT ((volatile unsigned short *)DMA6_CURR_Y_COUNT)

/* DMA Channel 7 Registers */

#define               pDMA7_NEXT_DESC_PTR ((void *volatile *)DMA7_NEXT_DESC_PTR)
#define                  pDMA7_START_ADDR ((void *volatile *)DMA7_START_ADDR)
#define                      pDMA7_CONFIG ((volatile unsigned short *)DMA7_CONFIG)
#define                     pDMA7_X_COUNT ((volatile unsigned short *)DMA7_X_COUNT)
#define                    pDMA7_X_MODIFY ((volatile signed short *)DMA7_X_MODIFY)
#define                     pDMA7_Y_COUNT ((volatile unsigned short *)DMA7_Y_COUNT)
#define                    pDMA7_Y_MODIFY ((volatile signed short *)DMA7_Y_MODIFY)
#define               pDMA7_CURR_DESC_PTR ((void *volatile *)DMA7_CURR_DESC_PTR)
#define                   pDMA7_CURR_ADDR ((void *volatile *)DMA7_CURR_ADDR)
#define                  pDMA7_IRQ_STATUS ((volatile unsigned short *)DMA7_IRQ_STATUS)
#define              pDMA7_PERIPHERAL_MAP ((volatile unsigned short *)DMA7_PERIPHERAL_MAP)
#define                pDMA7_CURR_X_COUNT ((volatile unsigned short *)DMA7_CURR_X_COUNT)
#define                pDMA7_CURR_Y_COUNT ((volatile unsigned short *)DMA7_CURR_Y_COUNT)

/* DMA Channel 8 Registers */

#define               pDMA8_NEXT_DESC_PTR ((void *volatile *)DMA8_NEXT_DESC_PTR)
#define                  pDMA8_START_ADDR ((void *volatile *)DMA8_START_ADDR)
#define                      pDMA8_CONFIG ((volatile unsigned short *)DMA8_CONFIG)
#define                     pDMA8_X_COUNT ((volatile unsigned short *)DMA8_X_COUNT)
#define                    pDMA8_X_MODIFY ((volatile signed short *)DMA8_X_MODIFY)
#define                     pDMA8_Y_COUNT ((volatile unsigned short *)DMA8_Y_COUNT)
#define                    pDMA8_Y_MODIFY ((volatile signed short *)DMA8_Y_MODIFY)
#define               pDMA8_CURR_DESC_PTR ((void *volatile *)DMA8_CURR_DESC_PTR)
#define                   pDMA8_CURR_ADDR ((void *volatile *)DMA8_CURR_ADDR)
#define                  pDMA8_IRQ_STATUS ((volatile unsigned short *)DMA8_IRQ_STATUS)
#define              pDMA8_PERIPHERAL_MAP ((volatile unsigned short *)DMA8_PERIPHERAL_MAP)
#define                pDMA8_CURR_X_COUNT ((volatile unsigned short *)DMA8_CURR_X_COUNT)
#define                pDMA8_CURR_Y_COUNT ((volatile unsigned short *)DMA8_CURR_Y_COUNT)

/* DMA Channel 9 Registers */

#define               pDMA9_NEXT_DESC_PTR ((void *volatile *)DMA9_NEXT_DESC_PTR)
#define                  pDMA9_START_ADDR ((void *volatile *)DMA9_START_ADDR)
#define                      pDMA9_CONFIG ((volatile unsigned short *)DMA9_CONFIG)
#define                     pDMA9_X_COUNT ((volatile unsigned short *)DMA9_X_COUNT)
#define                    pDMA9_X_MODIFY ((volatile signed short *)DMA9_X_MODIFY)
#define                     pDMA9_Y_COUNT ((volatile unsigned short *)DMA9_Y_COUNT)
#define                    pDMA9_Y_MODIFY ((volatile signed short *)DMA9_Y_MODIFY)
#define               pDMA9_CURR_DESC_PTR ((void *volatile *)DMA9_CURR_DESC_PTR)
#define                   pDMA9_CURR_ADDR ((void *volatile *)DMA9_CURR_ADDR)
#define                  pDMA9_IRQ_STATUS ((volatile unsigned short *)DMA9_IRQ_STATUS)
#define              pDMA9_PERIPHERAL_MAP ((volatile unsigned short *)DMA9_PERIPHERAL_MAP)
#define                pDMA9_CURR_X_COUNT ((volatile unsigned short *)DMA9_CURR_X_COUNT)
#define                pDMA9_CURR_Y_COUNT ((volatile unsigned short *)DMA9_CURR_Y_COUNT)

/* DMA Channel 10 Registers */

#define              pDMA10_NEXT_DESC_PTR ((void *volatile *)DMA10_NEXT_DESC_PTR)
#define                 pDMA10_START_ADDR ((void *volatile *)DMA10_START_ADDR)
#define                     pDMA10_CONFIG ((volatile unsigned short *)DMA10_CONFIG)
#define                    pDMA10_X_COUNT ((volatile unsigned short *)DMA10_X_COUNT)
#define                   pDMA10_X_MODIFY ((volatile signed short *)DMA10_X_MODIFY)
#define                    pDMA10_Y_COUNT ((volatile unsigned short *)DMA10_Y_COUNT)
#define                   pDMA10_Y_MODIFY ((volatile signed short *)DMA10_Y_MODIFY)
#define              pDMA10_CURR_DESC_PTR ((void *volatile *)DMA10_CURR_DESC_PTR)
#define                  pDMA10_CURR_ADDR ((void *volatile *)DMA10_CURR_ADDR)
#define                 pDMA10_IRQ_STATUS ((volatile unsigned short *)DMA10_IRQ_STATUS)
#define             pDMA10_PERIPHERAL_MAP ((volatile unsigned short *)DMA10_PERIPHERAL_MAP)
#define               pDMA10_CURR_X_COUNT ((volatile unsigned short *)DMA10_CURR_X_COUNT)
#define               pDMA10_CURR_Y_COUNT ((volatile unsigned short *)DMA10_CURR_Y_COUNT)

/* DMA Channel 11 Registers */

#define              pDMA11_NEXT_DESC_PTR ((void *volatile *)DMA11_NEXT_DESC_PTR)
#define                 pDMA11_START_ADDR ((void *volatile *)DMA11_START_ADDR)
#define                     pDMA11_CONFIG ((volatile unsigned short *)DMA11_CONFIG)
#define                    pDMA11_X_COUNT ((volatile unsigned short *)DMA11_X_COUNT)
#define                   pDMA11_X_MODIFY ((volatile signed short *)DMA11_X_MODIFY)
#define                    pDMA11_Y_COUNT ((volatile unsigned short *)DMA11_Y_COUNT)
#define                   pDMA11_Y_MODIFY ((volatile signed short *)DMA11_Y_MODIFY)
#define              pDMA11_CURR_DESC_PTR ((void *volatile *)DMA11_CURR_DESC_PTR)
#define                  pDMA11_CURR_ADDR ((void *volatile *)DMA11_CURR_ADDR)
#define                 pDMA11_IRQ_STATUS ((volatile unsigned short *)DMA11_IRQ_STATUS)
#define             pDMA11_PERIPHERAL_MAP ((volatile unsigned short *)DMA11_PERIPHERAL_MAP)
#define               pDMA11_CURR_X_COUNT ((volatile unsigned short *)DMA11_CURR_X_COUNT)
#define               pDMA11_CURR_Y_COUNT ((volatile unsigned short *)DMA11_CURR_Y_COUNT)

/* MDMA Stream 0 Registers */

#define            pMDMA_D0_NEXT_DESC_PTR ((void *volatile *)MDMA_D0_NEXT_DESC_PTR)
#define               pMDMA_D0_START_ADDR ((void *volatile *)MDMA_D0_START_ADDR)
#define                   pMDMA_D0_CONFIG ((volatile unsigned short *)MDMA_D0_CONFIG)
#define                  pMDMA_D0_X_COUNT ((volatile unsigned short *)MDMA_D0_X_COUNT)
#define                 pMDMA_D0_X_MODIFY ((volatile signed short *)MDMA_D0_X_MODIFY)
#define                  pMDMA_D0_Y_COUNT ((volatile unsigned short *)MDMA_D0_Y_COUNT)
#define                 pMDMA_D0_Y_MODIFY ((volatile signed short *)MDMA_D0_Y_MODIFY)
#define            pMDMA_D0_CURR_DESC_PTR ((void *volatile *)MDMA_D0_CURR_DESC_PTR)
#define                pMDMA_D0_CURR_ADDR ((void *volatile *)MDMA_D0_CURR_ADDR)
#define               pMDMA_D0_IRQ_STATUS ((volatile unsigned short *)MDMA_D0_IRQ_STATUS)
#define           pMDMA_D0_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D0_PERIPHERAL_MAP)
#define             pMDMA_D0_CURR_X_COUNT ((volatile unsigned short *)MDMA_D0_CURR_X_COUNT)
#define             pMDMA_D0_CURR_Y_COUNT ((volatile unsigned short *)MDMA_D0_CURR_Y_COUNT)
#define            pMDMA_S0_NEXT_DESC_PTR ((void *volatile *)MDMA_S0_NEXT_DESC_PTR)
#define               pMDMA_S0_START_ADDR ((void *volatile *)MDMA_S0_START_ADDR)
#define                   pMDMA_S0_CONFIG ((volatile unsigned short *)MDMA_S0_CONFIG)
#define                  pMDMA_S0_X_COUNT ((volatile unsigned short *)MDMA_S0_X_COUNT)
#define                 pMDMA_S0_X_MODIFY ((volatile signed short *)MDMA_S0_X_MODIFY)
#define                  pMDMA_S0_Y_COUNT ((volatile unsigned short *)MDMA_S0_Y_COUNT)
#define                 pMDMA_S0_Y_MODIFY ((volatile signed short *)MDMA_S0_Y_MODIFY)
#define            pMDMA_S0_CURR_DESC_PTR ((void *volatile *)MDMA_S0_CURR_DESC_PTR)
#define                pMDMA_S0_CURR_ADDR ((void *volatile *)MDMA_S0_CURR_ADDR)
#define               pMDMA_S0_IRQ_STATUS ((volatile unsigned short *)MDMA_S0_IRQ_STATUS)
#define           pMDMA_S0_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_S0_PERIPHERAL_MAP)
#define             pMDMA_S0_CURR_X_COUNT ((volatile unsigned short *)MDMA_S0_CURR_X_COUNT)
#define             pMDMA_S0_CURR_Y_COUNT ((volatile unsigned short *)MDMA_S0_CURR_Y_COUNT)

/* MDMA Stream 1 Registers */

#define            pMDMA_D1_NEXT_DESC_PTR ((void *volatile *)MDMA_D1_NEXT_DESC_PTR)
#define               pMDMA_D1_START_ADDR ((void *volatile *)MDMA_D1_START_ADDR)
#define                   pMDMA_D1_CONFIG ((volatile unsigned short *)MDMA_D1_CONFIG)
#define                  pMDMA_D1_X_COUNT ((volatile unsigned short *)MDMA_D1_X_COUNT)
#define                 pMDMA_D1_X_MODIFY ((volatile signed short *)MDMA_D1_X_MODIFY)
#define                  pMDMA_D1_Y_COUNT ((volatile unsigned short *)MDMA_D1_Y_COUNT)
#define                 pMDMA_D1_Y_MODIFY ((volatile signed short *)MDMA_D1_Y_MODIFY)
#define            pMDMA_D1_CURR_DESC_PTR ((void *volatile *)MDMA_D1_CURR_DESC_PTR)
#define                pMDMA_D1_CURR_ADDR ((void *volatile *)MDMA_D1_CURR_ADDR)
#define               pMDMA_D1_IRQ_STATUS ((volatile unsigned short *)MDMA_D1_IRQ_STATUS)
#define           pMDMA_D1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D1_PERIPHERAL_MAP)
#define             pMDMA_D1_CURR_X_COUNT ((volatile unsigned short *)MDMA_D1_CURR_X_COUNT)
#define             pMDMA_D1_CURR_Y_COUNT ((volatile unsigned short *)MDMA_D1_CURR_Y_COUNT)
#define            pMDMA_S1_NEXT_DESC_PTR ((void *volatile *)MDMA_S1_NEXT_DESC_PTR)
#define               pMDMA_S1_START_ADDR ((void *volatile *)MDMA_S1_START_ADDR)
#define                   pMDMA_S1_CONFIG ((volatile unsigned short *)MDMA_S1_CONFIG)
#define                  pMDMA_S1_X_COUNT ((volatile unsigned short *)MDMA_S1_X_COUNT)
#define                 pMDMA_S1_X_MODIFY ((volatile signed short *)MDMA_S1_X_MODIFY)
#define                  pMDMA_S1_Y_COUNT ((volatile unsigned short *)MDMA_S1_Y_COUNT)
#define                 pMDMA_S1_Y_MODIFY ((volatile signed short *)MDMA_S1_Y_MODIFY)
#define            pMDMA_S1_CURR_DESC_PTR ((void *volatile *)MDMA_S1_CURR_DESC_PTR)
#define                pMDMA_S1_CURR_ADDR ((void *volatile *)MDMA_S1_CURR_ADDR)
#define               pMDMA_S1_IRQ_STATUS ((volatile unsigned short *)MDMA_S1_IRQ_STATUS)
#define           pMDMA_S1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_S1_PERIPHERAL_MAP)
#define             pMDMA_S1_CURR_X_COUNT ((volatile unsigned short *)MDMA_S1_CURR_X_COUNT)
#define             pMDMA_S1_CURR_Y_COUNT ((volatile unsigned short *)MDMA_S1_CURR_Y_COUNT)

/* EPPI1 Registers */

#define                     pEPPI1_STATUS ((volatile unsigned short *)EPPI1_STATUS)
#define                     pEPPI1_HCOUNT ((volatile unsigned short *)EPPI1_HCOUNT)
#define                     pEPPI1_HDELAY ((volatile unsigned short *)EPPI1_HDELAY)
#define                     pEPPI1_VCOUNT ((volatile unsigned short *)EPPI1_VCOUNT)
#define                     pEPPI1_VDELAY ((volatile unsigned short *)EPPI1_VDELAY)
#define                      pEPPI1_FRAME ((volatile unsigned short *)EPPI1_FRAME)
#define                       pEPPI1_LINE ((volatile unsigned short *)EPPI1_LINE)
#define                     pEPPI1_CLKDIV ((volatile unsigned short *)EPPI1_CLKDIV)
#define                    pEPPI1_CONTROL ((volatile unsigned long *)EPPI1_CONTROL)
#define                   pEPPI1_FS1W_HBL ((volatile unsigned long *)EPPI1_FS1W_HBL)
#define                  pEPPI1_FS1P_AVPL ((volatile unsigned long *)EPPI1_FS1P_AVPL)
#define                   pEPPI1_FS2W_LVB ((volatile unsigned long *)EPPI1_FS2W_LVB)
#define                  pEPPI1_FS2P_LAVF ((volatile unsigned long *)EPPI1_FS2P_LAVF)
#define                       pEPPI1_CLIP ((volatile unsigned long *)EPPI1_CLIP)

/* Port Interrupt 0 Registers (32-bit) */

#define                   pPINT0_MASK_SET ((volatile unsigned long *)PINT0_MASK_SET)
#define                 pPINT0_MASK_CLEAR ((volatile unsigned long *)PINT0_MASK_CLEAR)
#define                    pPINT0_REQUEST ((volatile unsigned long *)PINT0_REQUEST)
#define                     pPINT0_ASSIGN ((volatile unsigned long *)PINT0_ASSIGN)
#define                   pPINT0_EDGE_SET ((volatile unsigned long *)PINT0_EDGE_SET)
#define                 pPINT0_EDGE_CLEAR ((volatile unsigned long *)PINT0_EDGE_CLEAR)
#define                 pPINT0_INVERT_SET ((volatile unsigned long *)PINT0_INVERT_SET)
#define               pPINT0_INVERT_CLEAR ((volatile unsigned long *)PINT0_INVERT_CLEAR)
#define                   pPINT0_PINSTATE ((volatile unsigned long *)PINT0_PINSTATE)
#define                      pPINT0_LATCH ((volatile unsigned long *)PINT0_LATCH)

/* Port Interrupt 1 Registers (32-bit) */

#define                   pPINT1_MASK_SET ((volatile unsigned long *)PINT1_MASK_SET)
#define                 pPINT1_MASK_CLEAR ((volatile unsigned long *)PINT1_MASK_CLEAR)
#define                    pPINT1_REQUEST ((volatile unsigned long *)PINT1_REQUEST)
#define                     pPINT1_ASSIGN ((volatile unsigned long *)PINT1_ASSIGN)
#define                   pPINT1_EDGE_SET ((volatile unsigned long *)PINT1_EDGE_SET)
#define                 pPINT1_EDGE_CLEAR ((volatile unsigned long *)PINT1_EDGE_CLEAR)
#define                 pPINT1_INVERT_SET ((volatile unsigned long *)PINT1_INVERT_SET)
#define               pPINT1_INVERT_CLEAR ((volatile unsigned long *)PINT1_INVERT_CLEAR)
#define                   pPINT1_PINSTATE ((volatile unsigned long *)PINT1_PINSTATE)
#define                      pPINT1_LATCH ((volatile unsigned long *)PINT1_LATCH)

/* Port Interrupt 2 Registers (32-bit) */

#define                   pPINT2_MASK_SET ((volatile unsigned long *)PINT2_MASK_SET)
#define                 pPINT2_MASK_CLEAR ((volatile unsigned long *)PINT2_MASK_CLEAR)
#define                    pPINT2_REQUEST ((volatile unsigned long *)PINT2_REQUEST)
#define                     pPINT2_ASSIGN ((volatile unsigned long *)PINT2_ASSIGN)
#define                   pPINT2_EDGE_SET ((volatile unsigned long *)PINT2_EDGE_SET)
#define                 pPINT2_EDGE_CLEAR ((volatile unsigned long *)PINT2_EDGE_CLEAR)
#define                 pPINT2_INVERT_SET ((volatile unsigned long *)PINT2_INVERT_SET)
#define               pPINT2_INVERT_CLEAR ((volatile unsigned long *)PINT2_INVERT_CLEAR)
#define                   pPINT2_PINSTATE ((volatile unsigned long *)PINT2_PINSTATE)
#define                      pPINT2_LATCH ((volatile unsigned long *)PINT2_LATCH)

/* Port Interrupt 3 Registers (32-bit) */

#define                   pPINT3_MASK_SET ((volatile unsigned long *)PINT3_MASK_SET)
#define                 pPINT3_MASK_CLEAR ((volatile unsigned long *)PINT3_MASK_CLEAR)
#define                    pPINT3_REQUEST ((volatile unsigned long *)PINT3_REQUEST)
#define                     pPINT3_ASSIGN ((volatile unsigned long *)PINT3_ASSIGN)
#define                   pPINT3_EDGE_SET ((volatile unsigned long *)PINT3_EDGE_SET)
#define                 pPINT3_EDGE_CLEAR ((volatile unsigned long *)PINT3_EDGE_CLEAR)
#define                 pPINT3_INVERT_SET ((volatile unsigned long *)PINT3_INVERT_SET)
#define               pPINT3_INVERT_CLEAR ((volatile unsigned long *)PINT3_INVERT_CLEAR)
#define                   pPINT3_PINSTATE ((volatile unsigned long *)PINT3_PINSTATE)
#define                      pPINT3_LATCH ((volatile unsigned long *)PINT3_LATCH)

/* Port A Registers */

#define                        pPORTA_FER ((volatile unsigned short *)PORTA_FER)
#define                            pPORTA ((volatile unsigned short *)PORTA)
#define                        pPORTA_SET ((volatile unsigned short *)PORTA_SET)
#define                      pPORTA_CLEAR ((volatile unsigned short *)PORTA_CLEAR)
#define                    pPORTA_DIR_SET ((volatile unsigned short *)PORTA_DIR_SET)
#define                  pPORTA_DIR_CLEAR ((volatile unsigned short *)PORTA_DIR_CLEAR)
#define                       pPORTA_INEN ((volatile unsigned short *)PORTA_INEN)
#define                        pPORTA_MUX ((volatile unsigned long *)PORTA_MUX)

/* Port B Registers */

#define                        pPORTB_FER ((volatile unsigned short *)PORTB_FER)
#define                            pPORTB ((volatile unsigned short *)PORTB)
#define                        pPORTB_SET ((volatile unsigned short *)PORTB_SET)
#define                      pPORTB_CLEAR ((volatile unsigned short *)PORTB_CLEAR)
#define                    pPORTB_DIR_SET ((volatile unsigned short *)PORTB_DIR_SET)
#define                  pPORTB_DIR_CLEAR ((volatile unsigned short *)PORTB_DIR_CLEAR)
#define                       pPORTB_INEN ((volatile unsigned short *)PORTB_INEN)
#define                        pPORTB_MUX ((volatile unsigned long *)PORTB_MUX)

/* Port C Registers */

#define                        pPORTC_FER ((volatile unsigned short *)PORTC_FER)
#define                            pPORTC ((volatile unsigned short *)PORTC)
#define                        pPORTC_SET ((volatile unsigned short *)PORTC_SET)
#define                      pPORTC_CLEAR ((volatile unsigned short *)PORTC_CLEAR)
#define                    pPORTC_DIR_SET ((volatile unsigned short *)PORTC_DIR_SET)
#define                  pPORTC_DIR_CLEAR ((volatile unsigned short *)PORTC_DIR_CLEAR)
#define                       pPORTC_INEN ((volatile unsigned short *)PORTC_INEN)
#define                        pPORTC_MUX ((volatile unsigned long *)PORTC_MUX)

/* Port D Registers */

#define                        pPORTD_FER ((volatile unsigned short *)PORTD_FER)
#define                            pPORTD ((volatile unsigned short *)PORTD)
#define                        pPORTD_SET ((volatile unsigned short *)PORTD_SET)
#define                      pPORTD_CLEAR ((volatile unsigned short *)PORTD_CLEAR)
#define                    pPORTD_DIR_SET ((volatile unsigned short *)PORTD_DIR_SET)
#define                  pPORTD_DIR_CLEAR ((volatile unsigned short *)PORTD_DIR_CLEAR)
#define                       pPORTD_INEN ((volatile unsigned short *)PORTD_INEN)
#define                        pPORTD_MUX ((volatile unsigned long *)PORTD_MUX)

/* Port E Registers */

#define                        pPORTE_FER ((volatile unsigned short *)PORTE_FER)
#define                            pPORTE ((volatile unsigned short *)PORTE)
#define                        pPORTE_SET ((volatile unsigned short *)PORTE_SET)
#define                      pPORTE_CLEAR ((volatile unsigned short *)PORTE_CLEAR)
#define                    pPORTE_DIR_SET ((volatile unsigned short *)PORTE_DIR_SET)
#define                  pPORTE_DIR_CLEAR ((volatile unsigned short *)PORTE_DIR_CLEAR)
#define                       pPORTE_INEN ((volatile unsigned short *)PORTE_INEN)
#define                        pPORTE_MUX ((volatile unsigned long *)PORTE_MUX)

/* Port F Registers */

#define                        pPORTF_FER ((volatile unsigned short *)PORTF_FER)
#define                            pPORTF ((volatile unsigned short *)PORTF)
#define                        pPORTF_SET ((volatile unsigned short *)PORTF_SET)
#define                      pPORTF_CLEAR ((volatile unsigned short *)PORTF_CLEAR)
#define                    pPORTF_DIR_SET ((volatile unsigned short *)PORTF_DIR_SET)
#define                  pPORTF_DIR_CLEAR ((volatile unsigned short *)PORTF_DIR_CLEAR)
#define                       pPORTF_INEN ((volatile unsigned short *)PORTF_INEN)
#define                        pPORTF_MUX ((volatile unsigned long *)PORTF_MUX)

/* Port G Registers */

#define                        pPORTG_FER ((volatile unsigned short *)PORTG_FER)
#define                            pPORTG ((volatile unsigned short *)PORTG)
#define                        pPORTG_SET ((volatile unsigned short *)PORTG_SET)
#define                      pPORTG_CLEAR ((volatile unsigned short *)PORTG_CLEAR)
#define                    pPORTG_DIR_SET ((volatile unsigned short *)PORTG_DIR_SET)
#define                  pPORTG_DIR_CLEAR ((volatile unsigned short *)PORTG_DIR_CLEAR)
#define                       pPORTG_INEN ((volatile unsigned short *)PORTG_INEN)
#define                        pPORTG_MUX ((volatile unsigned long *)PORTG_MUX)

/* Port H Registers */

#define                        pPORTH_FER ((volatile unsigned short *)PORTH_FER)
#define                            pPORTH ((volatile unsigned short *)PORTH)
#define                        pPORTH_SET ((volatile unsigned short *)PORTH_SET)
#define                      pPORTH_CLEAR ((volatile unsigned short *)PORTH_CLEAR)
#define                    pPORTH_DIR_SET ((volatile unsigned short *)PORTH_DIR_SET)
#define                  pPORTH_DIR_CLEAR ((volatile unsigned short *)PORTH_DIR_CLEAR)
#define                       pPORTH_INEN ((volatile unsigned short *)PORTH_INEN)
#define                        pPORTH_MUX ((volatile unsigned long *)PORTH_MUX)

/* Port I Registers */

#define                        pPORTI_FER ((volatile unsigned short *)PORTI_FER)
#define                            pPORTI ((volatile unsigned short *)PORTI)
#define                        pPORTI_SET ((volatile unsigned short *)PORTI_SET)
#define                      pPORTI_CLEAR ((volatile unsigned short *)PORTI_CLEAR)
#define                    pPORTI_DIR_SET ((volatile unsigned short *)PORTI_DIR_SET)
#define                  pPORTI_DIR_CLEAR ((volatile unsigned short *)PORTI_DIR_CLEAR)
#define                       pPORTI_INEN ((volatile unsigned short *)PORTI_INEN)
#define                        pPORTI_MUX ((volatile unsigned long *)PORTI_MUX)

/* Port J Registers */

#define                        pPORTJ_FER ((volatile unsigned short *)PORTJ_FER)
#define                            pPORTJ ((volatile unsigned short *)PORTJ)
#define                        pPORTJ_SET ((volatile unsigned short *)PORTJ_SET)
#define                      pPORTJ_CLEAR ((volatile unsigned short *)PORTJ_CLEAR)
#define                    pPORTJ_DIR_SET ((volatile unsigned short *)PORTJ_DIR_SET)
#define                  pPORTJ_DIR_CLEAR ((volatile unsigned short *)PORTJ_DIR_CLEAR)
#define                       pPORTJ_INEN ((volatile unsigned short *)PORTJ_INEN)
#define                        pPORTJ_MUX ((volatile unsigned long *)PORTJ_MUX)

/* PWM Timer Registers */

#define                    pTIMER0_CONFIG ((volatile unsigned short *)TIMER0_CONFIG)
#define                   pTIMER0_COUNTER ((volatile unsigned long *)TIMER0_COUNTER)
#define                    pTIMER0_PERIOD ((volatile unsigned long *)TIMER0_PERIOD)
#define                     pTIMER0_WIDTH ((volatile unsigned long *)TIMER0_WIDTH)
#define                    pTIMER1_CONFIG ((volatile unsigned short *)TIMER1_CONFIG)
#define                   pTIMER1_COUNTER ((volatile unsigned long *)TIMER1_COUNTER)
#define                    pTIMER1_PERIOD ((volatile unsigned long *)TIMER1_PERIOD)
#define                     pTIMER1_WIDTH ((volatile unsigned long *)TIMER1_WIDTH)
#define                    pTIMER2_CONFIG ((volatile unsigned short *)TIMER2_CONFIG)
#define                   pTIMER2_COUNTER ((volatile unsigned long *)TIMER2_COUNTER)
#define                    pTIMER2_PERIOD ((volatile unsigned long *)TIMER2_PERIOD)
#define                     pTIMER2_WIDTH ((volatile unsigned long *)TIMER2_WIDTH)
#define                    pTIMER3_CONFIG ((volatile unsigned short *)TIMER3_CONFIG)
#define                   pTIMER3_COUNTER ((volatile unsigned long *)TIMER3_COUNTER)
#define                    pTIMER3_PERIOD ((volatile unsigned long *)TIMER3_PERIOD)
#define                     pTIMER3_WIDTH ((volatile unsigned long *)TIMER3_WIDTH)
#define                    pTIMER4_CONFIG ((volatile unsigned short *)TIMER4_CONFIG)
#define                   pTIMER4_COUNTER ((volatile unsigned long *)TIMER4_COUNTER)
#define                    pTIMER4_PERIOD ((volatile unsigned long *)TIMER4_PERIOD)
#define                     pTIMER4_WIDTH ((volatile unsigned long *)TIMER4_WIDTH)
#define                    pTIMER5_CONFIG ((volatile unsigned short *)TIMER5_CONFIG)
#define                   pTIMER5_COUNTER ((volatile unsigned long *)TIMER5_COUNTER)
#define                    pTIMER5_PERIOD ((volatile unsigned long *)TIMER5_PERIOD)
#define                     pTIMER5_WIDTH ((volatile unsigned long *)TIMER5_WIDTH)
#define                    pTIMER6_CONFIG ((volatile unsigned short *)TIMER6_CONFIG)
#define                   pTIMER6_COUNTER ((volatile unsigned long *)TIMER6_COUNTER)
#define                    pTIMER6_PERIOD ((volatile unsigned long *)TIMER6_PERIOD)
#define                     pTIMER6_WIDTH ((volatile unsigned long *)TIMER6_WIDTH)
#define                    pTIMER7_CONFIG ((volatile unsigned short *)TIMER7_CONFIG)
#define                   pTIMER7_COUNTER ((volatile unsigned long *)TIMER7_COUNTER)
#define                    pTIMER7_PERIOD ((volatile unsigned long *)TIMER7_PERIOD)
#define                     pTIMER7_WIDTH ((volatile unsigned long *)TIMER7_WIDTH)

/* Timer Group of 8 */

#define                    pTIMER_ENABLE0 ((volatile unsigned short *)TIMER_ENABLE0)
#define                   pTIMER_DISABLE0 ((volatile unsigned short *)TIMER_DISABLE0)
#define                    pTIMER_STATUS0 ((volatile unsigned long *)TIMER_STATUS0)

/* DMAC1 Registers */

#define                      pDMAC1_TCPER ((volatile unsigned short *)DMAC1_TCPER)
#define                      pDMAC1_TCCNT ((volatile unsigned short *)DMAC1_TCCNT)

/* DMA Channel 12 Registers */

#define              pDMA12_NEXT_DESC_PTR ((void *volatile *)DMA12_NEXT_DESC_PTR)
#define                 pDMA12_START_ADDR ((void *volatile *)DMA12_START_ADDR)
#define                     pDMA12_CONFIG ((volatile unsigned short *)DMA12_CONFIG)
#define                    pDMA12_X_COUNT ((volatile unsigned short *)DMA12_X_COUNT)
#define                   pDMA12_X_MODIFY ((volatile signed short *)DMA12_X_MODIFY)
#define                    pDMA12_Y_COUNT ((volatile unsigned short *)DMA12_Y_COUNT)
#define                   pDMA12_Y_MODIFY ((volatile signed short *)DMA12_Y_MODIFY)
#define              pDMA12_CURR_DESC_PTR ((void *volatile *)DMA12_CURR_DESC_PTR)
#define                  pDMA12_CURR_ADDR ((void *volatile *)DMA12_CURR_ADDR)
#define                 pDMA12_IRQ_STATUS ((volatile unsigned short *)DMA12_IRQ_STATUS)
#define             pDMA12_PERIPHERAL_MAP ((volatile unsigned short *)DMA12_PERIPHERAL_MAP)
#define               pDMA12_CURR_X_COUNT ((volatile unsigned short *)DMA12_CURR_X_COUNT)
#define               pDMA12_CURR_Y_COUNT ((volatile unsigned short *)DMA12_CURR_Y_COUNT)

/* DMA Channel 13 Registers */

#define              pDMA13_NEXT_DESC_PTR ((void *volatile *)DMA13_NEXT_DESC_PTR)
#define                 pDMA13_START_ADDR ((void *volatile *)DMA13_START_ADDR)
#define                     pDMA13_CONFIG ((volatile unsigned short *)DMA13_CONFIG)
#define                    pDMA13_X_COUNT ((volatile unsigned short *)DMA13_X_COUNT)
#define                   pDMA13_X_MODIFY ((volatile signed short *)DMA13_X_MODIFY)
#define                    pDMA13_Y_COUNT ((volatile unsigned short *)DMA13_Y_COUNT)
#define                   pDMA13_Y_MODIFY ((volatile signed short *)DMA13_Y_MODIFY)
#define              pDMA13_CURR_DESC_PTR ((void *volatile *)DMA13_CURR_DESC_PTR)
#define                  pDMA13_CURR_ADDR ((void *volatile *)DMA13_CURR_ADDR)
#define                 pDMA13_IRQ_STATUS ((volatile unsigned short *)DMA13_IRQ_STATUS)
#define             pDMA13_PERIPHERAL_MAP ((volatile unsigned short *)DMA13_PERIPHERAL_MAP)
#define               pDMA13_CURR_X_COUNT ((volatile unsigned short *)DMA13_CURR_X_COUNT)
#define               pDMA13_CURR_Y_COUNT ((volatile unsigned short *)DMA13_CURR_Y_COUNT)

/* DMA Channel 14 Registers */

#define              pDMA14_NEXT_DESC_PTR ((void *volatile *)DMA14_NEXT_DESC_PTR)
#define                 pDMA14_START_ADDR ((void *volatile *)DMA14_START_ADDR)
#define                     pDMA14_CONFIG ((volatile unsigned short *)DMA14_CONFIG)
#define                    pDMA14_X_COUNT ((volatile unsigned short *)DMA14_X_COUNT)
#define                   pDMA14_X_MODIFY ((volatile signed short *)DMA14_X_MODIFY)
#define                    pDMA14_Y_COUNT ((volatile unsigned short *)DMA14_Y_COUNT)
#define                   pDMA14_Y_MODIFY ((volatile signed short *)DMA14_Y_MODIFY)
#define              pDMA14_CURR_DESC_PTR ((void *volatile *)DMA14_CURR_DESC_PTR)
#define                  pDMA14_CURR_ADDR ((void *volatile *)DMA14_CURR_ADDR)
#define                 pDMA14_IRQ_STATUS ((volatile unsigned short *)DMA14_IRQ_STATUS)
#define             pDMA14_PERIPHERAL_MAP ((volatile unsigned short *)DMA14_PERIPHERAL_MAP)
#define               pDMA14_CURR_X_COUNT ((volatile unsigned short *)DMA14_CURR_X_COUNT)
#define               pDMA14_CURR_Y_COUNT ((volatile unsigned short *)DMA14_CURR_Y_COUNT)

/* DMA Channel 15 Registers */

#define              pDMA15_NEXT_DESC_PTR ((void *volatile *)DMA15_NEXT_DESC_PTR)
#define                 pDMA15_START_ADDR ((void *volatile *)DMA15_START_ADDR)
#define                     pDMA15_CONFIG ((volatile unsigned short *)DMA15_CONFIG)
#define                    pDMA15_X_COUNT ((volatile unsigned short *)DMA15_X_COUNT)
#define                   pDMA15_X_MODIFY ((volatile signed short *)DMA15_X_MODIFY)
#define                    pDMA15_Y_COUNT ((volatile unsigned short *)DMA15_Y_COUNT)
#define                   pDMA15_Y_MODIFY ((volatile signed short *)DMA15_Y_MODIFY)
#define              pDMA15_CURR_DESC_PTR ((void *volatile *)DMA15_CURR_DESC_PTR)
#define                  pDMA15_CURR_ADDR ((void *volatile *)DMA15_CURR_ADDR)
#define                 pDMA15_IRQ_STATUS ((volatile unsigned short *)DMA15_IRQ_STATUS)
#define             pDMA15_PERIPHERAL_MAP ((volatile unsigned short *)DMA15_PERIPHERAL_MAP)
#define               pDMA15_CURR_X_COUNT ((volatile unsigned short *)DMA15_CURR_X_COUNT)
#define               pDMA15_CURR_Y_COUNT ((volatile unsigned short *)DMA15_CURR_Y_COUNT)

/* DMA Channel 16 Registers */

#define              pDMA16_NEXT_DESC_PTR ((void *volatile *)DMA16_NEXT_DESC_PTR)
#define                 pDMA16_START_ADDR ((void *volatile *)DMA16_START_ADDR)
#define                     pDMA16_CONFIG ((volatile unsigned short *)DMA16_CONFIG)
#define                    pDMA16_X_COUNT ((volatile unsigned short *)DMA16_X_COUNT)
#define                   pDMA16_X_MODIFY ((volatile signed short *)DMA16_X_MODIFY)
#define                    pDMA16_Y_COUNT ((volatile unsigned short *)DMA16_Y_COUNT)
#define                   pDMA16_Y_MODIFY ((volatile signed short *)DMA16_Y_MODIFY)
#define              pDMA16_CURR_DESC_PTR ((void *volatile *)DMA16_CURR_DESC_PTR)
#define                  pDMA16_CURR_ADDR ((void *volatile *)DMA16_CURR_ADDR)
#define                 pDMA16_IRQ_STATUS ((volatile unsigned short *)DMA16_IRQ_STATUS)
#define             pDMA16_PERIPHERAL_MAP ((volatile unsigned short *)DMA16_PERIPHERAL_MAP)
#define               pDMA16_CURR_X_COUNT ((volatile unsigned short *)DMA16_CURR_X_COUNT)
#define               pDMA16_CURR_Y_COUNT ((volatile unsigned short *)DMA16_CURR_Y_COUNT)

/* DMA Channel 17 Registers */

#define              pDMA17_NEXT_DESC_PTR ((void *volatile *)DMA17_NEXT_DESC_PTR)
#define                 pDMA17_START_ADDR ((void *volatile *)DMA17_START_ADDR)
#define                     pDMA17_CONFIG ((volatile unsigned short *)DMA17_CONFIG)
#define                    pDMA17_X_COUNT ((volatile unsigned short *)DMA17_X_COUNT)
#define                   pDMA17_X_MODIFY ((volatile signed short *)DMA17_X_MODIFY)
#define                    pDMA17_Y_COUNT ((volatile unsigned short *)DMA17_Y_COUNT)
#define                   pDMA17_Y_MODIFY ((volatile signed short *)DMA17_Y_MODIFY)
#define              pDMA17_CURR_DESC_PTR ((void *volatile *)DMA17_CURR_DESC_PTR)
#define                  pDMA17_CURR_ADDR ((void *volatile *)DMA17_CURR_ADDR)
#define                 pDMA17_IRQ_STATUS ((volatile unsigned short *)DMA17_IRQ_STATUS)
#define             pDMA17_PERIPHERAL_MAP ((volatile unsigned short *)DMA17_PERIPHERAL_MAP)
#define               pDMA17_CURR_X_COUNT ((volatile unsigned short *)DMA17_CURR_X_COUNT)
#define               pDMA17_CURR_Y_COUNT ((volatile unsigned short *)DMA17_CURR_Y_COUNT)

/* DMA Channel 18 Registers */

#define              pDMA18_NEXT_DESC_PTR ((void *volatile *)DMA18_NEXT_DESC_PTR)
#define                 pDMA18_START_ADDR ((void *volatile *)DMA18_START_ADDR)
#define                     pDMA18_CONFIG ((volatile unsigned short *)DMA18_CONFIG)
#define                    pDMA18_X_COUNT ((volatile unsigned short *)DMA18_X_COUNT)
#define                   pDMA18_X_MODIFY ((volatile signed short *)DMA18_X_MODIFY)
#define                    pDMA18_Y_COUNT ((volatile unsigned short *)DMA18_Y_COUNT)
#define                   pDMA18_Y_MODIFY ((volatile signed short *)DMA18_Y_MODIFY)
#define              pDMA18_CURR_DESC_PTR ((void *volatile *)DMA18_CURR_DESC_PTR)
#define                  pDMA18_CURR_ADDR ((void *volatile *)DMA18_CURR_ADDR)
#define                 pDMA18_IRQ_STATUS ((volatile unsigned short *)DMA18_IRQ_STATUS)
#define             pDMA18_PERIPHERAL_MAP ((volatile unsigned short *)DMA18_PERIPHERAL_MAP)
#define               pDMA18_CURR_X_COUNT ((volatile unsigned short *)DMA18_CURR_X_COUNT)
#define               pDMA18_CURR_Y_COUNT ((volatile unsigned short *)DMA18_CURR_Y_COUNT)

/* DMA Channel 19 Registers */

#define              pDMA19_NEXT_DESC_PTR ((void *volatile *)DMA19_NEXT_DESC_PTR)
#define                 pDMA19_START_ADDR ((void *volatile *)DMA19_START_ADDR)
#define                     pDMA19_CONFIG ((volatile unsigned short *)DMA19_CONFIG)
#define                    pDMA19_X_COUNT ((volatile unsigned short *)DMA19_X_COUNT)
#define                   pDMA19_X_MODIFY ((volatile signed short *)DMA19_X_MODIFY)
#define                    pDMA19_Y_COUNT ((volatile unsigned short *)DMA19_Y_COUNT)
#define                   pDMA19_Y_MODIFY ((volatile signed short *)DMA19_Y_MODIFY)
#define              pDMA19_CURR_DESC_PTR ((void *volatile *)DMA19_CURR_DESC_PTR)
#define                  pDMA19_CURR_ADDR ((void *volatile *)DMA19_CURR_ADDR)
#define                 pDMA19_IRQ_STATUS ((volatile unsigned short *)DMA19_IRQ_STATUS)
#define             pDMA19_PERIPHERAL_MAP ((volatile unsigned short *)DMA19_PERIPHERAL_MAP)
#define               pDMA19_CURR_X_COUNT ((volatile unsigned short *)DMA19_CURR_X_COUNT)
#define               pDMA19_CURR_Y_COUNT ((volatile unsigned short *)DMA19_CURR_Y_COUNT)

/* DMA Channel 20 Registers */

#define              pDMA20_NEXT_DESC_PTR ((void *volatile *)DMA20_NEXT_DESC_PTR)
#define                 pDMA20_START_ADDR ((void *volatile *)DMA20_START_ADDR)
#define                     pDMA20_CONFIG ((volatile unsigned short *)DMA20_CONFIG)
#define                    pDMA20_X_COUNT ((volatile unsigned short *)DMA20_X_COUNT)
#define                   pDMA20_X_MODIFY ((volatile signed short *)DMA20_X_MODIFY)
#define                    pDMA20_Y_COUNT ((volatile unsigned short *)DMA20_Y_COUNT)
#define                   pDMA20_Y_MODIFY ((volatile signed short *)DMA20_Y_MODIFY)
#define              pDMA20_CURR_DESC_PTR ((void *volatile *)DMA20_CURR_DESC_PTR)
#define                  pDMA20_CURR_ADDR ((void *volatile *)DMA20_CURR_ADDR)
#define                 pDMA20_IRQ_STATUS ((volatile unsigned short *)DMA20_IRQ_STATUS)
#define             pDMA20_PERIPHERAL_MAP ((volatile unsigned short *)DMA20_PERIPHERAL_MAP)
#define               pDMA20_CURR_X_COUNT ((volatile unsigned short *)DMA20_CURR_X_COUNT)
#define               pDMA20_CURR_Y_COUNT ((volatile unsigned short *)DMA20_CURR_Y_COUNT)

/* DMA Channel 21 Registers */

#define              pDMA21_NEXT_DESC_PTR ((void *volatile *)DMA21_NEXT_DESC_PTR)
#define                 pDMA21_START_ADDR ((void *volatile *)DMA21_START_ADDR)
#define                     pDMA21_CONFIG ((volatile unsigned short *)DMA21_CONFIG)
#define                    pDMA21_X_COUNT ((volatile unsigned short *)DMA21_X_COUNT)
#define                   pDMA21_X_MODIFY ((volatile signed short *)DMA21_X_MODIFY)
#define                    pDMA21_Y_COUNT ((volatile unsigned short *)DMA21_Y_COUNT)
#define                   pDMA21_Y_MODIFY ((volatile signed short *)DMA21_Y_MODIFY)
#define              pDMA21_CURR_DESC_PTR ((void *volatile *)DMA21_CURR_DESC_PTR)
#define                  pDMA21_CURR_ADDR ((void *volatile *)DMA21_CURR_ADDR)
#define                 pDMA21_IRQ_STATUS ((volatile unsigned short *)DMA21_IRQ_STATUS)
#define             pDMA21_PERIPHERAL_MAP ((volatile unsigned short *)DMA21_PERIPHERAL_MAP)
#define               pDMA21_CURR_X_COUNT ((volatile unsigned short *)DMA21_CURR_X_COUNT)
#define               pDMA21_CURR_Y_COUNT ((volatile unsigned short *)DMA21_CURR_Y_COUNT)

/* DMA Channel 22 Registers */

#define              pDMA22_NEXT_DESC_PTR ((void *volatile *)DMA22_NEXT_DESC_PTR)
#define                 pDMA22_START_ADDR ((void *volatile *)DMA22_START_ADDR)
#define                     pDMA22_CONFIG ((volatile unsigned short *)DMA22_CONFIG)
#define                    pDMA22_X_COUNT ((volatile unsigned short *)DMA22_X_COUNT)
#define                   pDMA22_X_MODIFY ((volatile signed short *)DMA22_X_MODIFY)
#define                    pDMA22_Y_COUNT ((volatile unsigned short *)DMA22_Y_COUNT)
#define                   pDMA22_Y_MODIFY ((volatile signed short *)DMA22_Y_MODIFY)
#define              pDMA22_CURR_DESC_PTR ((void *volatile *)DMA22_CURR_DESC_PTR)
#define                  pDMA22_CURR_ADDR ((void *volatile *)DMA22_CURR_ADDR)
#define                 pDMA22_IRQ_STATUS ((volatile unsigned short *)DMA22_IRQ_STATUS)
#define             pDMA22_PERIPHERAL_MAP ((volatile unsigned short *)DMA22_PERIPHERAL_MAP)
#define               pDMA22_CURR_X_COUNT ((volatile unsigned short *)DMA22_CURR_X_COUNT)
#define               pDMA22_CURR_Y_COUNT ((volatile unsigned short *)DMA22_CURR_Y_COUNT)

/* DMA Channel 23 Registers */

#define              pDMA23_NEXT_DESC_PTR ((void *volatile *)DMA23_NEXT_DESC_PTR)
#define                 pDMA23_START_ADDR ((void *volatile *)DMA23_START_ADDR)
#define                     pDMA23_CONFIG ((volatile unsigned short *)DMA23_CONFIG)
#define                    pDMA23_X_COUNT ((volatile unsigned short *)DMA23_X_COUNT)
#define                   pDMA23_X_MODIFY ((volatile signed short *)DMA23_X_MODIFY)
#define                    pDMA23_Y_COUNT ((volatile unsigned short *)DMA23_Y_COUNT)
#define                   pDMA23_Y_MODIFY ((volatile signed short *)DMA23_Y_MODIFY)
#define              pDMA23_CURR_DESC_PTR ((void *volatile *)DMA23_CURR_DESC_PTR)
#define                  pDMA23_CURR_ADDR ((void *volatile *)DMA23_CURR_ADDR)
#define                 pDMA23_IRQ_STATUS ((volatile unsigned short *)DMA23_IRQ_STATUS)
#define             pDMA23_PERIPHERAL_MAP ((volatile unsigned short *)DMA23_PERIPHERAL_MAP)
#define               pDMA23_CURR_X_COUNT ((volatile unsigned short *)DMA23_CURR_X_COUNT)
#define               pDMA23_CURR_Y_COUNT ((volatile unsigned short *)DMA23_CURR_Y_COUNT)

/* MDMA Stream 2 Registers */

#define            pMDMA_D2_NEXT_DESC_PTR ((void *volatile *)MDMA_D2_NEXT_DESC_PTR)
#define               pMDMA_D2_START_ADDR ((void *volatile *)MDMA_D2_START_ADDR)
#define                   pMDMA_D2_CONFIG ((volatile unsigned short *)MDMA_D2_CONFIG)
#define                  pMDMA_D2_X_COUNT ((volatile unsigned short *)MDMA_D2_X_COUNT)
#define                 pMDMA_D2_X_MODIFY ((volatile signed short *)MDMA_D2_X_MODIFY)
#define                  pMDMA_D2_Y_COUNT ((volatile unsigned short *)MDMA_D2_Y_COUNT)
#define                 pMDMA_D2_Y_MODIFY ((volatile signed short *)MDMA_D2_Y_MODIFY)
#define            pMDMA_D2_CURR_DESC_PTR ((void *volatile *)MDMA_D2_CURR_DESC_PTR)
#define                pMDMA_D2_CURR_ADDR ((void *volatile *)MDMA_D2_CURR_ADDR)
#define               pMDMA_D2_IRQ_STATUS ((volatile unsigned short *)MDMA_D2_IRQ_STATUS)
#define           pMDMA_D2_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D2_PERIPHERAL_MAP)
#define             pMDMA_D2_CURR_X_COUNT ((volatile unsigned short *)MDMA_D2_CURR_X_COUNT)
#define             pMDMA_D2_CURR_Y_COUNT ((volatile unsigned short *)MDMA_D2_CURR_Y_COUNT)
#define            pMDMA_S2_NEXT_DESC_PTR ((void *volatile *)MDMA_S2_NEXT_DESC_PTR)
#define               pMDMA_S2_START_ADDR ((void *volatile *)MDMA_S2_START_ADDR)
#define                   pMDMA_S2_CONFIG ((volatile unsigned short *)MDMA_S2_CONFIG)
#define                  pMDMA_S2_X_COUNT ((volatile unsigned short *)MDMA_S2_X_COUNT)
#define                 pMDMA_S2_X_MODIFY ((volatile signed short *)MDMA_S2_X_MODIFY)
#define                  pMDMA_S2_Y_COUNT ((volatile unsigned short *)MDMA_S2_Y_COUNT)
#define                 pMDMA_S2_Y_MODIFY ((volatile signed short *)MDMA_S2_Y_MODIFY)
#define            pMDMA_S2_CURR_DESC_PTR ((void *volatile *)MDMA_S2_CURR_DESC_PTR)
#define                pMDMA_S2_CURR_ADDR ((void *volatile *)MDMA_S2_CURR_ADDR)
#define               pMDMA_S2_IRQ_STATUS ((volatile unsigned short *)MDMA_S2_IRQ_STATUS)
#define           pMDMA_S2_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_S2_PERIPHERAL_MAP)
#define             pMDMA_S2_CURR_X_COUNT ((volatile unsigned short *)MDMA_S2_CURR_X_COUNT)
#define             pMDMA_S2_CURR_Y_COUNT ((volatile unsigned short *)MDMA_S2_CURR_Y_COUNT)

/* MDMA Stream 3 Registers */

#define            pMDMA_D3_NEXT_DESC_PTR ((void *volatile *)MDMA_D3_NEXT_DESC_PTR)
#define               pMDMA_D3_START_ADDR ((void *volatile *)MDMA_D3_START_ADDR)
#define                   pMDMA_D3_CONFIG ((volatile unsigned short *)MDMA_D3_CONFIG)
#define                  pMDMA_D3_X_COUNT ((volatile unsigned short *)MDMA_D3_X_COUNT)
#define                 pMDMA_D3_X_MODIFY ((volatile signed short *)MDMA_D3_X_MODIFY)
#define                  pMDMA_D3_Y_COUNT ((volatile unsigned short *)MDMA_D3_Y_COUNT)
#define                 pMDMA_D3_Y_MODIFY ((volatile signed short *)MDMA_D3_Y_MODIFY)
#define            pMDMA_D3_CURR_DESC_PTR ((void *volatile *)MDMA_D3_CURR_DESC_PTR)
#define                pMDMA_D3_CURR_ADDR ((void *volatile *)MDMA_D3_CURR_ADDR)
#define               pMDMA_D3_IRQ_STATUS ((volatile unsigned short *)MDMA_D3_IRQ_STATUS)
#define           pMDMA_D3_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D3_PERIPHERAL_MAP)
#define             pMDMA_D3_CURR_X_COUNT ((volatile unsigned short *)MDMA_D3_CURR_X_COUNT)
#define             pMDMA_D3_CURR_Y_COUNT ((volatile unsigned short *)MDMA_D3_CURR_Y_COUNT)
#define            pMDMA_S3_NEXT_DESC_PTR ((void *volatile *)MDMA_S3_NEXT_DESC_PTR)
#define               pMDMA_S3_START_ADDR ((void *volatile *)MDMA_S3_START_ADDR)
#define                   pMDMA_S3_CONFIG ((volatile unsigned short *)MDMA_S3_CONFIG)
#define                  pMDMA_S3_X_COUNT ((volatile unsigned short *)MDMA_S3_X_COUNT)
#define                 pMDMA_S3_X_MODIFY ((volatile signed short *)MDMA_S3_X_MODIFY)
#define                  pMDMA_S3_Y_COUNT ((volatile unsigned short *)MDMA_S3_Y_COUNT)
#define                 pMDMA_S3_Y_MODIFY ((volatile signed short *)MDMA_S3_Y_MODIFY)
#define            pMDMA_S3_CURR_DESC_PTR ((void *volatile *)MDMA_S3_CURR_DESC_PTR)
#define                pMDMA_S3_CURR_ADDR ((void *volatile *)MDMA_S3_CURR_ADDR)
#define               pMDMA_S3_IRQ_STATUS ((volatile unsigned short *)MDMA_S3_IRQ_STATUS)
#define           pMDMA_S3_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_S3_PERIPHERAL_MAP)
#define             pMDMA_S3_CURR_X_COUNT ((volatile unsigned short *)MDMA_S3_CURR_X_COUNT)
#define             pMDMA_S3_CURR_Y_COUNT ((volatile unsigned short *)MDMA_S3_CURR_Y_COUNT)

/* UART1 Registers */

#define                        pUART1_DLL ((volatile unsigned short *)UART1_DLL)
#define                        pUART1_DLH ((volatile unsigned short *)UART1_DLH)
#define                       pUART1_GCTL ((volatile unsigned short *)UART1_GCTL)
#define                        pUART1_LCR ((volatile unsigned short *)UART1_LCR)
#define                        pUART1_MCR ((volatile unsigned short *)UART1_MCR)
#define                        pUART1_LSR ((volatile unsigned short *)UART1_LSR)
#define                        pUART1_MSR ((volatile unsigned short *)UART1_MSR)
#define                        pUART1_SCR ((volatile unsigned short *)UART1_SCR)
#define                    pUART1_IER_SET ((volatile unsigned short *)UART1_IER_SET)
#define                  pUART1_IER_CLEAR ((volatile unsigned short *)UART1_IER_CLEAR)
#define                        pUART1_THR ((volatile unsigned short *)UART1_THR)
#define                        pUART1_RBR ((volatile unsigned short *)UART1_RBR)

/* UART2 is not defined in the shared file because it is not available on the ADSP-BF542 and ADSP-BF544 processors */

/* SPI1 Registers */

#define                         pSPI1_CTL ((volatile unsigned short *)SPI1_CTL)
#define                         pSPI1_FLG ((volatile unsigned short *)SPI1_FLG)
#define                        pSPI1_STAT ((volatile unsigned short *)SPI1_STAT)
#define                        pSPI1_TDBR ((volatile unsigned short *)SPI1_TDBR)
#define                        pSPI1_RDBR ((volatile unsigned short *)SPI1_RDBR)
#define                        pSPI1_BAUD ((volatile unsigned short *)SPI1_BAUD)
#define                      pSPI1_SHADOW ((volatile unsigned short *)SPI1_SHADOW)

/* SPORT2 Registers */

#define                      pSPORT2_TCR1 ((volatile unsigned short *)SPORT2_TCR1)
#define                      pSPORT2_TCR2 ((volatile unsigned short *)SPORT2_TCR2)
#define                   pSPORT2_TCLKDIV ((volatile unsigned short *)SPORT2_TCLKDIV)
#define                    pSPORT2_TFSDIV ((volatile unsigned short *)SPORT2_TFSDIV)
#define                        pSPORT2_TX ((volatile unsigned long *)SPORT2_TX)
#define                        pSPORT2_RX ((volatile unsigned long *)SPORT2_RX)
#define                      pSPORT2_RCR1 ((volatile unsigned short *)SPORT2_RCR1)
#define                      pSPORT2_RCR2 ((volatile unsigned short *)SPORT2_RCR2)
#define                   pSPORT2_RCLKDIV ((volatile unsigned short *)SPORT2_RCLKDIV)
#define                    pSPORT2_RFSDIV ((volatile unsigned short *)SPORT2_RFSDIV)
#define                      pSPORT2_STAT ((volatile unsigned short *)SPORT2_STAT)
#define                      pSPORT2_CHNL ((volatile unsigned short *)SPORT2_CHNL)
#define                     pSPORT2_MCMC1 ((volatile unsigned short *)SPORT2_MCMC1)
#define                     pSPORT2_MCMC2 ((volatile unsigned short *)SPORT2_MCMC2)
#define                     pSPORT2_MTCS0 ((volatile unsigned long *)SPORT2_MTCS0)
#define                     pSPORT2_MTCS1 ((volatile unsigned long *)SPORT2_MTCS1)
#define                     pSPORT2_MTCS2 ((volatile unsigned long *)SPORT2_MTCS2)
#define                     pSPORT2_MTCS3 ((volatile unsigned long *)SPORT2_MTCS3)
#define                     pSPORT2_MRCS0 ((volatile unsigned long *)SPORT2_MRCS0)
#define                     pSPORT2_MRCS1 ((volatile unsigned long *)SPORT2_MRCS1)
#define                     pSPORT2_MRCS2 ((volatile unsigned long *)SPORT2_MRCS2)
#define                     pSPORT2_MRCS3 ((volatile unsigned long *)SPORT2_MRCS3)

/* SPORT3 Registers */

#define                      pSPORT3_TCR1 ((volatile unsigned short *)SPORT3_TCR1)
#define                      pSPORT3_TCR2 ((volatile unsigned short *)SPORT3_TCR2)
#define                   pSPORT3_TCLKDIV ((volatile unsigned short *)SPORT3_TCLKDIV)
#define                    pSPORT3_TFSDIV ((volatile unsigned short *)SPORT3_TFSDIV)
#define                        pSPORT3_TX ((volatile unsigned long *)SPORT3_TX)
#define                        pSPORT3_RX ((volatile unsigned long *)SPORT3_RX)
#define                      pSPORT3_RCR1 ((volatile unsigned short *)SPORT3_RCR1)
#define                      pSPORT3_RCR2 ((volatile unsigned short *)SPORT3_RCR2)
#define                   pSPORT3_RCLKDIV ((volatile unsigned short *)SPORT3_RCLKDIV)
#define                    pSPORT3_RFSDIV ((volatile unsigned short *)SPORT3_RFSDIV)
#define                      pSPORT3_STAT ((volatile unsigned short *)SPORT3_STAT)
#define                      pSPORT3_CHNL ((volatile unsigned short *)SPORT3_CHNL)
#define                     pSPORT3_MCMC1 ((volatile unsigned short *)SPORT3_MCMC1)
#define                     pSPORT3_MCMC2 ((volatile unsigned short *)SPORT3_MCMC2)
#define                     pSPORT3_MTCS0 ((volatile unsigned long *)SPORT3_MTCS0)
#define                     pSPORT3_MTCS1 ((volatile unsigned long *)SPORT3_MTCS1)
#define                     pSPORT3_MTCS2 ((volatile unsigned long *)SPORT3_MTCS2)
#define                     pSPORT3_MTCS3 ((volatile unsigned long *)SPORT3_MTCS3)
#define                     pSPORT3_MRCS0 ((volatile unsigned long *)SPORT3_MRCS0)
#define                     pSPORT3_MRCS1 ((volatile unsigned long *)SPORT3_MRCS1)
#define                     pSPORT3_MRCS2 ((volatile unsigned long *)SPORT3_MRCS2)
#define                     pSPORT3_MRCS3 ((volatile unsigned long *)SPORT3_MRCS3)

/* EPPI2 Registers */

#define                     pEPPI2_STATUS ((volatile unsigned short *)EPPI2_STATUS)
#define                     pEPPI2_HCOUNT ((volatile unsigned short *)EPPI2_HCOUNT)
#define                     pEPPI2_HDELAY ((volatile unsigned short *)EPPI2_HDELAY)
#define                     pEPPI2_VCOUNT ((volatile unsigned short *)EPPI2_VCOUNT)
#define                     pEPPI2_VDELAY ((volatile unsigned short *)EPPI2_VDELAY)
#define                      pEPPI2_FRAME ((volatile unsigned short *)EPPI2_FRAME)
#define                       pEPPI2_LINE ((volatile unsigned short *)EPPI2_LINE)
#define                     pEPPI2_CLKDIV ((volatile unsigned short *)EPPI2_CLKDIV)
#define                    pEPPI2_CONTROL ((volatile unsigned long *)EPPI2_CONTROL)
#define                   pEPPI2_FS1W_HBL ((volatile unsigned long *)EPPI2_FS1W_HBL)
#define                  pEPPI2_FS1P_AVPL ((volatile unsigned long *)EPPI2_FS1P_AVPL)
#define                   pEPPI2_FS2W_LVB ((volatile unsigned long *)EPPI2_FS2W_LVB)
#define                  pEPPI2_FS2P_LAVF ((volatile unsigned long *)EPPI2_FS2P_LAVF)
#define                       pEPPI2_CLIP ((volatile unsigned long *)EPPI2_CLIP)

/* CAN Controller 0 Config 1 Registers */

#define                         pCAN0_MC1 ((volatile unsigned short *)CAN0_MC1)
#define                         pCAN0_MD1 ((volatile unsigned short *)CAN0_MD1)
#define                        pCAN0_TRS1 ((volatile unsigned short *)CAN0_TRS1)
#define                        pCAN0_TRR1 ((volatile unsigned short *)CAN0_TRR1)
#define                         pCAN0_TA1 ((volatile unsigned short *)CAN0_TA1)
#define                         pCAN0_AA1 ((volatile unsigned short *)CAN0_AA1)
#define                        pCAN0_RMP1 ((volatile unsigned short *)CAN0_RMP1)
#define                        pCAN0_RML1 ((volatile unsigned short *)CAN0_RML1)
#define                      pCAN0_MBTIF1 ((volatile unsigned short *)CAN0_MBTIF1)
#define                      pCAN0_MBRIF1 ((volatile unsigned short *)CAN0_MBRIF1)
#define                       pCAN0_MBIM1 ((volatile unsigned short *)CAN0_MBIM1)
#define                        pCAN0_RFH1 ((volatile unsigned short *)CAN0_RFH1)
#define                       pCAN0_OPSS1 ((volatile unsigned short *)CAN0_OPSS1)

/* CAN Controller 0 Config 2 Registers */

#define                         pCAN0_MC2 ((volatile unsigned short *)CAN0_MC2)
#define                         pCAN0_MD2 ((volatile unsigned short *)CAN0_MD2)
#define                        pCAN0_TRS2 ((volatile unsigned short *)CAN0_TRS2)
#define                        pCAN0_TRR2 ((volatile unsigned short *)CAN0_TRR2)
#define                         pCAN0_TA2 ((volatile unsigned short *)CAN0_TA2)
#define                         pCAN0_AA2 ((volatile unsigned short *)CAN0_AA2)
#define                        pCAN0_RMP2 ((volatile unsigned short *)CAN0_RMP2)
#define                        pCAN0_RML2 ((volatile unsigned short *)CAN0_RML2)
#define                      pCAN0_MBTIF2 ((volatile unsigned short *)CAN0_MBTIF2)
#define                      pCAN0_MBRIF2 ((volatile unsigned short *)CAN0_MBRIF2)
#define                       pCAN0_MBIM2 ((volatile unsigned short *)CAN0_MBIM2)
#define                        pCAN0_RFH2 ((volatile unsigned short *)CAN0_RFH2)
#define                       pCAN0_OPSS2 ((volatile unsigned short *)CAN0_OPSS2)

/* CAN Controller 0 Clock/Interrupt/Counter Registers */

#define                       pCAN0_CLOCK ((volatile unsigned short *)CAN0_CLOCK)
#define                      pCAN0_TIMING ((volatile unsigned short *)CAN0_TIMING)
#define                       pCAN0_DEBUG ((volatile unsigned short *)CAN0_DEBUG)
#define                      pCAN0_STATUS ((volatile unsigned short *)CAN0_STATUS)
#define                         pCAN0_CEC ((volatile unsigned short *)CAN0_CEC)
#define                         pCAN0_GIS ((volatile unsigned short *)CAN0_GIS)
#define                         pCAN0_GIM ((volatile unsigned short *)CAN0_GIM)
#define                         pCAN0_GIF ((volatile unsigned short *)CAN0_GIF)
#define                     pCAN0_CONTROL ((volatile unsigned short *)CAN0_CONTROL)
#define                        pCAN0_INTR ((volatile unsigned short *)CAN0_INTR)
#define                        pCAN0_MBTD ((volatile unsigned short *)CAN0_MBTD)
#define                         pCAN0_EWR ((volatile unsigned short *)CAN0_EWR)
#define                         pCAN0_ESR ((volatile unsigned short *)CAN0_ESR)
#define                       pCAN0_UCCNT ((volatile unsigned short *)CAN0_UCCNT)
#define                        pCAN0_UCRC ((volatile unsigned short *)CAN0_UCRC)
#define                       pCAN0_UCCNF ((volatile unsigned short *)CAN0_UCCNF)

/* CAN Controller 0 Acceptance Registers */

#define                       pCAN0_AM00L ((volatile unsigned short *)CAN0_AM00L)
#define                       pCAN0_AM00H ((volatile unsigned short *)CAN0_AM00H)
#define                       pCAN0_AM01L ((volatile unsigned short *)CAN0_AM01L)
#define                       pCAN0_AM01H ((volatile unsigned short *)CAN0_AM01H)
#define                       pCAN0_AM02L ((volatile unsigned short *)CAN0_AM02L)
#define                       pCAN0_AM02H ((volatile unsigned short *)CAN0_AM02H)
#define                       pCAN0_AM03L ((volatile unsigned short *)CAN0_AM03L)
#define                       pCAN0_AM03H ((volatile unsigned short *)CAN0_AM03H)
#define                       pCAN0_AM04L ((volatile unsigned short *)CAN0_AM04L)
#define                       pCAN0_AM04H ((volatile unsigned short *)CAN0_AM04H)
#define                       pCAN0_AM05L ((volatile unsigned short *)CAN0_AM05L)
#define                       pCAN0_AM05H ((volatile unsigned short *)CAN0_AM05H)
#define                       pCAN0_AM06L ((volatile unsigned short *)CAN0_AM06L)
#define                       pCAN0_AM06H ((volatile unsigned short *)CAN0_AM06H)
#define                       pCAN0_AM07L ((volatile unsigned short *)CAN0_AM07L)
#define                       pCAN0_AM07H ((volatile unsigned short *)CAN0_AM07H)
#define                       pCAN0_AM08L ((volatile unsigned short *)CAN0_AM08L)
#define                       pCAN0_AM08H ((volatile unsigned short *)CAN0_AM08H)
#define                       pCAN0_AM09L ((volatile unsigned short *)CAN0_AM09L)
#define                       pCAN0_AM09H ((volatile unsigned short *)CAN0_AM09H)
#define                       pCAN0_AM10L ((volatile unsigned short *)CAN0_AM10L)
#define                       pCAN0_AM10H ((volatile unsigned short *)CAN0_AM10H)
#define                       pCAN0_AM11L ((volatile unsigned short *)CAN0_AM11L)
#define                       pCAN0_AM11H ((volatile unsigned short *)CAN0_AM11H)
#define                       pCAN0_AM12L ((volatile unsigned short *)CAN0_AM12L)
#define                       pCAN0_AM12H ((volatile unsigned short *)CAN0_AM12H)
#define                       pCAN0_AM13L ((volatile unsigned short *)CAN0_AM13L)
#define                       pCAN0_AM13H ((volatile unsigned short *)CAN0_AM13H)
#define                       pCAN0_AM14L ((volatile unsigned short *)CAN0_AM14L)
#define                       pCAN0_AM14H ((volatile unsigned short *)CAN0_AM14H)
#define                       pCAN0_AM15L ((volatile unsigned short *)CAN0_AM15L)
#define                       pCAN0_AM15H ((volatile unsigned short *)CAN0_AM15H)

/* CAN Controller 0 Acceptance Registers */

#define                       pCAN0_AM16L ((volatile unsigned short *)CAN0_AM16L)
#define                       pCAN0_AM16H ((volatile unsigned short *)CAN0_AM16H)
#define                       pCAN0_AM17L ((volatile unsigned short *)CAN0_AM17L)
#define                       pCAN0_AM17H ((volatile unsigned short *)CAN0_AM17H)
#define                       pCAN0_AM18L ((volatile unsigned short *)CAN0_AM18L)
#define                       pCAN0_AM18H ((volatile unsigned short *)CAN0_AM18H)
#define                       pCAN0_AM19L ((volatile unsigned short *)CAN0_AM19L)
#define                       pCAN0_AM19H ((volatile unsigned short *)CAN0_AM19H)
#define                       pCAN0_AM20L ((volatile unsigned short *)CAN0_AM20L)
#define                       pCAN0_AM20H ((volatile unsigned short *)CAN0_AM20H)
#define                       pCAN0_AM21L ((volatile unsigned short *)CAN0_AM21L)
#define                       pCAN0_AM21H ((volatile unsigned short *)CAN0_AM21H)
#define                       pCAN0_AM22L ((volatile unsigned short *)CAN0_AM22L)
#define                       pCAN0_AM22H ((volatile unsigned short *)CAN0_AM22H)
#define                       pCAN0_AM23L ((volatile unsigned short *)CAN0_AM23L)
#define                       pCAN0_AM23H ((volatile unsigned short *)CAN0_AM23H)
#define                       pCAN0_AM24L ((volatile unsigned short *)CAN0_AM24L)
#define                       pCAN0_AM24H ((volatile unsigned short *)CAN0_AM24H)
#define                       pCAN0_AM25L ((volatile unsigned short *)CAN0_AM25L)
#define                       pCAN0_AM25H ((volatile unsigned short *)CAN0_AM25H)
#define                       pCAN0_AM26L ((volatile unsigned short *)CAN0_AM26L)
#define                       pCAN0_AM26H ((volatile unsigned short *)CAN0_AM26H)
#define                       pCAN0_AM27L ((volatile unsigned short *)CAN0_AM27L)
#define                       pCAN0_AM27H ((volatile unsigned short *)CAN0_AM27H)
#define                       pCAN0_AM28L ((volatile unsigned short *)CAN0_AM28L)
#define                       pCAN0_AM28H ((volatile unsigned short *)CAN0_AM28H)
#define                       pCAN0_AM29L ((volatile unsigned short *)CAN0_AM29L)
#define                       pCAN0_AM29H ((volatile unsigned short *)CAN0_AM29H)
#define                       pCAN0_AM30L ((volatile unsigned short *)CAN0_AM30L)
#define                       pCAN0_AM30H ((volatile unsigned short *)CAN0_AM30H)
#define                       pCAN0_AM31L ((volatile unsigned short *)CAN0_AM31L)
#define                       pCAN0_AM31H ((volatile unsigned short *)CAN0_AM31H)

/* CAN Controller 0 Mailbox Data Registers */

#define                  pCAN0_MB00_DATA0 ((volatile unsigned short *)CAN0_MB00_DATA0)
#define                  pCAN0_MB00_DATA1 ((volatile unsigned short *)CAN0_MB00_DATA1)
#define                  pCAN0_MB00_DATA2 ((volatile unsigned short *)CAN0_MB00_DATA2)
#define                  pCAN0_MB00_DATA3 ((volatile unsigned short *)CAN0_MB00_DATA3)
#define                 pCAN0_MB00_LENGTH ((volatile unsigned short *)CAN0_MB00_LENGTH)
#define              pCAN0_MB00_TIMESTAMP ((volatile unsigned short *)CAN0_MB00_TIMESTAMP)
#define                    pCAN0_MB00_ID0 ((volatile unsigned short *)CAN0_MB00_ID0)
#define                    pCAN0_MB00_ID1 ((volatile unsigned short *)CAN0_MB00_ID1)
#define                  pCAN0_MB01_DATA0 ((volatile unsigned short *)CAN0_MB01_DATA0)
#define                  pCAN0_MB01_DATA1 ((volatile unsigned short *)CAN0_MB01_DATA1)
#define                  pCAN0_MB01_DATA2 ((volatile unsigned short *)CAN0_MB01_DATA2)
#define                  pCAN0_MB01_DATA3 ((volatile unsigned short *)CAN0_MB01_DATA3)
#define                 pCAN0_MB01_LENGTH ((volatile unsigned short *)CAN0_MB01_LENGTH)
#define              pCAN0_MB01_TIMESTAMP ((volatile unsigned short *)CAN0_MB01_TIMESTAMP)
#define                    pCAN0_MB01_ID0 ((volatile unsigned short *)CAN0_MB01_ID0)
#define                    pCAN0_MB01_ID1 ((volatile unsigned short *)CAN0_MB01_ID1)
#define                  pCAN0_MB02_DATA0 ((volatile unsigned short *)CAN0_MB02_DATA0)
#define                  pCAN0_MB02_DATA1 ((volatile unsigned short *)CAN0_MB02_DATA1)
#define                  pCAN0_MB02_DATA2 ((volatile unsigned short *)CAN0_MB02_DATA2)
#define                  pCAN0_MB02_DATA3 ((volatile unsigned short *)CAN0_MB02_DATA3)
#define                 pCAN0_MB02_LENGTH ((volatile unsigned short *)CAN0_MB02_LENGTH)
#define              pCAN0_MB02_TIMESTAMP ((volatile unsigned short *)CAN0_MB02_TIMESTAMP)
#define                    pCAN0_MB02_ID0 ((volatile unsigned short *)CAN0_MB02_ID0)
#define                    pCAN0_MB02_ID1 ((volatile unsigned short *)CAN0_MB02_ID1)
#define                  pCAN0_MB03_DATA0 ((volatile unsigned short *)CAN0_MB03_DATA0)
#define                  pCAN0_MB03_DATA1 ((volatile unsigned short *)CAN0_MB03_DATA1)
#define                  pCAN0_MB03_DATA2 ((volatile unsigned short *)CAN0_MB03_DATA2)
#define                  pCAN0_MB03_DATA3 ((volatile unsigned short *)CAN0_MB03_DATA3)
#define                 pCAN0_MB03_LENGTH ((volatile unsigned short *)CAN0_MB03_LENGTH)
#define              pCAN0_MB03_TIMESTAMP ((volatile unsigned short *)CAN0_MB03_TIMESTAMP)
#define                    pCAN0_MB03_ID0 ((volatile unsigned short *)CAN0_MB03_ID0)
#define                    pCAN0_MB03_ID1 ((volatile unsigned short *)CAN0_MB03_ID1)
#define                  pCAN0_MB04_DATA0 ((volatile unsigned short *)CAN0_MB04_DATA0)
#define                  pCAN0_MB04_DATA1 ((volatile unsigned short *)CAN0_MB04_DATA1)
#define                  pCAN0_MB04_DATA2 ((volatile unsigned short *)CAN0_MB04_DATA2)
#define                  pCAN0_MB04_DATA3 ((volatile unsigned short *)CAN0_MB04_DATA3)
#define                 pCAN0_MB04_LENGTH ((volatile unsigned short *)CAN0_MB04_LENGTH)
#define              pCAN0_MB04_TIMESTAMP ((volatile unsigned short *)CAN0_MB04_TIMESTAMP)
#define                    pCAN0_MB04_ID0 ((volatile unsigned short *)CAN0_MB04_ID0)
#define                    pCAN0_MB04_ID1 ((volatile unsigned short *)CAN0_MB04_ID1)
#define                  pCAN0_MB05_DATA0 ((volatile unsigned short *)CAN0_MB05_DATA0)
#define                  pCAN0_MB05_DATA1 ((volatile unsigned short *)CAN0_MB05_DATA1)
#define                  pCAN0_MB05_DATA2 ((volatile unsigned short *)CAN0_MB05_DATA2)
#define                  pCAN0_MB05_DATA3 ((volatile unsigned short *)CAN0_MB05_DATA3)
#define                 pCAN0_MB05_LENGTH ((volatile unsigned short *)CAN0_MB05_LENGTH)
#define              pCAN0_MB05_TIMESTAMP ((volatile unsigned short *)CAN0_MB05_TIMESTAMP)
#define                    pCAN0_MB05_ID0 ((volatile unsigned short *)CAN0_MB05_ID0)
#define                    pCAN0_MB05_ID1 ((volatile unsigned short *)CAN0_MB05_ID1)
#define                  pCAN0_MB06_DATA0 ((volatile unsigned short *)CAN0_MB06_DATA0)
#define                  pCAN0_MB06_DATA1 ((volatile unsigned short *)CAN0_MB06_DATA1)
#define                  pCAN0_MB06_DATA2 ((volatile unsigned short *)CAN0_MB06_DATA2)
#define                  pCAN0_MB06_DATA3 ((volatile unsigned short *)CAN0_MB06_DATA3)
#define                 pCAN0_MB06_LENGTH ((volatile unsigned short *)CAN0_MB06_LENGTH)
#define              pCAN0_MB06_TIMESTAMP ((volatile unsigned short *)CAN0_MB06_TIMESTAMP)
#define                    pCAN0_MB06_ID0 ((volatile unsigned short *)CAN0_MB06_ID0)
#define                    pCAN0_MB06_ID1 ((volatile unsigned short *)CAN0_MB06_ID1)
#define                  pCAN0_MB07_DATA0 ((volatile unsigned short *)CAN0_MB07_DATA0)
#define                  pCAN0_MB07_DATA1 ((volatile unsigned short *)CAN0_MB07_DATA1)
#define                  pCAN0_MB07_DATA2 ((volatile unsigned short *)CAN0_MB07_DATA2)
#define                  pCAN0_MB07_DATA3 ((volatile unsigned short *)CAN0_MB07_DATA3)
#define                 pCAN0_MB07_LENGTH ((volatile unsigned short *)CAN0_MB07_LENGTH)
#define              pCAN0_MB07_TIMESTAMP ((volatile unsigned short *)CAN0_MB07_TIMESTAMP)
#define                    pCAN0_MB07_ID0 ((volatile unsigned short *)CAN0_MB07_ID0)
#define                    pCAN0_MB07_ID1 ((volatile unsigned short *)CAN0_MB07_ID1)
#define                  pCAN0_MB08_DATA0 ((volatile unsigned short *)CAN0_MB08_DATA0)
#define                  pCAN0_MB08_DATA1 ((volatile unsigned short *)CAN0_MB08_DATA1)
#define                  pCAN0_MB08_DATA2 ((volatile unsigned short *)CAN0_MB08_DATA2)
#define                  pCAN0_MB08_DATA3 ((volatile unsigned short *)CAN0_MB08_DATA3)
#define                 pCAN0_MB08_LENGTH ((volatile unsigned short *)CAN0_MB08_LENGTH)
#define              pCAN0_MB08_TIMESTAMP ((volatile unsigned short *)CAN0_MB08_TIMESTAMP)
#define                    pCAN0_MB08_ID0 ((volatile unsigned short *)CAN0_MB08_ID0)
#define                    pCAN0_MB08_ID1 ((volatile unsigned short *)CAN0_MB08_ID1)
#define                  pCAN0_MB09_DATA0 ((volatile unsigned short *)CAN0_MB09_DATA0)
#define                  pCAN0_MB09_DATA1 ((volatile unsigned short *)CAN0_MB09_DATA1)
#define                  pCAN0_MB09_DATA2 ((volatile unsigned short *)CAN0_MB09_DATA2)
#define                  pCAN0_MB09_DATA3 ((volatile unsigned short *)CAN0_MB09_DATA3)
#define                 pCAN0_MB09_LENGTH ((volatile unsigned short *)CAN0_MB09_LENGTH)
#define              pCAN0_MB09_TIMESTAMP ((volatile unsigned short *)CAN0_MB09_TIMESTAMP)
#define                    pCAN0_MB09_ID0 ((volatile unsigned short *)CAN0_MB09_ID0)
#define                    pCAN0_MB09_ID1 ((volatile unsigned short *)CAN0_MB09_ID1)
#define                  pCAN0_MB10_DATA0 ((volatile unsigned short *)CAN0_MB10_DATA0)
#define                  pCAN0_MB10_DATA1 ((volatile unsigned short *)CAN0_MB10_DATA1)
#define                  pCAN0_MB10_DATA2 ((volatile unsigned short *)CAN0_MB10_DATA2)
#define                  pCAN0_MB10_DATA3 ((volatile unsigned short *)CAN0_MB10_DATA3)
#define                 pCAN0_MB10_LENGTH ((volatile unsigned short *)CAN0_MB10_LENGTH)
#define              pCAN0_MB10_TIMESTAMP ((volatile unsigned short *)CAN0_MB10_TIMESTAMP)
#define                    pCAN0_MB10_ID0 ((volatile unsigned short *)CAN0_MB10_ID0)
#define                    pCAN0_MB10_ID1 ((volatile unsigned short *)CAN0_MB10_ID1)
#define                  pCAN0_MB11_DATA0 ((volatile unsigned short *)CAN0_MB11_DATA0)
#define                  pCAN0_MB11_DATA1 ((volatile unsigned short *)CAN0_MB11_DATA1)
#define                  pCAN0_MB11_DATA2 ((volatile unsigned short *)CAN0_MB11_DATA2)
#define                  pCAN0_MB11_DATA3 ((volatile unsigned short *)CAN0_MB11_DATA3)
#define                 pCAN0_MB11_LENGTH ((volatile unsigned short *)CAN0_MB11_LENGTH)
#define              pCAN0_MB11_TIMESTAMP ((volatile unsigned short *)CAN0_MB11_TIMESTAMP)
#define                    pCAN0_MB11_ID0 ((volatile unsigned short *)CAN0_MB11_ID0)
#define                    pCAN0_MB11_ID1 ((volatile unsigned short *)CAN0_MB11_ID1)
#define                  pCAN0_MB12_DATA0 ((volatile unsigned short *)CAN0_MB12_DATA0)
#define                  pCAN0_MB12_DATA1 ((volatile unsigned short *)CAN0_MB12_DATA1)
#define                  pCAN0_MB12_DATA2 ((volatile unsigned short *)CAN0_MB12_DATA2)
#define                  pCAN0_MB12_DATA3 ((volatile unsigned short *)CAN0_MB12_DATA3)
#define                 pCAN0_MB12_LENGTH ((volatile unsigned short *)CAN0_MB12_LENGTH)
#define              pCAN0_MB12_TIMESTAMP ((volatile unsigned short *)CAN0_MB12_TIMESTAMP)
#define                    pCAN0_MB12_ID0 ((volatile unsigned short *)CAN0_MB12_ID0)
#define                    pCAN0_MB12_ID1 ((volatile unsigned short *)CAN0_MB12_ID1)
#define                  pCAN0_MB13_DATA0 ((volatile unsigned short *)CAN0_MB13_DATA0)
#define                  pCAN0_MB13_DATA1 ((volatile unsigned short *)CAN0_MB13_DATA1)
#define                  pCAN0_MB13_DATA2 ((volatile unsigned short *)CAN0_MB13_DATA2)
#define                  pCAN0_MB13_DATA3 ((volatile unsigned short *)CAN0_MB13_DATA3)
#define                 pCAN0_MB13_LENGTH ((volatile unsigned short *)CAN0_MB13_LENGTH)
#define              pCAN0_MB13_TIMESTAMP ((volatile unsigned short *)CAN0_MB13_TIMESTAMP)
#define                    pCAN0_MB13_ID0 ((volatile unsigned short *)CAN0_MB13_ID0)
#define                    pCAN0_MB13_ID1 ((volatile unsigned short *)CAN0_MB13_ID1)
#define                  pCAN0_MB14_DATA0 ((volatile unsigned short *)CAN0_MB14_DATA0)
#define                  pCAN0_MB14_DATA1 ((volatile unsigned short *)CAN0_MB14_DATA1)
#define                  pCAN0_MB14_DATA2 ((volatile unsigned short *)CAN0_MB14_DATA2)
#define                  pCAN0_MB14_DATA3 ((volatile unsigned short *)CAN0_MB14_DATA3)
#define                 pCAN0_MB14_LENGTH ((volatile unsigned short *)CAN0_MB14_LENGTH)
#define              pCAN0_MB14_TIMESTAMP ((volatile unsigned short *)CAN0_MB14_TIMESTAMP)
#define                    pCAN0_MB14_ID0 ((volatile unsigned short *)CAN0_MB14_ID0)
#define                    pCAN0_MB14_ID1 ((volatile unsigned short *)CAN0_MB14_ID1)
#define                  pCAN0_MB15_DATA0 ((volatile unsigned short *)CAN0_MB15_DATA0)
#define                  pCAN0_MB15_DATA1 ((volatile unsigned short *)CAN0_MB15_DATA1)
#define                  pCAN0_MB15_DATA2 ((volatile unsigned short *)CAN0_MB15_DATA2)
#define                  pCAN0_MB15_DATA3 ((volatile unsigned short *)CAN0_MB15_DATA3)
#define                 pCAN0_MB15_LENGTH ((volatile unsigned short *)CAN0_MB15_LENGTH)
#define              pCAN0_MB15_TIMESTAMP ((volatile unsigned short *)CAN0_MB15_TIMESTAMP)
#define                    pCAN0_MB15_ID0 ((volatile unsigned short *)CAN0_MB15_ID0)
#define                    pCAN0_MB15_ID1 ((volatile unsigned short *)CAN0_MB15_ID1)

/* CAN Controller 0 Mailbox Data Registers */

#define                  pCAN0_MB16_DATA0 ((volatile unsigned short *)CAN0_MB16_DATA0)
#define                  pCAN0_MB16_DATA1 ((volatile unsigned short *)CAN0_MB16_DATA1)
#define                  pCAN0_MB16_DATA2 ((volatile unsigned short *)CAN0_MB16_DATA2)
#define                  pCAN0_MB16_DATA3 ((volatile unsigned short *)CAN0_MB16_DATA3)
#define                 pCAN0_MB16_LENGTH ((volatile unsigned short *)CAN0_MB16_LENGTH)
#define              pCAN0_MB16_TIMESTAMP ((volatile unsigned short *)CAN0_MB16_TIMESTAMP)
#define                    pCAN0_MB16_ID0 ((volatile unsigned short *)CAN0_MB16_ID0)
#define                    pCAN0_MB16_ID1 ((volatile unsigned short *)CAN0_MB16_ID1)
#define                  pCAN0_MB17_DATA0 ((volatile unsigned short *)CAN0_MB17_DATA0)
#define                  pCAN0_MB17_DATA1 ((volatile unsigned short *)CAN0_MB17_DATA1)
#define                  pCAN0_MB17_DATA2 ((volatile unsigned short *)CAN0_MB17_DATA2)
#define                  pCAN0_MB17_DATA3 ((volatile unsigned short *)CAN0_MB17_DATA3)
#define                 pCAN0_MB17_LENGTH ((volatile unsigned short *)CAN0_MB17_LENGTH)
#define              pCAN0_MB17_TIMESTAMP ((volatile unsigned short *)CAN0_MB17_TIMESTAMP)
#define                    pCAN0_MB17_ID0 ((volatile unsigned short *)CAN0_MB17_ID0)
#define                    pCAN0_MB17_ID1 ((volatile unsigned short *)CAN0_MB17_ID1)
#define                  pCAN0_MB18_DATA0 ((volatile unsigned short *)CAN0_MB18_DATA0)
#define                  pCAN0_MB18_DATA1 ((volatile unsigned short *)CAN0_MB18_DATA1)
#define                  pCAN0_MB18_DATA2 ((volatile unsigned short *)CAN0_MB18_DATA2)
#define                  pCAN0_MB18_DATA3 ((volatile unsigned short *)CAN0_MB18_DATA3)
#define                 pCAN0_MB18_LENGTH ((volatile unsigned short *)CAN0_MB18_LENGTH)
#define              pCAN0_MB18_TIMESTAMP ((volatile unsigned short *)CAN0_MB18_TIMESTAMP)
#define                    pCAN0_MB18_ID0 ((volatile unsigned short *)CAN0_MB18_ID0)
#define                    pCAN0_MB18_ID1 ((volatile unsigned short *)CAN0_MB18_ID1)
#define                  pCAN0_MB19_DATA0 ((volatile unsigned short *)CAN0_MB19_DATA0)
#define                  pCAN0_MB19_DATA1 ((volatile unsigned short *)CAN0_MB19_DATA1)
#define                  pCAN0_MB19_DATA2 ((volatile unsigned short *)CAN0_MB19_DATA2)
#define                  pCAN0_MB19_DATA3 ((volatile unsigned short *)CAN0_MB19_DATA3)
#define                 pCAN0_MB19_LENGTH ((volatile unsigned short *)CAN0_MB19_LENGTH)
#define              pCAN0_MB19_TIMESTAMP ((volatile unsigned short *)CAN0_MB19_TIMESTAMP)
#define                    pCAN0_MB19_ID0 ((volatile unsigned short *)CAN0_MB19_ID0)
#define                    pCAN0_MB19_ID1 ((volatile unsigned short *)CAN0_MB19_ID1)
#define                  pCAN0_MB20_DATA0 ((volatile unsigned short *)CAN0_MB20_DATA0)
#define                  pCAN0_MB20_DATA1 ((volatile unsigned short *)CAN0_MB20_DATA1)
#define                  pCAN0_MB20_DATA2 ((volatile unsigned short *)CAN0_MB20_DATA2)
#define                  pCAN0_MB20_DATA3 ((volatile unsigned short *)CAN0_MB20_DATA3)
#define                 pCAN0_MB20_LENGTH ((volatile unsigned short *)CAN0_MB20_LENGTH)
#define              pCAN0_MB20_TIMESTAMP ((volatile unsigned short *)CAN0_MB20_TIMESTAMP)
#define                    pCAN0_MB20_ID0 ((volatile unsigned short *)CAN0_MB20_ID0)
#define                    pCAN0_MB20_ID1 ((volatile unsigned short *)CAN0_MB20_ID1)
#define                  pCAN0_MB21_DATA0 ((volatile unsigned short *)CAN0_MB21_DATA0)
#define                  pCAN0_MB21_DATA1 ((volatile unsigned short *)CAN0_MB21_DATA1)
#define                  pCAN0_MB21_DATA2 ((volatile unsigned short *)CAN0_MB21_DATA2)
#define                  pCAN0_MB21_DATA3 ((volatile unsigned short *)CAN0_MB21_DATA3)
#define                 pCAN0_MB21_LENGTH ((volatile unsigned short *)CAN0_MB21_LENGTH)
#define              pCAN0_MB21_TIMESTAMP ((volatile unsigned short *)CAN0_MB21_TIMESTAMP)
#define                    pCAN0_MB21_ID0 ((volatile unsigned short *)CAN0_MB21_ID0)
#define                    pCAN0_MB21_ID1 ((volatile unsigned short *)CAN0_MB21_ID1)
#define                  pCAN0_MB22_DATA0 ((volatile unsigned short *)CAN0_MB22_DATA0)
#define                  pCAN0_MB22_DATA1 ((volatile unsigned short *)CAN0_MB22_DATA1)
#define                  pCAN0_MB22_DATA2 ((volatile unsigned short *)CAN0_MB22_DATA2)
#define                  pCAN0_MB22_DATA3 ((volatile unsigned short *)CAN0_MB22_DATA3)
#define                 pCAN0_MB22_LENGTH ((volatile unsigned short *)CAN0_MB22_LENGTH)
#define              pCAN0_MB22_TIMESTAMP ((volatile unsigned short *)CAN0_MB22_TIMESTAMP)
#define                    pCAN0_MB22_ID0 ((volatile unsigned short *)CAN0_MB22_ID0)
#define                    pCAN0_MB22_ID1 ((volatile unsigned short *)CAN0_MB22_ID1)
#define                  pCAN0_MB23_DATA0 ((volatile unsigned short *)CAN0_MB23_DATA0)
#define                  pCAN0_MB23_DATA1 ((volatile unsigned short *)CAN0_MB23_DATA1)
#define                  pCAN0_MB23_DATA2 ((volatile unsigned short *)CAN0_MB23_DATA2)
#define                  pCAN0_MB23_DATA3 ((volatile unsigned short *)CAN0_MB23_DATA3)
#define                 pCAN0_MB23_LENGTH ((volatile unsigned short *)CAN0_MB23_LENGTH)
#define              pCAN0_MB23_TIMESTAMP ((volatile unsigned short *)CAN0_MB23_TIMESTAMP)
#define                    pCAN0_MB23_ID0 ((volatile unsigned short *)CAN0_MB23_ID0)
#define                    pCAN0_MB23_ID1 ((volatile unsigned short *)CAN0_MB23_ID1)
#define                  pCAN0_MB24_DATA0 ((volatile unsigned short *)CAN0_MB24_DATA0)
#define                  pCAN0_MB24_DATA1 ((volatile unsigned short *)CAN0_MB24_DATA1)
#define                  pCAN0_MB24_DATA2 ((volatile unsigned short *)CAN0_MB24_DATA2)
#define                  pCAN0_MB24_DATA3 ((volatile unsigned short *)CAN0_MB24_DATA3)
#define                 pCAN0_MB24_LENGTH ((volatile unsigned short *)CAN0_MB24_LENGTH)
#define              pCAN0_MB24_TIMESTAMP ((volatile unsigned short *)CAN0_MB24_TIMESTAMP)
#define                    pCAN0_MB24_ID0 ((volatile unsigned short *)CAN0_MB24_ID0)
#define                    pCAN0_MB24_ID1 ((volatile unsigned short *)CAN0_MB24_ID1)
#define                  pCAN0_MB25_DATA0 ((volatile unsigned short *)CAN0_MB25_DATA0)
#define                  pCAN0_MB25_DATA1 ((volatile unsigned short *)CAN0_MB25_DATA1)
#define                  pCAN0_MB25_DATA2 ((volatile unsigned short *)CAN0_MB25_DATA2)
#define                  pCAN0_MB25_DATA3 ((volatile unsigned short *)CAN0_MB25_DATA3)
#define                 pCAN0_MB25_LENGTH ((volatile unsigned short *)CAN0_MB25_LENGTH)
#define              pCAN0_MB25_TIMESTAMP ((volatile unsigned short *)CAN0_MB25_TIMESTAMP)
#define                    pCAN0_MB25_ID0 ((volatile unsigned short *)CAN0_MB25_ID0)
#define                    pCAN0_MB25_ID1 ((volatile unsigned short *)CAN0_MB25_ID1)
#define                  pCAN0_MB26_DATA0 ((volatile unsigned short *)CAN0_MB26_DATA0)
#define                  pCAN0_MB26_DATA1 ((volatile unsigned short *)CAN0_MB26_DATA1)
#define                  pCAN0_MB26_DATA2 ((volatile unsigned short *)CAN0_MB26_DATA2)
#define                  pCAN0_MB26_DATA3 ((volatile unsigned short *)CAN0_MB26_DATA3)
#define                 pCAN0_MB26_LENGTH ((volatile unsigned short *)CAN0_MB26_LENGTH)
#define              pCAN0_MB26_TIMESTAMP ((volatile unsigned short *)CAN0_MB26_TIMESTAMP)
#define                    pCAN0_MB26_ID0 ((volatile unsigned short *)CAN0_MB26_ID0)
#define                    pCAN0_MB26_ID1 ((volatile unsigned short *)CAN0_MB26_ID1)
#define                  pCAN0_MB27_DATA0 ((volatile unsigned short *)CAN0_MB27_DATA0)
#define                  pCAN0_MB27_DATA1 ((volatile unsigned short *)CAN0_MB27_DATA1)
#define                  pCAN0_MB27_DATA2 ((volatile unsigned short *)CAN0_MB27_DATA2)
#define                  pCAN0_MB27_DATA3 ((volatile unsigned short *)CAN0_MB27_DATA3)
#define                 pCAN0_MB27_LENGTH ((volatile unsigned short *)CAN0_MB27_LENGTH)
#define              pCAN0_MB27_TIMESTAMP ((volatile unsigned short *)CAN0_MB27_TIMESTAMP)
#define                    pCAN0_MB27_ID0 ((volatile unsigned short *)CAN0_MB27_ID0)
#define                    pCAN0_MB27_ID1 ((volatile unsigned short *)CAN0_MB27_ID1)
#define                  pCAN0_MB28_DATA0 ((volatile unsigned short *)CAN0_MB28_DATA0)
#define                  pCAN0_MB28_DATA1 ((volatile unsigned short *)CAN0_MB28_DATA1)
#define                  pCAN0_MB28_DATA2 ((volatile unsigned short *)CAN0_MB28_DATA2)
#define                  pCAN0_MB28_DATA3 ((volatile unsigned short *)CAN0_MB28_DATA3)
#define                 pCAN0_MB28_LENGTH ((volatile unsigned short *)CAN0_MB28_LENGTH)
#define              pCAN0_MB28_TIMESTAMP ((volatile unsigned short *)CAN0_MB28_TIMESTAMP)
#define                    pCAN0_MB28_ID0 ((volatile unsigned short *)CAN0_MB28_ID0)
#define                    pCAN0_MB28_ID1 ((volatile unsigned short *)CAN0_MB28_ID1)
#define                  pCAN0_MB29_DATA0 ((volatile unsigned short *)CAN0_MB29_DATA0)
#define                  pCAN0_MB29_DATA1 ((volatile unsigned short *)CAN0_MB29_DATA1)
#define                  pCAN0_MB29_DATA2 ((volatile unsigned short *)CAN0_MB29_DATA2)
#define                  pCAN0_MB29_DATA3 ((volatile unsigned short *)CAN0_MB29_DATA3)
#define                 pCAN0_MB29_LENGTH ((volatile unsigned short *)CAN0_MB29_LENGTH)
#define              pCAN0_MB29_TIMESTAMP ((volatile unsigned short *)CAN0_MB29_TIMESTAMP)
#define                    pCAN0_MB29_ID0 ((volatile unsigned short *)CAN0_MB29_ID0)
#define                    pCAN0_MB29_ID1 ((volatile unsigned short *)CAN0_MB29_ID1)
#define                  pCAN0_MB30_DATA0 ((volatile unsigned short *)CAN0_MB30_DATA0)
#define                  pCAN0_MB30_DATA1 ((volatile unsigned short *)CAN0_MB30_DATA1)
#define                  pCAN0_MB30_DATA2 ((volatile unsigned short *)CAN0_MB30_DATA2)
#define                  pCAN0_MB30_DATA3 ((volatile unsigned short *)CAN0_MB30_DATA3)
#define                 pCAN0_MB30_LENGTH ((volatile unsigned short *)CAN0_MB30_LENGTH)
#define              pCAN0_MB30_TIMESTAMP ((volatile unsigned short *)CAN0_MB30_TIMESTAMP)
#define                    pCAN0_MB30_ID0 ((volatile unsigned short *)CAN0_MB30_ID0)
#define                    pCAN0_MB30_ID1 ((volatile unsigned short *)CAN0_MB30_ID1)
#define                  pCAN0_MB31_DATA0 ((volatile unsigned short *)CAN0_MB31_DATA0)
#define                  pCAN0_MB31_DATA1 ((volatile unsigned short *)CAN0_MB31_DATA1)
#define                  pCAN0_MB31_DATA2 ((volatile unsigned short *)CAN0_MB31_DATA2)
#define                  pCAN0_MB31_DATA3 ((volatile unsigned short *)CAN0_MB31_DATA3)
#define                 pCAN0_MB31_LENGTH ((volatile unsigned short *)CAN0_MB31_LENGTH)
#define              pCAN0_MB31_TIMESTAMP ((volatile unsigned short *)CAN0_MB31_TIMESTAMP)
#define                    pCAN0_MB31_ID0 ((volatile unsigned short *)CAN0_MB31_ID0)
#define                    pCAN0_MB31_ID1 ((volatile unsigned short *)CAN0_MB31_ID1)

/* UART3 Registers */

#define                        pUART3_DLL ((volatile unsigned short *)UART3_DLL)
#define                        pUART3_DLH ((volatile unsigned short *)UART3_DLH)
#define                       pUART3_GCTL ((volatile unsigned short *)UART3_GCTL)
#define                        pUART3_LCR ((volatile unsigned short *)UART3_LCR)
#define                        pUART3_MCR ((volatile unsigned short *)UART3_MCR)
#define                        pUART3_LSR ((volatile unsigned short *)UART3_LSR)
#define                        pUART3_MSR ((volatile unsigned short *)UART3_MSR)
#define                        pUART3_SCR ((volatile unsigned short *)UART3_SCR)
#define                    pUART3_IER_SET ((volatile unsigned short *)UART3_IER_SET)
#define                  pUART3_IER_CLEAR ((volatile unsigned short *)UART3_IER_CLEAR)
#define                        pUART3_THR ((volatile unsigned short *)UART3_THR)
#define                        pUART3_RBR ((volatile unsigned short *)UART3_RBR)

/* NFC Registers */

#define                          pNFC_CTL ((volatile unsigned short *)NFC_CTL)
#define                         pNFC_STAT ((volatile unsigned short *)NFC_STAT)
#define                      pNFC_IRQSTAT ((volatile unsigned short *)NFC_IRQSTAT)
#define                      pNFC_IRQMASK ((volatile unsigned short *)NFC_IRQMASK)
#define                         pNFC_ECC0 ((volatile unsigned short *)NFC_ECC0)
#define                         pNFC_ECC1 ((volatile unsigned short *)NFC_ECC1)
#define                         pNFC_ECC2 ((volatile unsigned short *)NFC_ECC2)
#define                         pNFC_ECC3 ((volatile unsigned short *)NFC_ECC3)
#define                        pNFC_COUNT ((volatile unsigned short *)NFC_COUNT)
#define                          pNFC_RST ((volatile unsigned short *)NFC_RST)
#define                        pNFC_PGCTL ((volatile unsigned short *)NFC_PGCTL)
#define                         pNFC_READ ((volatile unsigned short *)NFC_READ)
#define                         pNFC_ADDR ((volatile unsigned short *)NFC_ADDR)
#define                          pNFC_CMD ((volatile unsigned short *)NFC_CMD)
#define                      pNFC_DATA_WR ((volatile unsigned short *)NFC_DATA_WR)
#define                      pNFC_DATA_RD ((volatile unsigned short *)NFC_DATA_RD)

/* Counter Registers */

#define                       pCNT_CONFIG ((volatile unsigned short *)CNT_CONFIG)
#define                        pCNT_IMASK ((volatile unsigned short *)CNT_IMASK)
#define                       pCNT_STATUS ((volatile unsigned short *)CNT_STATUS)
#define                      pCNT_COMMAND ((volatile unsigned short *)CNT_COMMAND)
#define                     pCNT_DEBOUNCE ((volatile unsigned short *)CNT_DEBOUNCE)
#define                      pCNT_COUNTER ((volatile unsigned long *)CNT_COUNTER)
#define                          pCNT_MAX ((volatile unsigned long *)CNT_MAX)
#define                          pCNT_MIN ((volatile unsigned long *)CNT_MIN)

/* OTP/FUSE Registers */

#define                      pOTP_CONTROL ((volatile unsigned short *)OTP_CONTROL)
#define                          pOTP_BEN ((volatile unsigned short *)OTP_BEN)
#define                       pOTP_STATUS ((volatile unsigned short *)OTP_STATUS)
#define                       pOTP_TIMING ((volatile unsigned long *)OTP_TIMING)

/* Security Registers */

#define                    pSECURE_SYSSWT ((volatile unsigned long *)SECURE_SYSSWT)
#define                   pSECURE_CONTROL ((volatile unsigned short *)SECURE_CONTROL)
#define                    pSECURE_STATUS ((volatile unsigned short *)SECURE_STATUS)

/* DMA Peripheral Mux Register */

#define                    pDMAC1_PERIMUX ((volatile unsigned short *)DMAC1_PERIMUX)

/* OTP Read/Write Data Buffer Registers */

#define                        pOTP_DATA0 ((volatile unsigned long *)OTP_DATA0)
#define                        pOTP_DATA1 ((volatile unsigned long *)OTP_DATA1)
#define                        pOTP_DATA2 ((volatile unsigned long *)OTP_DATA2)
#define                        pOTP_DATA3 ((volatile unsigned long *)OTP_DATA3)

/* Handshake MDMA 0 Registers */

#define                   pHMDMA0_CONTROL ((volatile unsigned short *)HMDMA0_CONTROL)
#define                    pHMDMA0_ECINIT ((volatile unsigned short *)HMDMA0_ECINIT)
#define                    pHMDMA0_BCINIT ((volatile unsigned short *)HMDMA0_BCINIT)
#define                  pHMDMA0_ECURGENT ((volatile unsigned short *)HMDMA0_ECURGENT)
#define                pHMDMA0_ECOVERFLOW ((volatile unsigned short *)HMDMA0_ECOVERFLOW)
#define                    pHMDMA0_ECOUNT ((volatile unsigned short *)HMDMA0_ECOUNT)
#define                    pHMDMA0_BCOUNT ((volatile unsigned short *)HMDMA0_BCOUNT)

/* Handshake MDMA 1 Registers */

#define                   pHMDMA1_CONTROL ((volatile unsigned short *)HMDMA1_CONTROL)
#define                    pHMDMA1_ECINIT ((volatile unsigned short *)HMDMA1_ECINIT)
#define                    pHMDMA1_BCINIT ((volatile unsigned short *)HMDMA1_BCINIT)
#define                  pHMDMA1_ECURGENT ((volatile unsigned short *)HMDMA1_ECURGENT)
#define                pHMDMA1_ECOVERFLOW ((volatile unsigned short *)HMDMA1_ECOVERFLOW)
#define                    pHMDMA1_ECOUNT ((volatile unsigned short *)HMDMA1_ECOUNT)
#define                    pHMDMA1_BCOUNT ((volatile unsigned short *)HMDMA1_BCOUNT)

/* legacy definitions */
#define pEBIU_AMCBCTL0 pEBIU_AMBCTL0
#define pEBIU_AMCBCTL1 pEBIU_AMBCTL1
#define pPINT0_IRQ pPINT0_REQUEST
#define pPINT1_IRQ pPINT1_REQUEST
#define pPINT2_IRQ pPINT2_REQUEST
#define pPINT3_IRQ pPINT3_REQUEST

#endif /* _CDEF_BF54X_H */

