/*
 * $Id: Execute_queue.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::Execute_queue"
  Execute_queue::Execute_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
  {
    log_begin(Execute_queue,FUNCTION);

    _usage = usage_environment(usage);

// #if DEBUG_Execute_queue == true
//     log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

#ifdef MODELSIM_COSIMULATION
    {
      std::string param_id = param->id();
      
      if ((_model.get_type(_param->_type) == MODEL_VHDL) and
          (param_id != "")
          )
        {
          std::string vhdl_id = vhdl_get_id(_name);
          
          if (vhdl_id == param_id)
            {
              msgInformation(_("<%s> Use VHDL model\n"),_name.c_str());
              _usage = usage_cosimulation(_usage);
            }
          else
            {
              log_printf(TRACE,Execute_queue,FUNCTION,"get_id : %s",vhdl_id.c_str());
              log_printf(TRACE,Execute_queue,FUNCTION,"id     : %s",param_id.c_str());
            
              msgWarning(_("<%s> Can't load VHDL model, continue with SystemC model\n"),_name.c_str());
            }
        }
    }
#endif

    log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Allocation"),_name.c_str());
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Execute_queue,FUNCTION,("<%s> Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC_BODY))
      {
	log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
      }
#endif
    log_end(Execute_queue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Execute_queue::~Execute_queue"
  Execute_queue::~Execute_queue (void)
  {
    log_begin(Execute_queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
	
	delete _stat;
      }
#endif

    log_printf(INFO,Execute_queue,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Execute_queue,FUNCTION);
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
