/*
 * $Id: Meta_Predictor_Glue.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::Meta_Predictor_Glue"
  Meta_Predictor_Glue::Meta_Predictor_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

    usage_environment(_usage);

    log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Method - genMealy_update_valack"),_name.c_str());

	SC_METHOD (genMealy_update_valack);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_inst_update; ++i)
          {
            sensitive << (*(in_UPDATE_VAL [i]));

            for (uint32_t j=0; j<_param->_nb_predictor; ++j)
              sensitive << (*(in_UPDATE_PREDICTOR_ACK [j][i]));
          }

	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Method - genMealy_update"),_name.c_str());

	SC_METHOD (genMealy_update);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_inst_update; ++i)
          sensitive << (*(in_UPDATE_HISTORY     [i]))
                    << (*(in_UPDATE_HISTORY_VAL [i]))
                    << (*(in_UPDATE_DIRECTION   [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Method - genMealy_predict_valack"),_name.c_str());

	SC_METHOD (genMealy_predict_valack);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_inst_predict; ++i)
          {
            sensitive << (*(in_PREDICT_VAL [i]));

            for (uint32_t j=0; j<_param->_nb_predictor; ++j)
              sensitive << (*(in_PREDICT_PREDICTOR_ACK [j][i]));
          }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Method - genMealy_predict"),_name.c_str());

	SC_METHOD (genMealy_predict);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_inst_predict; ++i)
          for (uint32_t j=0; j<_param->_nb_predictor; ++j)
            sensitive << (*(in_PREDICT_PREDICTOR_HISTORY   [j][i]))
                      << (*(in_PREDICT_PREDICTOR_DIRECTION [j][i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Meta_Predictor_Glue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::~Meta_Predictor_Glue"
  Meta_Predictor_Glue::~Meta_Predictor_Glue (void)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Meta_Predictor_Glue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
