#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_genMealy_retire.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::genMealy_retire"
  void Register_Address_Translation_unit::genMealy_retire (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) != 0)
      {
    // Init internal update table
    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      for (uint32_t j=0; j<_param->_nb_context[i]; j++)
        {
          log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * init [%d][%d]",i,j);

          // An event occure
          // bool event = (PORT_READ(in_RETIRE_EVENT_STATE [i][j]) != EVENT_STATE_NO_EVENT);
          bool reset_update_table = (PORT_READ(in_RETIRE_EVENT_VAL [i][j]) and // always ack
                                     (PORT_READ(in_RETIRE_EVENT_STATE [i][j]) == EVENT_STATE_EVENT));

          log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * reset_update_table : %d",reset_update_table);

          // not event -> update_table == 1 -> always update
          // event     -> update_table and not reset
          for (uint32_t k=0; k<_param->_nb_general_register_logic; ++k)
            internal_rat_gpr_update_table [i][j][k] = // not event or 
                                                      (not reset_update_table and rat_gpr_update_table [i][j][k]);
          for (uint32_t k=0; k<_param->_nb_special_register_logic; ++k)
            internal_rat_spr_update_table [i][j][k] = // not event or 
                                                      (not reset_update_table and rat_spr_update_table [i][j][k]);
        }

    // RETIRE is in order -> also don't need test if an instruction is valid
    for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
      {
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * inst_retire [%d]",i);

        // init -> need't restore old value
        Tcontrol_t retire_restore_rd_phy_old = false;
        Tcontrol_t retire_restore_re_phy_old = false;

        Tcontext_t front_end_id   = (_param->_have_port_front_end_id)?PORT_READ(in_RETIRE_FRONT_END_ID [i]):0;
        Tcontext_t context_id     = (_param->_have_port_context_id  )?PORT_READ(in_RETIRE_CONTEXT_ID   [i]):0;
        Tcontrol_t retire_restore = (PORT_READ(in_RETIRE_EVENT_STATE [front_end_id][context_id]) != EVENT_STATE_NO_EVENT);

        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id         : %d",front_end_id);
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id           : %d",context_id  );
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * restore              : %d",retire_restore);

        // Test if event -> need restore ?
        if (retire_restore)
          {
            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * Have event");
                        
            // Test and update update table
            if (PORT_READ(in_RETIRE_WRITE_RD [i]))
              {
                Tgeneral_address_t rd_log = PORT_READ(in_RETIRE_NUM_REG_RD_LOG [i]);
                retire_restore_rd_phy_old = (internal_rat_gpr_update_table[front_end_id][context_id][rd_log] == 0);

//                 log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd");
//                 log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * rd_log             : %d",rd_log);
//                 log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * rat_gpr_update     : %d",internal_rat_gpr_update_table[front_end_id][context_id][rd_log]);

                internal_rat_gpr_update_table[front_end_id][context_id][rd_log] = 1;
              }
            if (PORT_READ(in_RETIRE_WRITE_RE [i]))
              {
//                 log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re");

                Tgeneral_address_t re_log = PORT_READ(in_RETIRE_NUM_REG_RE_LOG [i]);
                retire_restore_re_phy_old = (internal_rat_spr_update_table[front_end_id][context_id][re_log] == 0);
                internal_rat_spr_update_table[front_end_id][context_id][re_log] = 1;
              }

            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * restore_rd_phy_old   : %d",retire_restore_rd_phy_old);
            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * restore_re_phy_old   : %d",retire_restore_re_phy_old);
          }

        internal_RETIRE_RESTORE            [i] = retire_restore;
        internal_RETIRE_RESTORE_RD_PHY_OLD [i] = retire_restore_rd_phy_old;
        internal_RETIRE_RESTORE_RE_PHY_OLD [i] = retire_restore_re_phy_old;
              
        PORT_WRITE(out_RETIRE_RESTORE           [i], internal_RETIRE_RESTORE            [i]);
        PORT_WRITE(out_RETIRE_RESTORE_RD_PHY_OLD[i], internal_RETIRE_RESTORE_RD_PHY_OLD [i]);
        PORT_WRITE(out_RETIRE_RESTORE_RE_PHY_OLD[i], internal_RETIRE_RESTORE_RE_PHY_OLD [i]);
      }
      }

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
