#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_register_translation_unit_glue_Register_translation_unit_Glue_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_register_translation_unit_glue_Register_translation_unit_Glue_h

/*
 * $Id: Register_translation_unit_Glue.h 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


  class Register_translation_unit_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                      * _stat_nb_inst_issue_rename_select;
  private   : counter_t                      * _stat_nb_inst_issue_rename_select_req;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_commit           ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_rat_rename       ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_rat_insert       ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_free_list        ;
  private   : counter_t                      * _stat_nb_inst_issue_stall_by_stat_list        ;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET;

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_RENAME_VAL                            ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_RENAME_ACK                            ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_INSERT_VAL                            ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_INSERT_ACK                            ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_RAT_INSERT_VAL                        ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_RAT_RENAME_ACK                        ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_RAT_INSERT_ACK                        ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_FREE_LIST_VAL                         ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_FREE_LIST_ACK                         ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_FREE_LIST_GPR_VAL                     ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_FREE_LIST_SPR_VAL                     ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t)           ** out_INSERT_STAT_LIST_VAL                         ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t)           **  in_INSERT_STAT_LIST_ACK                         ;//[nb_inst_insert]

  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_DEPENDENCY_CHECKING_READ_RA           ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_DEPENDENCY_CHECKING_READ_RB           ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_DEPENDENCY_CHECKING_READ_RC           ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW;//[nb_inst_insert]

  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_STAT_LIST_READ_RA                     ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_STAT_LIST_READ_RB                     ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_STAT_LIST_READ_RC                     ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_STAT_LIST_WRITE_RD                    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RD_PHY_OLD          ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_STAT_LIST_WRITE_RE                    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RE_PHY_OLD          ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ;//[nb_inst_insert]

  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_RAT_WRITE_RD                          ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_RAT_NUM_REG_RD_LOG                    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_RAT_WRITE_RE                          ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_RAT_NUM_REG_RE_LOG                    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ;//[nb_inst_insert]

  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_READ_RA                               ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_NUM_REG_RA_PHY                        ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_READ_RB                               ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_NUM_REG_RB_PHY                        ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_READ_RC                               ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_NUM_REG_RC_PHY                        ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_WRITE_RD                              ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_NUM_REG_RD_LOG                        ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_NUM_REG_RD_PHY_OLD                    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_NUM_REG_RD_PHY_NEW                    ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_WRITE_RE                              ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_NUM_REG_RE_LOG                        ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_NUM_REG_RE_PHY_OLD                    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_NUM_REG_RE_PHY_NEW                    ;//[nb_inst_insert]

    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_RETIRE_VAL          ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t)           ** out_RETIRE_ACK          ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t)           ** out_RETIRE_RAT_VAL      ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t)           **  in_RETIRE_RAT_ACK      ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t)           ** out_RETIRE_STAT_LIST_VAL;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t)           **  in_RETIRE_STAT_LIST_ACK;//[nb_inst_retire]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef STATISTICS
  private   : Tcontrol_t                    * internal_INSERT_RENAME_ACK; //[nb_inst_insert]
#endif

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Register_translation_unit_Glue);
#endif
  public  :          Register_translation_unit_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Register_translation_unit_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif
  public  : void        genMealy_insert_valack    (void);
  public  : void        genMealy_insert           (void);
  public  : void        genMealy_retire           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
