/*
 * $Id: test.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Multiplier/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

void test (string name,
	   morpheo::behavioural::generic::multiplier::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

  if (setlocale (LC_ALL, "") == NULL)
    msg(_("setlocale ko.\n"));

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Multiplier * _Multiplier = new Multiplier 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tdata_t   > *  in_MULTIPLIER_DATA_IN_0;
  sc_signal<Tdata_t   > *  in_MULTIPLIER_DATA_IN_1;
  sc_signal<Tcontrol_t> *  in_MULTIPLIER_NSTALL   ;

  sc_signal<Tdata_t   > * out_MULTIPLIER_DATA_LSB_OUT;
  sc_signal<Tdata_t   > * out_MULTIPLIER_DATA_MSB_OUT;


  ALLOC0_SC_SIGNAL( in_MULTIPLIER_DATA_IN_0,"in_MULTIPLIER_DATA_IN_0",Tdata_t   );
  ALLOC0_SC_SIGNAL( in_MULTIPLIER_DATA_IN_1,"in_MULTIPLIER_DATA_IN_1",Tdata_t   );
  ALLOC0_SC_SIGNAL( in_MULTIPLIER_NSTALL   ,"in_MULTIPLIER_NSTALL   ",Tcontrol_t);

  ALLOC0_SC_SIGNAL(out_MULTIPLIER_DATA_LSB_OUT,"out_MULTIPLIER_DATA_LSB_OUT",Tdata_t   );
  ALLOC0_SC_SIGNAL(out_MULTIPLIER_DATA_MSB_OUT,"out_MULTIPLIER_DATA_MSB_OUT",Tdata_t   );

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Multiplier.\n"),name.c_str());

  (*(_Multiplier->in_CLOCK))        (*(in_CLOCK));
  (*(_Multiplier->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Multiplier, in_MULTIPLIER_DATA_IN_0);
  INSTANCE0_SC_SIGNAL(_Multiplier, in_MULTIPLIER_DATA_IN_1);
  INSTANCE0_SC_SIGNAL(_Multiplier, in_MULTIPLIER_NSTALL);

  INSTANCE0_SC_SIGNAL(_Multiplier,out_MULTIPLIER_DATA_LSB_OUT);
  INSTANCE0_SC_SIGNAL(_Multiplier,out_MULTIPLIER_DATA_MSB_OUT);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);
      
      uint64_t data0 = range<uint64_t>(rand(),_param->_size_data);
      uint64_t data1 = range<uint64_t>(rand(),_param->_size_data);
      
      in_MULTIPLIER_DATA_IN_0->write(static_cast<Tdata_t>(data0));
      in_MULTIPLIER_DATA_IN_1->write(static_cast<Tdata_t>(data1));
      in_MULTIPLIER_NSTALL->write(static_cast<Tcontrol_t>(1));
      
      sc_uint<32> res_lsb = 0;
      sc_uint<32> res_msb = 0;
      
      switch (_param->_size_data)
        {
        case 8 :
          {
            if (_param->_sign){ // 0 = signed, 1 = unsigned
              sc_uint<16> mask = 0xff;
              sc_uint<16> tmp = (static_cast<sc_uint<16> >(data0)) * (static_cast<sc_uint<16> >(data1));
              res_lsb = tmp.range(7,0);
              res_msb = tmp.range(15,8);
            }
            else{
              sc_int<8> data_0 = static_cast<sc_int<8> >(data0);
              sc_int<8> data_1 = static_cast<sc_int<8> >(data1);
              sc_int<16> tmp   = (static_cast<sc_int<16> >(data_0) * 
                                  static_cast<sc_int<16> >(data_1));
              res_lsb = static_cast<Tdata_t>(_param->_mask &  tmp);
              res_msb = static_cast<Tdata_t>(_param->_mask &  (tmp>>8));
            }
            break;
          }
        case 16 :
          {
            if (_param->_sign){ // 0 = signed, 1 = unsigned
              sc_uint<32> mask = 0xffff;
              sc_uint<32> tmp = (static_cast<sc_uint<32> >(data0)) * (static_cast<sc_uint<32> >(data1));
              res_lsb = tmp.range(15,0);
              res_msb = tmp.range(31,16);
            }
            else{
              sc_int<16> data_0 = static_cast<sc_int<16> >(data0);
              sc_int<16> data_1 = static_cast<sc_int<16> >(data1);
              sc_int<32> tmp    = (static_cast<sc_int<32> >(data_0) * 
                                   static_cast<sc_int<32> >(data_1));
              res_lsb = static_cast<Tdata_t>(_param->_mask &  tmp);
              res_msb = static_cast<Tdata_t>(_param->_mask &  (tmp>>16));
              
              cout << "data_0  : " << std::hex << data_0 << std::dec << " - dec : " << data_0<< endl;
              cout << "data_1  : " << std::hex << data_1 << std::dec << " - dec : " << data_1<< endl;
              cout << "tmp     : " << std::hex << tmp    << std::dec << " - dec : " << tmp   << endl;
              cout << "res_lsb : " << std::hex << res_lsb << std::dec << endl;
              cout << "res_msb : " << std::hex << res_msb << std::dec << endl;
            }
            break;
          }
        case 32 :
          {
            if (_param->_sign){ // 0 = signed, 1 = unsigned
              sc_uint<32> data_0 = static_cast<sc_uint<32> >(data0);
              sc_uint<32> data_1 = static_cast<sc_uint<32> >(data1);
              sc_uint<64> tmp = (data0) * (data1);
              res_lsb = static_cast<Tdata_t>(_param->_mask &  tmp);
              res_msb = static_cast<Tdata_t>(_param->_mask &  (tmp>>32));

              cout << "tmp : " << std::hex << tmp << std::dec << endl;
            }
            else{
              sc_int<32> data_0 = static_cast<sc_int<32> >(data0);
              sc_int<32> data_1 = static_cast<sc_int<32> >(data1);
              sc_int<64> tmp = (data0) * (data1);
              res_lsb = static_cast<Tdata_t>(_param->_mask &  tmp);
              res_msb = static_cast<Tdata_t>(_param->_mask &  (tmp>>32));

              cout << "data_0  : " << std::hex << data_0 << std::dec << endl;
              cout << "data_1  : " << std::hex << data_1 << std::dec << endl;
              cout << "tmp     : " << std::hex << tmp << std::dec << endl;
              cout << "res_lsb : " << std::hex << res_lsb << std::dec << endl;
              cout << "res_msb : " << std::hex << res_msb << std::dec << endl;


            }
            break;
          }
//         case 64 :
//           {
//             if (_param->_sign){ 0 = signed, 1 = unsigned
//               uint64_t tmp = static_cast<uint64_t>(data0) * static_cast<uint64_t>(data1);
//               res_lsb = tmp;
//             }
//             else{
//               int64_t tmp = static_cast< int64_t>(data0) * static_cast< int64_t>(data1);
//               res_lsb = 0xffffffffffffffff&tmp;
//             }
//             break;
//           }
        default :
          {
            TEST_KO("Invalid size for the test.");
          }
        }
      SC_START(_param->_latency);
      TEST(Tdata_t,out_MULTIPLIER_DATA_LSB_OUT->read(),res_lsb);
      TEST(Tdata_t,out_MULTIPLIER_DATA_MSB_OUT->read(),res_msb);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE0_SC_SIGNAL( in_MULTIPLIER_DATA_IN_0);
  DELETE0_SC_SIGNAL( in_MULTIPLIER_DATA_IN_1);
  DELETE0_SC_SIGNAL( in_MULTIPLIER_NSTALL);
  DELETE0_SC_SIGNAL(out_MULTIPLIER_DATA_LSB_OUT);
  DELETE0_SC_SIGNAL(out_MULTIPLIER_DATA_MSB_OUT);

    }
#endif

  delete _Multiplier;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
