#ifndef morpheo_behavioural_generic_registerfile_registerfile_monolithic_Parameters_h
#define morpheo_behavioural_generic_registerfile_registerfile_monolithic_Parameters_h

/*
 * $Id: Parameters.h 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  class Parameters : public morpheo::behavioural::Parameters
  {
  public : const uint32_t    _nb_port_read ;
  public : const uint32_t    _nb_port_write;
  public : const uint32_t    _nb_port_read_write;
  public : const uint32_t    _nb_word      ;
  public : const uint32_t    _size_word    ;
  public : const uint32_t    _size_address ;
  public : const bool        _have_port_address;
  public : const bool        _have_init_value;
  public : const std::string _init_value;

  public : Parameters (uint32_t    nb_port_read ,
		       uint32_t    nb_port_write,
		       uint32_t    nb_port_read_write,
		       uint32_t    nb_word      ,
		       uint32_t    size_word    ,
                       std::string init_value="");
//   public : Parameters (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters & x);
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
