#ifndef _CLASSIC_REF_COUNTER_
#define _CLASSIC_REF_COUNTER_

#include "Behavioural/include/IReferenceCounters.h"
#include <cassert>

namespace morpheo {
	namespace ReferenceCountersUtils {
	
	//*****************************************Class declaration*****************************************//
	
	class ClassicReferenceCounter : virtual public IReferenceCounter<unsigned long> {
	private:
		unsigned long m_ulReferenceCounter; 
	protected:
		inline explicit ClassicReferenceCounter(void); 
		inline ~ClassicReferenceCounter(void); 
	public:	
		inline unsigned long getReferenceCount(void) const;
		
		inline unsigned long attach(void); 
		
		inline unsigned long detach(void); 
	};	

	//**********************************Inline definition************************************************//
	
	ClassicReferenceCounter::ClassicReferenceCounter(void) : m_ulReferenceCounter(1) {}

	ClassicReferenceCounter::~ClassicReferenceCounter(void) { 
		assert( m_ulReferenceCounter == 0 || m_ulReferenceCounter == 1 );
	}
	
	unsigned long ClassicReferenceCounter::attach(void) {
		return ++m_ulReferenceCounter; 
	}
	
	unsigned long ClassicReferenceCounter::detach(void) {
		return --m_ulReferenceCounter ? m_ulReferenceCounter : (delete this , 0 ) ; 
	}

	
	unsigned long ClassicReferenceCounter::getReferenceCount(void) const {
		return m_ulReferenceCounter;
	}

	} //end of namespace ReferenceCountersUtils.
}// end of namespace morpheo.

#endif // _CLASSIC_REF_COUNTER_
 
