/*
 * $Id: Morpheo.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "TopLevel/include/Morpheo.h"
#include "Common/include/Translation.h"

namespace morpheo {

  using namespace behavioural;

#undef  FUNCTION
#define FUNCTION "Morpheo::Morpheo"
  Morpheo::Morpheo 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else		  
   std::string    name,
#endif		               
   std::string    filename_simulator, 
   std::string    filename_generator, 
   std::string    filename_instance ,
   morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void)
   )
  {
    translation ();
    
    log_begin(Morpheo,FUNCTION);

    log_printf(INFO,Morpheo,FUNCTION,_("Configuration"));
    configuration (filename_simulator,
                   filename_generator, 
                   filename_instance, 
                   get_custom_information);
 
    log_printf(INFO,Morpheo,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		_param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Morpheo,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(_param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Morpheo,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Morpheo,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }

#ifdef SYSTEMC
    // Stop alarm
    signal_init();
#endif

    log_end(Morpheo,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Morpheo::~Morpheo"
  Morpheo::~Morpheo (void)
  {
    log_begin(Morpheo,FUNCTION);

#ifdef SYSTEMC
    // Stop alarm
    alarm(0);
#endif

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Morpheo,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    delete _param_core;
    delete _config;

    log_end(Morpheo,FUNCTION);
  };

}; // end namespace morpheo
