/*
 * $Id: Morpheo_deallocation.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "TopLevel/include/Morpheo.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {

  using namespace behavioural;

#undef  FUNCTION
#define FUNCTION "Morpheo::deallocation"
  void Morpheo::deallocation (void)
  {
    log_begin(Morpheo,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL(out_ICACHE_REQ_VAL         ,_param_core->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_REQ_ACK         ,_param_core->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_param_core->_nb_icache_port,_param_core->_size_icache_thread_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_param_core->_nb_icache_port,_param_core->_size_icache_packet_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_param_core->_nb_icache_port,_param_core->_size_icache_address);
        DELETE1_SIGNAL(out_ICACHE_REQ_TYPE        ,_param_core->_nb_icache_port,_param_core->_size_icache_type);
  
        DELETE1_SIGNAL( in_ICACHE_RSP_VAL         ,_param_core->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_RSP_ACK         ,_param_core->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_param_core->_nb_icache_port,_param_core->_size_icache_thread_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_param_core->_nb_icache_port,_param_core->_size_icache_packet_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_ERROR       ,_param_core->_nb_icache_port,_param_core->_size_icache_error);
        DELETE2_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_param_core->_nb_icache_port,_param_core->_icache_nb_instruction[it1],_param_core->_size_instruction);
  
        DELETE1_SIGNAL(out_DCACHE_REQ_VAL         ,_param_core->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_REQ_ACK         ,_param_core->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_param_core->_nb_dcache_port,_param_core->_size_dcache_thread_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_param_core->_nb_dcache_port,_param_core->_size_dcache_packet_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_param_core->_nb_dcache_port,_param_core->_size_dcache_address);
        DELETE1_SIGNAL(out_DCACHE_REQ_WDATA       ,_param_core->_nb_dcache_port,_param_core->_size_dcache_data);
        DELETE1_SIGNAL(out_DCACHE_REQ_TYPE        ,_param_core->_nb_dcache_port,_param_core->_size_dcache_type);
  
        DELETE1_SIGNAL( in_DCACHE_RSP_VAL         ,_param_core->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_RSP_ACK         ,_param_core->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_param_core->_nb_dcache_port,_param_core->_size_dcache_thread_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_param_core->_nb_dcache_port,_param_core->_size_dcache_packet_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_RDATA       ,_param_core->_nb_dcache_port,_param_core->_size_dcache_data);
        DELETE1_SIGNAL( in_DCACHE_RSP_ERROR       ,_param_core->_nb_dcache_port,_param_core->_size_dcache_error);
  
        DELETE1_SIGNAL( in_INTERRUPT_ENABLE       ,_param_core->_nb_thread,1);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component_core;
    delete _component;

    log_end(Morpheo,FUNCTION);
  };

}; // end namespace morpheo
