#ifdef SYSTEMC
/*
 * $Id: Context_State_genMealy_context_event.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::genMealy_context_event"
  void Context_State::genMealy_context_event (void)
  {
    log_begin(Context_State,FUNCTION);
    log_function(Context_State,FUNCTION,_name.c_str());

    bool context_event [_param->_nb_context];

    // init
    for (uint32_t i=0; i<_param->_nb_context; ++i)
      context_event [i] = false;

    if (PORT_READ(in_NRESET))
      {
    // Commit Event ?
    if (PORT_READ(in_COMMIT_EVENT_VAL))
      {
        Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_COMMIT_EVENT_CONTEXT_ID):0;
      
        context_event [context] = true;
      }

    // Miss ?
    for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
    if (PORT_READ(in_BRANCH_COMPLETE_VAL             [i]) and
        PORT_READ(in_BRANCH_COMPLETE_MISS_PREDICTION [i]))
      {
        Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_BRANCH_COMPLETE_CONTEXT_ID [i]):0;
      
        context_event [context] = true;
      }

    for (uint32_t i=0; i<_param->_nb_context; ++i)
      PORT_WRITE(out_CONTEXT_EVENT [i], context_event [i]);
      }
//     else
//       {
//       }

    for (uint32_t i=0; i<_param->_nb_context; ++i)
      PORT_WRITE(out_CONTEXT_EVENT [i], context_event [i]);

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
