/*
 * $Id: top.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test "Execute_queue"
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#define NB_ITERATION  16
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Common/include/Test.h"
#include "Common/include/Time.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

using namespace std;
using namespace morpheo;
using namespace morpheo::behavioural;
using namespace morpheo::behavioural::core;
using namespace morpheo::behavioural::core::multi_execute_loop;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit;

using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue;

SC_MODULE(top)
{
#ifdef SYSTEMC
 private: sc_clock               *  in_CLOCK ;
 private: sc_signal<Tcontrol_t>  *  in_NRESET;

  private: sc_signal<Tcontrol_t        >    *  in_EXECUTE_QUEUE_IN_VAL           ;
  private: sc_signal<Tcontrol_t        >    * out_EXECUTE_QUEUE_IN_ACK           ;
  private: sc_signal<Tcontext_t        >    *  in_EXECUTE_QUEUE_IN_CONTEXT_ID    ;
  private: sc_signal<Tcontext_t        >    *  in_EXECUTE_QUEUE_IN_FRONT_END_ID  ;
  private: sc_signal<Tcontext_t        >    *  in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ;
  private: sc_signal<Tpacket_t         >    *  in_EXECUTE_QUEUE_IN_PACKET_ID     ;
//private: sc_signal<Toperation_t      >    *  in_EXECUTE_QUEUE_IN_OPERATION     ;
//private: sc_signal<Ttype_t           >    *  in_EXECUTE_QUEUE_IN_TYPE          ;
  private: sc_signal<Tspecial_data_t   >    *  in_EXECUTE_QUEUE_IN_FLAGS         ;
  private: sc_signal<Texception_t      >    *  in_EXECUTE_QUEUE_IN_EXCEPTION     ;
  private: sc_signal<Tcontrol_t        >    *  in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ;
  private: sc_signal<Taddress_t        >    *  in_EXECUTE_QUEUE_IN_ADDRESS       ;
  private: sc_signal<Tgeneral_data_t   >    *  in_EXECUTE_QUEUE_IN_DATA          ;

  private: sc_signal<Tcontrol_t        >    * out_EXECUTE_QUEUE_OUT_VAL          ;
  private: sc_signal<Tcontrol_t        >    *  in_EXECUTE_QUEUE_OUT_ACK          ;
  private: sc_signal<Tcontext_t        >    * out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ;
  private: sc_signal<Tcontext_t        >    * out_EXECUTE_QUEUE_OUT_FRONT_END_ID ;
  private: sc_signal<Tcontext_t        >    * out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID;
  private: sc_signal<Tpacket_t         >    * out_EXECUTE_QUEUE_OUT_PACKET_ID    ;
//private: sc_signal<Toperation_t      >    * out_EXECUTE_QUEUE_OUT_OPERATION    ;
//private: sc_signal<Ttype_t           >    * out_EXECUTE_QUEUE_OUT_TYPE         ;
  private: sc_signal<Tspecial_data_t   >    * out_EXECUTE_QUEUE_OUT_FLAGS        ;
  private: sc_signal<Texception_t      >    * out_EXECUTE_QUEUE_OUT_EXCEPTION    ;
  private: sc_signal<Tcontrol_t        >    * out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ;
  private: sc_signal<Taddress_t        >    * out_EXECUTE_QUEUE_OUT_ADDRESS      ;
  private: sc_signal<Tgeneral_data_t   >    * out_EXECUTE_QUEUE_OUT_DATA         ;

#endif

 private: std::string name;
 private: Tusage_t _usage;
 private: morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * _param;
#ifdef STATISTICS
 private: morpheo::behavioural::Parameters_Statistics * _param_stat;
#endif
 private: Execute_queue * component;

 private: void usage
    (
#ifdef MTI_SYSTEMC
     int argc, const char * const * argv
#else
     int argc, char * argv[]
#endif
     );
 private: void allocation   (void);
 private: void deallocation (void);
 public : void test         (void);

#ifdef MTI_SYSTEMC
  SC_CTOR(top::top);
#else
 public : top (sc_module_name module_name,int argc, char * argv[]);
#endif
 public : ~top(void);
};
