/*
 * $Id: Queue_deallocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::deallocation"
  void Queue::deallocation (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

//     if (usage_is_set(_usage,USE_SYSTEMC))
      { 
        DELETE0_SIGNAL( in_CLOCK ,1);
        DELETE0_SIGNAL( in_NRESET,1);

        DELETE0_SIGNAL( in_INSERT_VAL                        ,1);
        DELETE0_SIGNAL(out_INSERT_ACK                        ,1);
        DELETE0_SIGNAL( in_INSERT_DATA                       ,_param->_size_data);

        DELETE0_SIGNAL(out_RETIRE_VAL                        ,1);
        DELETE0_SIGNAL( in_RETIRE_ACK                        ,1);
        DELETE0_SIGNAL(out_RETIRE_DATA                       ,_param->_size_data);

        DELETE1_SIGNAL(out_SLOT_VAL    ,_param->_nb_port_slot,1);
        DELETE1_SIGNAL(out_SLOT_DATA   ,_param->_nb_port_slot,_param->_size_data);

        if (_param->_have_port_ptr_write)
        DELETE0_SIGNAL(out_PTR_WRITE   ,_param->_size_ptr);
        if (_param->_have_port_ptr_read )
        DELETE0_SIGNAL(out_PTR_READ    ,_param->_size_ptr);
      }
	
      if (usage_is_set(_usage,USE_SYSTEMC))
      { 
        // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        delete _queue_control;
        delete _queue_data;
      }

    delete _component;

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
