/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION 1

#include "Behavioural/@DIRECTORY/SelfTest/include/test.h"
#include "Include/Test.h"

void test (string name,
	   morpheo::behavioural::@NAMESPACE_USE::Parameters param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  @COMPONENT * _@COMPONENT = new @COMPONENT (name.c_str(),
#ifdef STATISTICS
					     morpheo::behavioural::Parameters_Statistics(5,50),
#endif
					     param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                               * CLOCK;


  string rename;

  CLOCK                                  = new sc_clock ("clock", 1.0, 0.5);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _@COMPONENT" << endl;
  
  (*(_@COMPONENT->in_CLOCK))        (*(CLOCK));

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  cout << "<" << name << "> Start Simulation ............" << endl;
  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  sc_start(0);
  _@COMPONENT->vhdl_testbench_label("Initialisation");
  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Initialisation" << endl;


  _@COMPONENT->vhdl_testbench_label("Loop of Test");
  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Loop of Test" << endl;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      _@COMPONENT->vhdl_testbench_label("Iteration "+toString(iteration));

      sc_start(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  cout << "<" << name << "> ............ Stop Simulation" << endl;

#endif

  delete _@COMPONENT;
}
